/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.newsletter.config.NewsletterUserConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterManageUserHandler {
    private static Log log = ExoLogger.getLogger(NewsletterManageUserHandler.class);
    private RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
    private ThreadLocalSessionProviderService threadLocalSessionProviderService = (ThreadLocalSessionProviderService)ThreadLocalSessionProviderService.class.cast(ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ThreadLocalSessionProviderService.class));
    private String repository;
    private String workspace;

    public NewsletterManageUserHandler(String repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
    }

    private NewsletterUserConfig getUserFromNode(Node userNode) throws Exception {
        NewsletterUserConfig user = new NewsletterUserConfig();
        user.setMail(userNode.getProperty("exo:newsletterUserMail").getString());
        user.setBanned(userNode.getProperty("exo:newsletterUserBanned").getBoolean());
        return user;
    }

    private List<String> convertValuesToArray(Value[] values) {
        ArrayList<String> listString = new ArrayList<String>();
        for (Value value : values) {
            try {
                listString.add(value.getString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listString;
    }

    public List<String> getAllAdministrator(String portalName) {
        try {
            Session session;
            Node categoriesNode;
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
            if (sessionProvider == null) {
                sessionProvider = SessionProvider.createSystemProvider();
            }
            if ((categoriesNode = (Node)(session = sessionProvider.getSession(this.workspace, manageableRepository)).getItem(NewsletterConstant.generateCategoryPath(portalName))).hasProperty("exo:newsletteraddministrator")) {
                return this.convertValuesToArray(categoriesNode.getProperty("exo:newsletteraddministrator").getValues());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return new ArrayList<String>();
    }

    public void addAdministrator(String portalName, String userId) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
        if (sessionProvider == null) {
            sessionProvider = SessionProvider.createSystemProvider();
        }
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        Node categoriesNode = (Node)session.getItem(NewsletterConstant.generateCategoryPath(portalName));
        ArrayList<String> listUsers = new ArrayList<String>();
        if (categoriesNode.hasProperty("exo:newsletteraddministrator")) {
            listUsers.addAll(this.convertValuesToArray(categoriesNode.getProperty("exo:newsletteraddministrator").getValues()));
        }
        if (listUsers.contains(userId)) {
            return;
        }
        listUsers.add(userId);
        categoriesNode.setProperty("exo:newsletteraddministrator", listUsers.toArray(new String[0]));
        session.save();
    }

    public void deleteUserAddministrator(String portalName, String userId) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
        if (sessionProvider == null) {
            sessionProvider = SessionProvider.createSystemProvider();
        }
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        Node categoriesNode = (Node)session.getItem(NewsletterConstant.generateCategoryPath(portalName));
        ArrayList<String> listUsers = new ArrayList<String>();
        if (categoriesNode.hasProperty("exo:newsletteraddministrator")) {
            listUsers.addAll(this.convertValuesToArray(categoriesNode.getProperty("exo:newsletteraddministrator").getValues()));
        }
        listUsers.remove(userId);
        categoriesNode.setProperty("exo:newsletteraddministrator", listUsers.toArray(new String[0]));
        session.save();
    }

    public Node add(String portalName, String userMail, SessionProvider sessionProvider) throws Exception {
        log.info((Object)("Trying to add user " + userMail));
        Node userNode = null;
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String userPath = NewsletterConstant.generateUserPath(portalName);
            Node userFolderNode = (Node)session.getItem(userPath);
            userNode = userFolderNode.addNode(userMail, "exo:newsletterUser");
            userNode.setProperty("exo:newsletterUserMail", userMail);
            userNode.setProperty("exo:newsletterUserBanned", false);
            userNode.setProperty("exo:newsletterUserValidationCode", "PublicUser" + IdGenerator.generate());
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Add user " + userMail + " failed because of " + e.getMessage()));
            e.printStackTrace();
        }
        if (userNode == null) {
            throw new Exception("Can not add new user");
        }
        return userNode;
    }

    private Node getUserNodeByEmail(String portalName, String userMail, Session session) throws Exception {
        String userPath = NewsletterConstant.generateUserPath(portalName);
        Node userFolderNode = (Node)session.getItem(userPath);
        try {
            return userFolderNode.getNode(userMail);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void changeBanStatus(String portalName, String userMail, boolean isBanClicked) {
        log.info((Object)("Trying to ban/unban user " + userMail));
        try {
            Session session;
            Node userNode;
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
            if (sessionProvider == null) {
                sessionProvider = SessionProvider.createSystemProvider();
            }
            if ((userNode = this.getUserNodeByEmail(portalName, userMail, session = sessionProvider.getSession(this.workspace, manageableRepository))).getProperty("exo:newsletterUserBanned").getBoolean() == isBanClicked) {
                return;
            }
            userNode.setProperty("exo:newsletterUserBanned", !userNode.getProperty("exo:newsletterUserBanned").getBoolean());
            session.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Ban/UnBan user " + userMail + " failed because of " + e.getMessage()));
        }
    }

    public void delete(String portalName, String userMail) {
        log.info((Object)("Trying to delete user " + userMail));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
            if (sessionProvider == null) {
                sessionProvider = SessionProvider.createSystemProvider();
            }
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String userPath = NewsletterConstant.generateUserPath(portalName);
            Node userFolderNode = (Node)session.getItem(userPath);
            Node userNode = userFolderNode.getNode(userMail);
            userNode.remove();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlQuery = "select * from exo:newsletterSubscription where exo:newsletterSubscribedUser like '%" + userMail + "%'";
            Query query = queryManager.createQuery(sqlQuery, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            while (nodeIterator.hasNext()) {
                Node subscriptionNode = nodeIterator.nextNode();
                if (!subscriptionNode.hasProperty("exo:newsletterSubscribedUser")) continue;
                Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                List<Value> oldSubscribedUsers = Arrays.asList(subscribedUserProperty.getValues());
                ArrayList<Value> newSubscribedUsers = new ArrayList<Value>();
                for (Value value : oldSubscribedUsers) {
                    String subscribedUserMail = value.getString();
                    if (userMail.equals(subscribedUserMail)) continue;
                    newSubscribedUsers.add(value);
                }
                subscribedUserProperty.setValue(newSubscribedUsers.toArray(new Value[newSubscribedUsers.size()]));
            }
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Delete user " + userMail + " failed because of " + e.getMessage()));
        }
    }

    public List<NewsletterUserConfig> getUsers(String portalName, String categoryName, String subscriptionName) throws Exception {
        ArrayList<NewsletterUserConfig> listUsers = new ArrayList<NewsletterUserConfig>();
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
        if (sessionProvider == null) {
            sessionProvider = SessionProvider.createSystemProvider();
        }
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String userPath = NewsletterConstant.generateUserPath(portalName);
        Node userHomeNode = (Node)session.getItem(userPath);
        if (categoryName == null && subscriptionName == null) {
            NodeIterator nodeIterator = userHomeNode.getNodes();
            while (nodeIterator.hasNext()) {
                listUsers.add(this.getUserFromNode(nodeIterator.nextNode()));
            }
        } else {
            List<Object> listEmail = new ArrayList();
            if (categoryName != null && subscriptionName == null) {
                Node categoryNode = (Node)session.getItem(NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName);
                NodeIterator nodeIterator = categoryNode.getNodes();
                while (nodeIterator.hasNext()) {
                    Value[] subscribedUserValues;
                    Node subscriptionNode = nodeIterator.nextNode();
                    if (!subscriptionNode.hasProperty("exo:newsletterSubscribedUser")) continue;
                    Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                    for (Value value : subscribedUserValues = subscribedUserProperty.getValues()) {
                        if (listEmail.contains(value.getString())) continue;
                        listEmail.add(value.getString());
                    }
                }
            } else {
                listEmail = this.getUsersBySubscription(portalName, categoryName, subscriptionName, session);
            }
            for (String string : listEmail) {
                listUsers.add(this.getUserFromNode(userHomeNode.getNode(string)));
            }
        }
        return listUsers;
    }

    private List<String> getUsersBySubscription(String portalName, String categoryName, String subscriptionName, Session session) {
        log.info((Object)("Trying to get list user by subscription " + portalName + "/" + categoryName + "/" + subscriptionName));
        ArrayList<String> subscribedUsers = new ArrayList<String>();
        try {
            String subscriptionPath = NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName + "/" + subscriptionName;
            Node subscriptionNode = (Node)Node.class.cast(session.getItem(subscriptionPath));
            if (subscriptionNode.hasProperty("exo:newsletterSubscribedUser")) {
                Value[] subscribedUserValues;
                Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                for (Value value : subscribedUserValues = subscribedUserProperty.getValues()) {
                    subscribedUsers.add(value.getString());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Get list user by subscription " + portalName + "/" + categoryName + "/" + subscriptionName + " failed because of " + e.getMessage()));
        }
        return subscribedUsers;
    }

    public int getQuantityUserBySubscription(String portalName, String categoryName, String subscriptionName) {
        log.info((Object)("Trying to get user's quantity by subscription " + portalName + "/" + categoryName + "/" + subscriptionName));
        int countUser = 0;
        try {
            String subscriptionPath;
            Session session;
            Node subscriptionNode;
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
            if (sessionProvider == null) {
                sessionProvider = SessionProvider.createSystemProvider();
            }
            if ((subscriptionNode = (Node)Node.class.cast((session = sessionProvider.getSession(this.workspace, manageableRepository)).getItem(subscriptionPath = NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName + "/" + subscriptionName))).hasProperty("exo:newsletterSubscribedUser")) {
                Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                countUser = subscribedUserProperty.getValues().length;
            }
        }
        catch (Exception e) {
            log.error((Object)("Get user's quantity by subscription " + portalName + "/" + categoryName + "/" + subscriptionName + " failed because of " + e.getMessage()));
        }
        return countUser;
    }

    public boolean checkExistedEmail(String portalName, String email) {
        try {
            Session session;
            Node userNode;
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            SessionProvider sessionProvider = this.threadLocalSessionProviderService.getSessionProvider(null);
            if (sessionProvider == null) {
                sessionProvider = SessionProvider.createSystemProvider();
            }
            return (userNode = this.getUserNodeByEmail(portalName, email, session = sessionProvider.getSession(this.workspace, manageableRepository))) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

