/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.Constant;
import org.picocontainer.Startable;

public class PublicationInitializerService
implements Startable {
    private LivePortalManagerService livePortalManagerService;
    private PublicationService publicationService;

    public PublicationInitializerService(LivePortalManagerService livePortalManagerService, PublicationService publicationService) {
        this.livePortalManagerService = livePortalManagerService;
        this.publicationService = publicationService;
    }

    public void initializePublication(Node portalNode) throws Exception {
        String sqlQuery = "select * from exo:webContent where jcr:path like '" + portalNode.getPath() + "/%' and not jcr:mixinTypes like '%" + Constant.PUBLICATION_LIFECYCLE_TYPE + "%' order by exo:dateCreated";
        QueryManager queryManager = portalNode.getSession().getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(sqlQuery, "sql");
        QueryResult results = query.execute();
        NodeIterator nodeIterator = results.getNodes();
        while (nodeIterator.hasNext()) {
            Node content = nodeIterator.nextNode();
            this.publicationService.enrollNodeInLifecycle(content, Constant.LIFECYCLE_NAME);
            this.publicationService.changeState(content, Constant.LIVE_STATE, new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            List livePortals = this.livePortalManagerService.getLivePortals(sessionProvider);
            if (livePortals.isEmpty()) {
                return;
            }
            Node dummyNode = (Node)livePortals.get(0);
            Session session = dummyNode.getSession();
            Node serviceFolder = session.getRootNode().getNode("exo:services");
            Node publicationInitializerService = null;
            publicationInitializerService = serviceFolder.hasNode("PublicationInitializerService") ? serviceFolder.getNode("PublicationInitializerService") : serviceFolder.addNode("PublicationInitializerService", "nt:unstructured");
            if (!publicationInitializerService.hasNode("PublicationInitializerServiceLog")) {
                for (Node portalNode : livePortals) {
                    this.initializePublication(portalNode);
                }
                Node publicationInitializerServiceLog = publicationInitializerService.addNode("ContentInitializerServiceLog", "nt:file");
                Node publicationInitializerServiceLogContent = publicationInitializerServiceLog.addNode("jcr:content", "nt:resource");
                publicationInitializerServiceLogContent.setProperty("jcr:encoding", "UTF-8");
                publicationInitializerServiceLogContent.setProperty("jcr:mimeType", "text/plain");
                publicationInitializerServiceLogContent.setProperty("jcr:data", "All node in site artifacts is published");
                publicationInitializerServiceLogContent.setProperty("jcr:lastModified", new Date().getTime());
                session.save();
            }
        }
        catch (Exception exception) {
        }
        finally {
            sessionProvider.close();
        }
    }

    public void stop() {
    }
}

