/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.wcm.publication.NotInWCMPublicationException;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMPublicationServiceImpl
implements WCMPublicationService,
Startable {
    private HashMap<String, WebpagePublicationPlugin> publicationPlugins = new HashMap();
    private PublicationService publicationService;

    public WCMPublicationServiceImpl(PublicationService publicationService) {
        this.publicationService = publicationService;
    }

    @Override
    public void addPublicationPlugin(WebpagePublicationPlugin p) {
        this.publicationPlugins.put(p.getLifecycleName(), p);
        this.publicationService.addPublicationPlugin((PublicationPlugin)PublicationPlugin.class.cast((Object)p));
    }

    @Override
    public void suspendPublishedContentFromPage(Node content, Page page) throws NotInPublicationLifecycleException, Exception {
        if (!this.publicationService.isNodeEnrolledInLifecycle(content)) {
            throw new NotInPublicationLifecycleException();
        }
        String lifecycleName = this.publicationService.getNodeLifecycleName(content);
        WebpagePublicationPlugin publicationPlugin = this.publicationPlugins.get(lifecycleName);
        publicationPlugin.suspendPublishedContentFromPage(content, page);
    }

    @Override
    public void publishContentToPage(Node content, Page page) throws NotInPublicationLifecycleException, Exception {
        if (!this.publicationService.isNodeEnrolledInLifecycle(content)) {
            throw new NotInPublicationLifecycleException("The node " + content.getPath() + " is not enrolled to any publication lifecyle");
        }
        String lifecycleName = this.publicationService.getNodeLifecycleName(content);
        WebpagePublicationPlugin publicationPlugin = this.publicationPlugins.get(lifecycleName);
        publicationPlugin.publishContentToPage(content, page);
    }

    @Override
    public void publishContentToPage(Node content, Page page, String lifecyleName) throws Exception {
        this.publicationService.enrollNodeInLifecycle(content, lifecyleName);
        String lifecycleName = this.publicationService.getNodeLifecycleName(content);
        WebpagePublicationPlugin publicationPlugin = this.publicationPlugins.get(lifecycleName);
        publicationPlugin.publishContentToPage(content, page);
    }

    @Override
    public void enrollNodeInLifecycle(Node node, String lifecycleName) throws Exception {
        this.publicationService.enrollNodeInLifecycle(node, lifecycleName);
    }

    @Override
    public void unsubcribeLifecycle(Node node) throws NotInPublicationLifecycleException, Exception {
        this.publicationService.unsubcribeLifecycle(node);
    }

    @Override
    public Map<String, WebpagePublicationPlugin> getWebpagePublicationPlugins() {
        return this.publicationPlugins;
    }

    @Override
    public void updateLifecycleOnChangeNavigation(PageNavigation navigation) throws Exception {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            publicationPlugin.updateLifecycleOnChangeNavigation(navigation);
        }
    }

    @Override
    public void updateLifecycleOnRemovePage(Page page) throws Exception {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            publicationPlugin.updateLifecycleOnRemovePage(page);
        }
    }

    @Override
    public void updateLifecyleOnChangePage(Page page) throws Exception {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            publicationPlugin.updateLifecyleOnChangePage(page);
        }
    }

    @Override
    public void updateLifecyleOnCreateNavigation(PageNavigation navigation) throws Exception {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            publicationPlugin.updateLifecyleOnCreateNavigation(navigation);
        }
    }

    @Override
    public void updateLifecyleOnCreatePage(Page page) throws Exception {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            publicationPlugin.updateLifecyleOnCreatePage(page);
        }
    }

    @Override
    public void updateLifecyleOnRemoveNavigation(PageNavigation navigation) throws Exception {
        for (WebpagePublicationPlugin publicationPlugin : this.publicationPlugins.values()) {
            publicationPlugin.updateLifecyleOnRemoveNavigation(navigation);
        }
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    public boolean isEnrolledInWCMLifecycle(Node node) throws NotInPublicationLifecycleException, Exception {
        if (!this.publicationService.isNodeEnrolledInLifecycle(node)) {
            return false;
        }
        String lifecyleName = this.publicationService.getNodeLifecycleName(node);
        if (this.publicationPlugins.containsKey(lifecyleName)) {
            return true;
        }
        throw new NotInWCMPublicationException();
    }
}

