/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.defaultlifecycle;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.application.Preference;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.ecm.publication.IncorrectStateUpdateLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.publication.defaultlifecycle.NavigationEventListenerDelegate;
import org.exoplatform.services.wcm.publication.defaultlifecycle.PageEventListenerDelegate;
import org.exoplatform.services.wcm.publication.defaultlifecycle.PortalNotFoundException;
import org.exoplatform.services.wcm.publication.defaultlifecycle.UIPublishingPanel;
import org.exoplatform.services.wcm.publication.defaultlifecycle.Util;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMPublicationPlugin
extends WebpagePublicationPlugin {
    public static final String ENROLLED = "enrolled".intern();
    public static final String UNPUBLISHED = "unpublished".intern();
    public static final String PUBLISHED = "published".intern();
    public static final String DEFAULT_STATE = UNPUBLISHED;
    public static final String PUBLICATION = "publication:publication".intern();
    public static final String LIFECYCLE_PROP = "publication:lifecycleName".intern();
    public static final String CURRENT_STATE = "publication:currentState".intern();
    public static final String HISTORY = "publication:history".intern();
    public static final String WCM_PUBLICATION_MIXIN = "publication:wcmPublication".intern();
    public static final String LIFECYCLE_NAME = "Web Content Publishing".intern();
    private static final String LOCALE_FILE = "artifacts.defaultlifecycle.WCMPublication".intern();
    public static final String IMG_PATH = "artifacts/".intern();
    private PageEventListenerDelegate pageEventListenerDelegate = new PageEventListenerDelegate(LIFECYCLE_NAME, ExoContainerContext.getCurrentContainer());
    private NavigationEventListenerDelegate navigationEventListenerDelegate = new NavigationEventListenerDelegate(LIFECYCLE_NAME, ExoContainerContext.getCurrentContainer());
    private static final int BUFFER_SIZE = 512;

    public void addMixin(Node node) throws Exception {
        node.addMixin(WCM_PUBLICATION_MIXIN);
        node.setProperty(LIFECYCLE_PROP, LIFECYCLE_NAME);
        node.getSession().save();
    }

    public boolean canAddMixin(Node node) throws Exception {
        List<String> runningPortals = this.getRunningPortals(node.getSession().getUserID());
        if (runningPortals.size() == 0) {
            throw new AccessControlException("Current user doesn't have access permission to any portal");
        }
        String portalName = this.getPortalForContent(node);
        if (portalName == null) {
            throw new PortalNotFoundException("This content doen't belong to any portal");
        }
        WCMService wcmService = Util.getServices(WCMService.class);
        if (!wcmService.isSharedPortal(portalName) && !runningPortals.contains(portalName)) {
            throw new PortalNotFoundException("The portal can be dead.");
        }
        if (node.isLocked()) {
            throw new LockException("This node is locked");
        }
        if (!node.isCheckedOut()) {
            throw new VersionException("This node is checked-in");
        }
        return node.canAddMixin(WCM_PUBLICATION_MIXIN);
    }

    public void changeState(Node node, String newState, HashMap<String, String> context) throws IncorrectStateUpdateLifecycleException, Exception {
        Session session = node.getSession();
        node.setProperty(CURRENT_STATE, newState);
        PublicationService publicationService = Util.getServices(PublicationService.class);
        if (newState.equals(ENROLLED)) {
            String lifecycleName = node.getProperty("publication:lifecycleName").getString();
            String[] logs = new String[]{new Date().toString(), ENROLLED, session.getUserID(), "PublicationService.WCMPublicationPlugin.changeState.enrolled", lifecycleName};
            publicationService.addLog(node, logs);
        } else if (newState.equals(PUBLISHED)) {
            String[] logs = new String[]{new Date().toString(), PUBLISHED, session.getUserID(), "PublicationService.WCMPublicationPlugin.changeState.published"};
            publicationService.addLog(node, logs);
        } else if (newState.equals(UNPUBLISHED)) {
            String[] logs = new String[]{new Date().toString(), UNPUBLISHED, session.getUserID(), "PublicationService.WCMPublicationPlugin.changeState.unpublished"};
            publicationService.addLog(node, logs);
        } else {
            throw new Exception("WCMPublicationPlugin.changeState : Unknown state : " + node.getProperty(CURRENT_STATE).getString());
        }
        session.save();
    }

    public String[] getPossibleStates() {
        return new String[]{ENROLLED, UNPUBLISHED, PUBLISHED};
    }

    public byte[] getStateImage(Node node, Locale locale) throws IOException, FileNotFoundException, Exception {
        byte[] bytes = null;
        String fileName = "WCM".intern();
        String currentState = node.getProperty(CURRENT_STATE).getString();
        fileName = PUBLISHED.equals(currentState) ? fileName + "Published" : fileName + "Unpublished";
        String fileNameLocalized = fileName + "_" + locale.getLanguage();
        String completeFileName = IMG_PATH + fileNameLocalized + ".gif";
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(completeFileName);
        if (in == null) {
            completeFileName = IMG_PATH + fileName + ".gif";
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(completeFileName);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        WCMPublicationPlugin.transfer(in, out);
        bytes = out.toByteArray();
        return bytes;
    }

    public static int transfer(InputStream in, OutputStream out) throws IOException {
        int total = 0;
        byte[] buffer = new byte[512];
        int bytesRead = in.read(buffer);
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            total += bytesRead;
            bytesRead = in.read(buffer);
        }
        return total;
    }

    public UIForm getStateUI(Node node, UIComponent component) throws Exception {
        UIPublishingPanel form = (UIPublishingPanel)component.createUIComponent(UIPublishingPanel.class, null, null);
        List<String> runningPortals = this.getRunningPortals(node.getSession().getUserID());
        String portalName = this.getPortalForContent(node);
        form.initPanel(node, portalName, runningPortals);
        return form;
    }

    public String getUserInfo(Node node, Locale locale) throws Exception {
        return null;
    }

    private List<String> getRunningPortals(String userId) throws Exception {
        ArrayList<String> listPortalName = new ArrayList<String>();
        DataStorage service = Util.getServices(DataStorage.class);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        PageList pageList = service.find(query);
        UserACL userACL = Util.getServices(UserACL.class);
        for (Object object : pageList.getAll()) {
            PortalConfig portalConfig = (PortalConfig)object;
            if (!userACL.hasPermission(portalConfig, userId)) continue;
            listPortalName.add(portalConfig.getName());
        }
        return listPortalName;
    }

    @Override
    public void publishContentToPage(Node content, Page page) throws Exception {
        UserPortalConfigService userPortalConfigService = Util.getServices(UserPortalConfigService.class);
        Application portlet = new Application();
        portlet.setApplicationType("portlet");
        portlet.setShowInfoBar(Boolean.valueOf(false));
        WCMConfigurationService configurationService = Util.getServices(WCMConfigurationService.class);
        StringBuilder windowId = new StringBuilder();
        windowId.append("portal").append("#").append(org.exoplatform.portal.webui.util.Util.getUIPortal().getOwner()).append(":").append(configurationService.getPublishingPortletName()).append("/").append(IdGenerator.generate());
        portlet.setInstanceId(windowId.toString());
        PortletPreferences portletPreferences = new PortletPreferences();
        portletPreferences.setWindowId(windowId.toString());
        portletPreferences.setOwnerType("portal");
        portletPreferences.setOwnerId(org.exoplatform.portal.webui.util.Util.getUIPortal().getOwner());
        ArrayList<Preference> listPreference = new ArrayList<Preference>();
        Preference preferenceR = new Preference();
        ArrayList<String> listValue = new ArrayList<String>();
        listValue.add(((ManageableRepository)content.getSession().getRepository()).getConfiguration().getName());
        preferenceR.setName("repository");
        preferenceR.setValues(listValue);
        listPreference.add(preferenceR);
        Preference preferenceW = new Preference();
        listValue = new ArrayList();
        listValue.add(content.getSession().getWorkspace().getName());
        preferenceW.setName("workspace");
        preferenceW.setValues(listValue);
        listPreference.add(preferenceW);
        Preference preferenceN = new Preference();
        listValue = new ArrayList();
        listValue.add(content.getUUID());
        preferenceN.setName("nodeIdentifier");
        preferenceN.setValues(listValue);
        listPreference.add(preferenceN);
        Preference preferenceQ = new Preference();
        listValue = new ArrayList();
        listValue.add("true");
        preferenceQ.setName("ShowQuickEdit");
        preferenceQ.setValues(listValue);
        listPreference.add(preferenceQ);
        portletPreferences.setPreferences(listPreference);
        DataStorage dataStorage = Util.getServices(DataStorage.class);
        dataStorage.save(portletPreferences);
        ArrayList listPortlet = page.getChildren();
        listPortlet.add(portlet);
        page.setChildren(listPortlet);
        userPortalConfigService.update(page);
    }

    @Override
    public void suspendPublishedContentFromPage(Node content, Page page) throws Exception {
        String pageId = page.getPageId();
        List<String> mixedApplicationIDs = Util.getValuesAsString(content, "publication:applicationIDs");
        ArrayList<String> removedApplicationIDs = new ArrayList<String>();
        for (String mixedID : mixedApplicationIDs) {
            if (!mixedID.startsWith(pageId)) continue;
            String realAppID = Util.parseMixedApplicationId(mixedID)[1];
            removedApplicationIDs.add(realAppID);
        }
        if (removedApplicationIDs.size() == 0) {
            return;
        }
        Util.removeApplicationFromPage(page, removedApplicationIDs);
        UserPortalConfigService userPortalConfigService = Util.getServices(UserPortalConfigService.class);
        userPortalConfigService.update(page);
    }

    public List<String> getListPageNavigationUri(Page page) throws Exception {
        ArrayList<String> listPageNavigationUri = new ArrayList<String>();
        DataStorage dataStorage = Util.getServices(DataStorage.class);
        RequestContext requestContext = WebuiRequestContext.getCurrentInstance();
        for (String portalName : this.getRunningPortals(requestContext.getRemoteUser())) {
            Query query = new Query("portal", portalName, PageNavigation.class);
            PageList list = dataStorage.find(query);
            for (Object object : list.getAll()) {
                PageNavigation pageNavigation = (PageNavigation)PageNavigation.class.cast(object);
                List<PageNode> listPageNode = Util.findPageNodeByPageId(pageNavigation, page.getPageId());
                for (PageNode pageNode : listPageNode) {
                    listPageNavigationUri.add(Util.setMixedNavigationUri(portalName, pageNode.getUri()));
                }
            }
        }
        return listPageNavigationUri;
    }

    private String getPortalForContent(Node contentNode) throws Exception {
        LivePortalManagerService livePortalManagerService = Util.getServices(LivePortalManagerService.class);
        for (String portalPath : livePortalManagerService.getLivePortalsPath()) {
            if (!contentNode.getPath().startsWith(portalPath)) continue;
            return livePortalManagerService.getPortalNameByPath(portalPath);
        }
        return null;
    }

    public Node getNodeView(Node node, Map<String, Object> context) throws Exception {
        return node;
    }

    @Override
    public void updateLifecycleOnChangeNavigation(PageNavigation navigation) throws Exception {
        this.navigationEventListenerDelegate.updateLifecycleOnChangeNavigation(navigation);
    }

    @Override
    public void updateLifecycleOnRemovePage(Page page) throws Exception {
        this.pageEventListenerDelegate.updateLifecycleOnRemovePage(page);
    }

    @Override
    public void updateLifecyleOnChangePage(Page page) throws Exception {
        this.pageEventListenerDelegate.updateLifecyleOnChangePage(page);
    }

    @Override
    public void updateLifecyleOnCreateNavigation(PageNavigation navigation) throws Exception {
        this.navigationEventListenerDelegate.updateLifecyleOnCreateNavigation(navigation);
    }

    @Override
    public void updateLifecyleOnCreatePage(Page page) throws Exception {
        this.pageEventListenerDelegate.updateLifecyleOnCreatePage(page);
    }

    @Override
    public void updateLifecyleOnRemoveNavigation(PageNavigation navigation) throws Exception {
        this.navigationEventListenerDelegate.updateLifecyleOnRemoveNavigation(navigation);
    }

    public String getLocalizedAndSubstituteMessage(Locale locale, String key, String[] values) throws Exception {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(LOCALE_FILE, locale, cl);
        String result = resourceBundle.getString(key);
        if (values != null) {
            return String.format(result, values);
        }
        return result;
    }
}

