/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion;

import java.util.HashMap;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;

public class StageAndVersionPublicationHandler
extends BaseWebSchemaHandler {
    private TemplateService templateService;
    private PublicationService publicationService;

    public StageAndVersionPublicationHandler(TemplateService templateService, PublicationService publicationService) {
        this.templateService = templateService;
        this.publicationService = publicationService;
    }

    protected String getHandlerNodeType() {
        return null;
    }

    protected String getParentNodeType() {
        return null;
    }

    public boolean matchHandler(Node node, SessionProvider sessionProvider) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)container.getComponentInstanceOfType(WebSchemaConfigService.class);
        WebContentSchemaHandler webContentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        if (webContentSchemaHandler.isWebcontentChildNode(node)) {
            return false;
        }
        if (node.isNodeType("exo:cssFile") || node.isNodeType("exo:jsFile")) {
            return false;
        }
        String primaryNodeType = node.getPrimaryNodeType().getName();
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        return this.templateService.isManagedNodeType(primaryNodeType, repository);
    }

    public void onCreateNode(Node node, SessionProvider sessionProvider) throws Exception {
        Node checkNode = node;
        if (node.isNodeType("nt:file")) {
            Node parentNode;
            if (node.canAddMixin("exo:rss-enable")) {
                node.addMixin("exo:rss-enable");
                if (!node.hasProperty("exo:title")) {
                    node.setProperty("exo:title", node.getName());
                }
            }
            if ((parentNode = node.getParent()).isNodeType("exo:webContent")) {
                checkNode = parentNode;
            }
        }
        if (this.publicationService.isNodeEnrolledInLifecycle(checkNode)) {
            return;
        }
        this.publicationService.enrollNodeInLifecycle(checkNode, StageAndVersionPublicationConstant.LIFECYCLE_NAME);
        this.publicationService.changeState(checkNode, StageAndVersionPublicationConstant.DRAFT_STATE, new HashMap());
    }

    public void onModifyNode(Node node, SessionProvider sessionProvider) throws Exception {
        Node parentNode;
        if (node.isNew()) {
            return;
        }
        Node checkNode = node;
        if (node.isNodeType("nt:file") && (parentNode = node.getParent()).isNodeType("exo:webContent")) {
            checkNode = parentNode;
        }
        String lifecycle = null;
        try {
            lifecycle = this.publicationService.getNodeLifecycleName(checkNode);
        }
        catch (NotInPublicationLifecycleException e) {
            return;
        }
        if (!StageAndVersionPublicationConstant.LIFECYCLE_NAME.equalsIgnoreCase(lifecycle)) {
            return;
        }
        String currentState = this.publicationService.getCurrentState(checkNode);
        if (!StageAndVersionPublicationConstant.ENROLLED_STATE.equalsIgnoreCase(currentState)) {
            return;
        }
        this.publicationService.changeState(checkNode, StageAndVersionPublicationConstant.DRAFT_STATE, new HashMap());
    }
}

