/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.post;

import java.util.HashMap;
import javax.jcr.Node;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostCreateContentEventListener
extends Listener<CmsService, Node> {
    private PublicationService publicationService;
    private WCMConfigurationService configurationService;
    private WebContentSchemaHandler webContentSchemaHandler;

    public PostCreateContentEventListener(PublicationService publicationService, WCMConfigurationService configurationService, WebSchemaConfigService schemaConfigService) {
        this.publicationService = publicationService;
        this.configurationService = configurationService;
        this.webContentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
    }

    public void onEvent(Event<CmsService, Node> event) throws Exception {
        NodeLocation nodeLocation;
        Node currentNode = (Node)event.getData();
        if (currentNode.canAddMixin("exo:rss-enable")) {
            currentNode.addMixin("exo:rss-enable");
            if (!currentNode.hasProperty("exo:title")) {
                currentNode.setProperty("exo:title", currentNode.getName());
            }
        }
        if (this.webContentSchemaHandler.isWebcontentChildNode(currentNode)) {
            return;
        }
        if (currentNode.isNodeType("exo:cssFile") || currentNode.isNodeType("exo:jsFile")) {
            return;
        }
        String repository = ((ManageableRepository)currentNode.getSession().getRepository()).getConfiguration().getName();
        String workspace = currentNode.getSession().getWorkspace().getName();
        if (!workspace.equalsIgnoreCase((nodeLocation = this.configurationService.getLivePortalsLocation(repository)).getWorkspace())) {
            return;
        }
        if (!currentNode.getPath().startsWith(nodeLocation.getPath())) {
            return;
        }
        if (this.publicationService.isNodeEnrolledInLifecycle(currentNode)) {
            return;
        }
        this.publicationService.enrollNodeInLifecycle(currentNode, StageAndVersionPublicationConstant.LIFECYCLE_NAME);
        this.publicationService.changeState(currentNode, StageAndVersionPublicationConstant.DRAFT_STATE, new HashMap());
    }
}

