/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Node;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.commons.exception.ExoMessageException;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.WCMPaginatedQueryResult;

public class SmallPaginatedQueryResult
extends WCMPaginatedQueryResult {
    private CopyOnWriteArrayList<ResultNode> arrayList = new CopyOnWriteArrayList();

    public SmallPaginatedQueryResult(int pageSize) {
        super(pageSize);
    }

    public SmallPaginatedQueryResult(QueryResult queryResult, QueryCriteria queryCriteria, int pageSize) throws Exception {
        super(queryResult, queryCriteria, pageSize);
        RowIterator rowIterator = queryResult.getRows();
        while (this.nodeIterator.hasNext()) {
            Node node = this.nodeIterator.nextNode();
            Node viewNode = this.filterNodeToDisplay(node);
            if (viewNode == null) continue;
            long position = this.nodeIterator.getPosition();
            long rowPosition = rowIterator.getPosition();
            long skipNum = position - rowPosition;
            rowIterator.skip(skipNum - 1L);
            Row row = rowIterator.nextRow();
            ResultNode resultNode = new ResultNode(viewNode, row);
            this.arrayList.addIfAbsent(resultNode);
        }
        this.setPageSize(pageSize);
        this.setAvailablePage(this.arrayList.size());
    }

    public List getPage(int page) throws Exception {
        this.checkAndSetPage(page);
        this.populateCurrentPage(page);
        return this.currentListPage_;
    }

    protected void populateCurrentPage(int page) throws Exception {
        this.currentListPage_ = this.arrayList.subList(this.getFrom(), this.getTo());
    }

    protected void checkAndSetPage(int page) throws Exception {
        if (page < 1 || page > this.availablePage_) {
            Object[] args = new Object[]{Integer.toString(page), Integer.toString(this.availablePage_)};
            throw new ExoMessageException("PageList.page-out-of-range", args);
        }
        this.currentPage_ = page;
    }
}

