/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.wcm.search.PaginatedQueryResult;
import org.exoplatform.services.wcm.search.QueryCriteria;

public class WCMPaginatedQueryResult
extends PaginatedQueryResult {
    private long queryTime;
    private String spellSuggestion;

    public WCMPaginatedQueryResult(int pageSize) {
        super(pageSize);
    }

    public WCMPaginatedQueryResult(QueryResult queryResult, QueryCriteria queryCriteria, int pageSize) throws Exception {
        super(queryResult, pageSize);
        this.queryCriteria = queryCriteria;
    }

    public void setQueryTime(long time) {
        this.queryTime = time;
    }

    public float getQueryTimeInSecond() {
        return (float)this.queryTime / 1000.0f;
    }

    public QueryCriteria getQueryCriteria() {
        return this.queryCriteria;
    }

    public void setQueryCriteria(QueryCriteria queryCriteria) {
        this.queryCriteria = queryCriteria;
    }

    protected Node filterNodeToDisplay(Node node) throws Exception {
        Node displayNode = this.getNodeToCheckState(node);
        if (displayNode == null) {
            return null;
        }
        PublicationService publicationService = (PublicationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PublicationService.class);
        String lifecycleName = null;
        try {
            lifecycleName = publicationService.getNodeLifecycleName(displayNode);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (lifecycleName == null) {
            return displayNode;
        }
        PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(lifecycleName);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("filter-mode", this.queryCriteria.isLiveMode() ? "Live" : "Edit");
        return publicationPlugin.getNodeView(displayNode, context);
    }

    protected Node getNodeToCheckState(Node node) throws Exception {
        String primaryNodeType;
        Object[] contentTypes;
        Node displayNode = node;
        if (node.getPath().contains("web contents/site artifacts")) {
            return null;
        }
        if (displayNode.isNodeType("nt:resource")) {
            displayNode = node.getParent();
        }
        if (displayNode.isNodeType("exo:htmlFile")) {
            Node parent = displayNode.getParent();
            if (this.queryCriteria.isSearchWebContent()) {
                if (parent.isNodeType("exo:webContent")) {
                    return parent;
                }
                return null;
            }
            if (parent.isNodeType("exo:webContent")) {
                return null;
            }
            return displayNode;
        }
        if (this.queryCriteria.isSearchWebContent()) {
            if (!this.queryCriteria.isSearchDocument() && !displayNode.isNodeType("exo:webContent")) {
                return null;
            }
            if (this.queryCriteria.isSearchWebpage() && !displayNode.isNodeType("publication:simplePublication")) {
                return null;
            }
        } else if (this.queryCriteria.isSearchWebpage()) {
            if (this.queryCriteria.isSearchDocument()) {
                return displayNode;
            }
            if (!displayNode.isNodeType("publication:webpagesPublication")) {
                return null;
            }
        }
        if ((contentTypes = this.queryCriteria.getContentTypes()) != null && contentTypes.length > 0 && !ArrayUtils.contains((Object[])contentTypes, (Object)(primaryNodeType = displayNode.getPrimaryNodeType().getName()))) {
            return null;
        }
        return displayNode;
    }

    public String getSpellSuggestion() {
        return this.spellSuggestion;
    }

    public void setSpellSuggestion(String spellSuggestion) {
        this.spellSuggestion = spellSuggestion;
    }
}

