/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.webcontent;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;

public class WebContentSchemaHandler
extends BaseWebSchemaHandler {
    protected String getHandlerNodeType() {
        return "exo:webContent";
    }

    protected String getParentNodeType() {
        return "nt:unstructured";
    }

    public boolean matchHandler(Node node, SessionProvider sessionProvider) throws Exception {
        String handlerNodeType = this.getHandlerNodeType();
        String parentNodeType = this.getParentNodeType();
        if (!node.isNodeType(handlerNodeType)) {
            return false;
        }
        return node.getParent().isNodeType(parentNodeType);
    }

    public void onCreateNode(Node webContent, SessionProvider sessionProvider) throws Exception {
        Session session = webContent.getSession();
        this.createSchema(webContent);
        session.save();
    }

    public Node getCSSFolder(Node webContent) throws Exception {
        return webContent.getNode("css");
    }

    public Node getJSFolder(Node webContent) throws Exception {
        return webContent.getNode("js");
    }

    public Node getImagesFolders(Node webContent) throws Exception {
        return webContent.getNode("medias/images");
    }

    public Node getIllustrationImage(Node webContent) throws Exception {
        return webContent.getNode("medias/images/illustration");
    }

    public Node getVideoFolder(Node webContent) throws Exception {
        return webContent.getNode("medias/videos");
    }

    public Node getDocumentFolder(Node webContent) throws Exception {
        return webContent.getNode("documents");
    }

    public void createDefaultSchema(Node webContent) throws Exception {
        this.addMixin(webContent, "exo:owneable");
        this.createSchema(webContent);
        Node defaultCSS = this.addNodeAsNTFile(webContent.getNode("css"), "default.css", "text/css", "");
        this.addMixin(defaultCSS, "exo:cssFile");
        this.addMixin(defaultCSS, "exo:owneable");
        Node defaultJS = this.addNodeAsNTFile(webContent.getNode("js"), "default.js", "application/x-javascript", "");
        this.addMixin(defaultJS, "exo:jsFile");
        this.addMixin(defaultJS, "exo:owneable");
        Node defaultHTML = this.addNodeAsNTFile(webContent, "default.html", "text/html", "");
        this.addMixin(defaultHTML, "exo:htmlFile");
        this.addMixin(defaultHTML, "exo:owneable");
        Node illustration = this.addNodeAsNTFile(webContent.getNode("medias/images"), "illustration", "", "");
        this.addMixin(illustration, "exo:owneable");
    }

    protected void createSchema(Node webContent) throws Exception {
        if (!webContent.hasNode("js")) {
            Node js = webContent.addNode("js", "exo:jsFolder");
            this.addMixin(js, "exo:owneable");
        }
        if (!webContent.hasNode("css")) {
            Node css = webContent.addNode("css", "exo:cssFolder");
            this.addMixin(css, "exo:owneable");
        }
        if (!webContent.hasNode("medias")) {
            Node multimedia = webContent.addNode("medias", "exo:multimediaFolder");
            this.addMixin(multimedia, "exo:owneable");
            Node images = multimedia.addNode("images", this.NT_FOLDER);
            this.addMixin(images, "exo:pictureFolder");
            this.addMixin(images, "exo:owneable");
            Node video = multimedia.addNode("videos", this.NT_FOLDER);
            this.addMixin(video, "exo:videoFolder");
            this.addMixin(video, "exo:owneable");
            Node audio = multimedia.addNode("audio", this.NT_FOLDER);
            this.addMixin(audio, "exo:musicFolder");
            this.addMixin(audio, "exo:owneable");
        }
        if (!webContent.hasNode("documents")) {
            Node document = webContent.addNode("documents", this.NT_UNSTRUCTURED);
            this.addMixin(document, "exo:documentFolder");
            this.addMixin(document, "exo:owneable");
        }
        webContent.setProperty("exo:title", webContent.getName());
    }

    private Node addNodeAsNTFile(Node home, String fileName, String mimeType, String data) throws Exception {
        Node file = home.addNode(fileName, "nt:file");
        Node jcrContent = file.addNode("jcr:content", "nt:resource");
        jcrContent.addMixin("dc:elementSet");
        jcrContent.setProperty("jcr:encoding", "UTF-8");
        jcrContent.setProperty("jcr:lastModified", Calendar.getInstance());
        jcrContent.setProperty("jcr:mimeType", mimeType);
        jcrContent.setProperty("jcr:data", data);
        return file;
    }

    public boolean isWebcontentChildNode(Node file) throws Exception {
        Node parent = file.getParent();
        if (parent.isNodeType("exo:webContent")) {
            return true;
        }
        if (parent.getPath().equals("/")) {
            return false;
        }
        Node grantParent = parent.getParent();
        if (grantParent.isNodeType("exo:webContent")) {
            return true;
        }
        if (grantParent.getPath().equals("/")) {
            return false;
        }
        Node ansestor = grantParent.getParent();
        return ansestor.isNodeType("exo:webContent");
    }
}

