/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;

public class PortalFolderSchemaHandler
extends BaseWebSchemaHandler {
    public Node getCSSFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("css");
    }

    public Node getJSFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("js");
    }

    public Node getMultimediaFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias");
    }

    public Node getImagesFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/images");
    }

    public Node getVideoFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/videos");
    }

    public Node getAudioFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/audio");
    }

    public Node getDocumentStorage(Node portalFolder) throws Exception {
        return portalFolder.getNode("documents");
    }

    public Node getLinkFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("links");
    }

    public Node getWebContentStorage(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents");
    }

    public Node getBannerThemes(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents/site artifacts/banner");
    }

    public Node getFooterThemes(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents/site artifacts/footer");
    }

    public Node getNavigationThemes(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents/site artifacts/navigation");
    }

    public Node getBreadcumsThemes(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents/site artifacts/breadcums");
    }

    public Node getHomepageThemes(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents/site artifacts/home page");
    }

    protected String getHandlerNodeType() {
        return "exo:portalFolder";
    }

    protected String getParentNodeType() {
        return "nt:unstructured";
    }

    public void onCreateNode(Node portalFolder, SessionProvider sessionProvider) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        Node jsFolder = portalFolder.addNode("js", "exo:jsFolder");
        this.addMixin(jsFolder, "exo:owneable");
        this.addMixin(jsFolder, "exo:datetime");
        jsFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node cssFolder = portalFolder.addNode("css", "exo:cssFolder");
        this.addMixin(cssFolder, "exo:owneable");
        this.addMixin(cssFolder, "exo:datetime");
        cssFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node multimedia = portalFolder.addNode("medias", "exo:multimediaFolder");
        this.addMixin(multimedia, "exo:owneable");
        this.addMixin(multimedia, "exo:datetime");
        multimedia.setProperty("exo:dateCreated", (Calendar)calendar);
        Node images = multimedia.addNode("images", this.NT_FOLDER);
        this.addMixin(images, "exo:pictureFolder");
        this.addMixin(images, "exo:owneable");
        this.addMixin(images, "exo:datetime");
        images.setProperty("exo:dateCreated", (Calendar)calendar);
        Node video = multimedia.addNode("videos", this.NT_FOLDER);
        this.addMixin(video, "exo:videoFolder");
        this.addMixin(video, "exo:owneable");
        this.addMixin(video, "exo:datetime");
        video.setProperty("exo:dateCreated", (Calendar)calendar);
        Node audio = multimedia.addNode("audio", this.NT_FOLDER);
        this.addMixin(audio, "exo:musicFolder");
        this.addMixin(audio, "exo:owneable");
        this.addMixin(audio, "exo:datetime");
        audio.setProperty("exo:dateCreated", (Calendar)calendar);
        Node document = portalFolder.addNode("documents", this.NT_UNSTRUCTURED);
        this.addMixin(document, "exo:documentFolder");
        this.addMixin(document, "exo:owneable");
        this.addMixin(document, "exo:datetime");
        document.setProperty("exo:dateCreated", (Calendar)calendar);
        Node webContents = portalFolder.addNode("web contents", "exo:webFolder");
        this.addMixin(webContents, "exo:owneable");
        this.addMixin(webContents, "exo:datetime");
        webContents.setProperty("exo:dateCreated", (Calendar)calendar);
        Node themes = webContents.addNode("site artifacts", "exo:themeFolder");
        this.addMixin(themes, "exo:owneable");
        this.addMixin(themes, "exo:datetime");
        themes.setProperty("exo:dateCreated", (Calendar)calendar);
        Node bannerFolder = themes.addNode("banner", "nt:unstructured");
        this.addMixin(bannerFolder, "exo:owneable");
        this.addMixin(bannerFolder, "exo:datetime");
        bannerFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node searchboxFolder = themes.addNode("searchbox", "nt:unstructured");
        this.addMixin(searchboxFolder, "exo:owneable");
        this.addMixin(searchboxFolder, "exo:datetime");
        searchboxFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node navigationFolder = themes.addNode("navigation", "nt:unstructured");
        this.addMixin(navigationFolder, "exo:owneable");
        this.addMixin(navigationFolder, "exo:datetime");
        navigationFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node breadcumbsFolder = themes.addNode("breadcrumb", "nt:unstructured");
        this.addMixin(breadcumbsFolder, "exo:owneable");
        this.addMixin(breadcumbsFolder, "exo:datetime");
        breadcumbsFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node homepageFolder = themes.addNode("homepage", "nt:unstructured");
        this.addMixin(homepageFolder, "exo:owneable");
        this.addMixin(homepageFolder, "exo:datetime");
        homepageFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node footerFolder = themes.addNode("footer", "nt:unstructured");
        this.addMixin(footerFolder, "exo:owneable");
        this.addMixin(footerFolder, "exo:datetime");
        footerFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node sitemapFolder = themes.addNode("sitemap", "nt:unstructured");
        this.addMixin(sitemapFolder, "exo:owneable");
        this.addMixin(sitemapFolder, "exo:datetime");
        sitemapFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node accessFolder = themes.addNode("access", "nt:unstructured");
        this.addMixin(accessFolder, "exo:owneable");
        this.addMixin(accessFolder, "exo:datetime");
        accessFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node links = portalFolder.addNode("links", "exo:linkFolder");
        this.addMixin(links, "exo:owneable");
        this.addMixin(links, "exo:datetime");
        links.setProperty("exo:dateCreated", (Calendar)calendar);
        Node categoryFolder = portalFolder.addNode("categories", this.NT_UNSTRUCTURED);
        this.addMixin(categoryFolder, "exo:owneable");
        this.addMixin(categoryFolder, "exo:datetime");
        categoryFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node applicationDataFolder = portalFolder.addNode("ApplicationData", this.NT_UNSTRUCTURED);
        this.addMixin(applicationDataFolder, "exo:owneable");
        this.addMixin(applicationDataFolder, "exo:datetime");
        applicationDataFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node newsletterApplicationFolder = applicationDataFolder.addNode("NewsletterApplication", this.NT_UNSTRUCTURED);
        this.addMixin(newsletterApplicationFolder, "exo:owneable");
        this.addMixin(newsletterApplicationFolder, "exo:datetime");
        newsletterApplicationFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node defaultTemplatesFolder = newsletterApplicationFolder.addNode("DefaultTemplates", this.NT_UNSTRUCTURED);
        this.addMixin(defaultTemplatesFolder, "exo:owneable");
        this.addMixin(defaultTemplatesFolder, "exo:datetime");
        defaultTemplatesFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node newsletterCategoriesFolder = newsletterApplicationFolder.addNode("Categories", this.NT_UNSTRUCTURED);
        this.addMixin(newsletterCategoriesFolder, "exo:owneable");
        this.addMixin(newsletterCategoriesFolder, "exo:datetime");
        newsletterCategoriesFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        Node newsletterUserFolder = newsletterApplicationFolder.addNode("Users", this.NT_UNSTRUCTURED);
        this.addMixin(newsletterUserFolder, "exo:owneable");
        this.addMixin(newsletterUserFolder, "exo:datetime");
        newsletterUserFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        portalFolder.getSession().save();
    }
}

