/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.webcontent;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.selectone.UISelectPathPanel;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.wcm.webui.selector.webcontent.UIWebContentTreeBuilder;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/wcm/webui/UIWebContentPathSelector.gtmpl", events={@EventConfig(listeners={SelectPathActionListener.class})}), @ComponentConfig(type=UIBreadcumbs.class, id="UIBreadcrumbWebContentPathSelector", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={UIBreadcumbs.SelectPathActionListener.class})}), @ComponentConfig(type=UISelectPathPanel.class, id="UIWCMSelectPathPanel", template="classpath:groovy/wcm/webui/UIWCMSelectPathPanel.gtmpl", events={@EventConfig(listeners={UISelectPathPanel.SelectActionListener.class})})})
public class UIWebContentPathSelector
extends UIBaseNodeTreeSelector
implements UIPopupComponent {
    private Node currentPortal;
    private Node sharedPortal;

    public UIWebContentPathSelector() throws Exception {
        this.addChild(UIBreadcumbs.class, "UIBreadcrumbWebContentPathSelector", "UIBreadcrumbWebContentPathSelector");
        this.addChild(UIWebContentTreeBuilder.class, null, UIWebContentTreeBuilder.class.getName() + ((Object)((Object)this)).hashCode());
        this.addChild(UISelectPathPanel.class, "UIWCMSelectPathPanel", "UIWCMSelectPathPanel");
    }

    public void init() throws Exception {
        String[] acceptedNodeTypes = new String[]{"exo:webContent"};
        UISelectPathPanel selectPathPanel = (UISelectPathPanel)this.getChild(UISelectPathPanel.class);
        selectPathPanel.setAcceptedNodeTypes(acceptedNodeTypes);
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)this.getApplicationComponent(LivePortalManagerService.class);
        String currentPortalName = Util.getUIPortal().getName();
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        this.currentPortal = livePortalManagerService.getLivePortal(currentPortalName, provider);
        this.sharedPortal = livePortalManagerService.getLiveSharedPortal(provider);
        UIWebContentTreeBuilder builder = (UIWebContentTreeBuilder)this.getChild(UIWebContentTreeBuilder.class);
        builder.setCurrentPortal(this.currentPortal);
        builder.setSharedPortal(this.sharedPortal);
        builder.setRootTreeNode(this.currentPortal.getParent());
        provider.close();
    }

    public void onChange(Node node, Object context) throws Exception {
        UISelectPathPanel selectPathPanel = (UISelectPathPanel)this.getChild(UISelectPathPanel.class);
        this.changeFolder(node);
        selectPathPanel.setParentNode(node);
        selectPathPanel.updateGrid();
    }

    private void changeFolder(Node selectedNode) throws Exception {
        UIBreadcumbs uiBreadcrumb = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        uiBreadcrumb.setPath(this.getPath(null, selectedNode));
    }

    private List<UIBreadcumbs.LocalPath> getPath(List<UIBreadcumbs.LocalPath> list, Node selectedNode) throws Exception {
        if (list == null) {
            list = new ArrayList<UIBreadcumbs.LocalPath>(5);
        }
        if (selectedNode == null || selectedNode.getPath().equalsIgnoreCase(this.currentPortal.getParent().getPath()) || selectedNode.getPath().equals("/")) {
            return list;
        }
        list.add(0, new UIBreadcumbs.LocalPath(selectedNode.getPath(), selectedNode.getName()));
        this.getPath(list, selectedNode.getParent());
        return list;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Node getCurrentPortal() {
        return this.currentPortal;
    }

    public void setCurrentPortal(Node currentPortal) {
        this.currentPortal = currentPortal;
    }

    public Node getSharedPortal() {
        return this.sharedPortal;
    }

    public void setSharedPortal(Node sharedPortal) {
        this.sharedPortal = sharedPortal;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            String selectedNodePath = event.getRequestContext().getRequestParameter("objectId");
            UIWebContentPathSelector uiWCPathSelector = (UIWebContentPathSelector)uiBreadcumbs.getAncestorOfType(UIWebContentPathSelector.class);
            Node currentPortal = uiWCPathSelector.getCurrentPortal();
            Node sharedPortal = uiWCPathSelector.getSharedPortal();
            if (selectedNodePath.equals(currentPortal.getPath()) || selectedNodePath.equals(sharedPortal.getPath())) {
                selectedNodePath = currentPortal.getParent().getPath();
            }
            UIWebContentTreeBuilder uiWCTreeBuilder = (UIWebContentTreeBuilder)uiWCPathSelector.getChild(UIWebContentTreeBuilder.class);
            uiWCTreeBuilder.changeNode(selectedNodePath, event.getRequestContext());
        }
    }
}

