/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.webcontent;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.webui.tree.UINodeTree;
import org.exoplatform.ecm.webui.tree.UINodeTreeBuilder;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={UINodeTreeBuilder.ChangeNodeActionListener.class})})
public class UIWebContentTreeBuilder
extends UINodeTreeBuilder {
    private Node currentPortal;
    private Node sharedPortal;

    public Node getCurrentPortal() {
        return this.currentPortal;
    }

    public void setCurrentPortal(Node currentPortal) {
        this.currentPortal = currentPortal;
    }

    public Node getSharedPortal() {
        return this.sharedPortal;
    }

    public void setSharedPortal(Node sharedPortal) {
        this.sharedPortal = sharedPortal;
    }

    public void buildTree() throws Exception {
        UINodeTree tree = (UINodeTree)this.getChild(UINodeTree.class);
        tree.setSelected((Object)this.currentNode);
        String currentPath = this.currentNode.getPath();
        String currentPortalPath = this.currentPortal.getPath();
        String sharedPortalPath = this.sharedPortal.getPath();
        if (this.currentNode.getPath().equals(this.rootTreeNode.getPath())) {
            ArrayList<Node> portals = new ArrayList<Node>();
            portals.add(this.currentPortal);
            portals.add(this.sharedPortal);
            tree.setChildren(portals);
            tree.setSibbling(portals);
            tree.setParentSelected((Object)this.rootTreeNode);
        } else if (currentPath.equals(sharedPortalPath)) {
            Node webStorage = this.getWebContentStorage(this.sharedPortal);
            List<Node> children = this.filterWebContentFolder(webStorage);
            tree.setChildren(children);
            tree.setSibbling(children);
            tree.setParentSelected((Object)this.rootTreeNode);
        } else if (currentPath.equals(currentPortalPath)) {
            Node webStorage = this.getWebContentStorage(this.currentPortal);
            List<Node> children = this.filterWebContentFolder(webStorage);
            tree.setChildren(children);
            tree.setSibbling(children);
            tree.setParentSelected((Object)this.rootTreeNode);
        } else if (currentPath.startsWith(currentPortalPath) || currentPath.startsWith(sharedPortalPath)) {
            if (this.currentNode.getParent().getPath().equals(this.currentPortal.getPath())) {
                Node webStorage = this.getWebContentStorage(this.currentPortal);
                List<Node> children = this.filterWebContentFolder(webStorage);
                tree.setChildren(children);
                tree.setSibbling(children);
                tree.setParentSelected((Object)this.rootTreeNode);
            } else if (this.currentNode.getParent().getPath().equals(this.sharedPortal.getPath())) {
                Node webStorage = this.getWebContentStorage(this.sharedPortal);
                List<Node> children = this.filterWebContentFolder(webStorage);
                tree.setChildren(children);
                tree.setSibbling(children);
                tree.setParentSelected((Object)this.rootTreeNode);
            } else {
                List<Node> sibbling = this.filterWebContentFolder(this.currentNode.getParent());
                List<Node> children = this.filterWebContentFolder(this.currentNode);
                tree.setChildren(children);
                tree.setSibbling(sibbling);
                tree.setParentSelected((Object)this.currentNode.getParent());
            }
        }
    }

    private List<Node> filterWebContentFolder(Node parent) throws Exception {
        ArrayList<Node> webContentList = new ArrayList<Node>();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String repository = ((ManageableRepository)parent.getSession().getRepository()).getConfiguration().getName();
        NodeIterator iterator = parent.getNodes();
        while (iterator.hasNext()) {
            Node child = iterator.nextNode();
            NodeType nodeType = child.getPrimaryNodeType();
            if (!nodeType.isNodeType("nt:unstructured") || templateService.isManagedNodeType(nodeType.getName(), repository)) continue;
            webContentList.add(child);
        }
        return webContentList;
    }

    private Node getWebContentStorage(Node portal) throws Exception {
        WebSchemaConfigService configService = (WebSchemaConfigService)this.getApplicationComponent(WebSchemaConfigService.class);
        PortalFolderSchemaHandler portalFolderSchemaHandler = (PortalFolderSchemaHandler)configService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
        return portalFolderSchemaHandler.getWebContentStorage(portal);
    }

    public void changeNode(String path, Object requestContext) throws Exception {
        if (path == null) {
            return;
        }
        String rootPath = this.rootTreeNode.getPath();
        Node node = null;
        if (rootPath.equals(path) || !path.startsWith(rootPath)) {
            node = this.rootTreeNode;
            this.currentNode = this.rootTreeNode;
        } else if (path.equals(this.currentPortal.getPath())) {
            node = this.getWebContentStorage(this.currentPortal);
            this.currentNode = this.currentPortal;
        } else if (path.equals(this.sharedPortal.getPath())) {
            node = this.getWebContentStorage(this.sharedPortal);
            this.currentNode = this.sharedPortal;
        } else {
            this.currentNode = node = (Node)this.rootTreeNode.getSession().getItem(path);
        }
        this.broadcastOnChange(node, requestContext);
    }
}

