/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.document;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.tree.selectone.UISelectPathPanel;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.search.PaginatedQueryResult;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.WCMPaginatedQueryResult;
import org.exoplatform.wcm.webui.selector.document.UIDocumentPathSelector;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/UIDocumentSearch.gtmpl", events={@EventConfig(listeners={SearchDMSActionListener.class})})
public class UIDocumentSearch
extends UIForm {
    private static final String KEYWORD_INPUT = "keyword".intern();
    private static final String SEARCH_TYPE_NAME = "By name".intern();
    private static final String SEARCH_TYPE_TEXT_FULL = "By content".intern();
    private static final String SEARCH_TYPE = "searchtype".intern();

    public UIDocumentSearch() throws Exception {
        UIFormStringInput uiFormStringInput = new UIFormStringInput(KEYWORD_INPUT, KEYWORD_INPUT, null);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        options.add(new SelectItemOption(SEARCH_TYPE_NAME, (Object)SEARCH_TYPE_NAME));
        options.add(new SelectItemOption(SEARCH_TYPE_TEXT_FULL, (Object)SEARCH_TYPE_TEXT_FULL));
        UIFormSelectBox uiFormSelectBox = new UIFormSelectBox(SEARCH_TYPE, SEARCH_TYPE, options);
        this.addChild((UIComponent)uiFormStringInput);
        this.addChild((UIComponent)uiFormSelectBox);
    }

    private WCMPaginatedQueryResult searchFullText(Node currentNode, String keyword) throws Exception {
        QueryCriteria qCriteria = new QueryCriteria();
        qCriteria.setSearchDocument(true);
        qCriteria.setSearchWebContent(false);
        qCriteria.setSearchWebpage(false);
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearchService = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        int pageSize = 10;
        return siteSearchService.searchSiteContents(qCriteria, SessionProviderFactory.createSessionProvider(), pageSize);
    }

    private PaginatedQueryResult searchDMSByName(Node currentNode, String keyword, String workspace, ManageableRepository maRepository) throws Exception {
        Session session = SessionProviderFactory.createSessionProvider().getSession(workspace, maRepository);
        String sqlQuery = "SELECT * FROM nt:base WHERE (";
        String tempPrimaryType = "";
        List<String> documentTypes = this.getDocumentTypes(session);
        int count = 0;
        int size = documentTypes.size();
        for (String documentType : documentTypes) {
            tempPrimaryType = count == size - 1 ? tempPrimaryType + "jcr:primaryType LIKE '" + documentType + "') " : tempPrimaryType + "jcr:primaryType LIKE '" + documentType + "' OR ";
            ++count;
        }
        sqlQuery = sqlQuery + tempPrimaryType + "AND jcr:path like '" + currentNode.getPath() + "/" + keyword + "' " + "OR jcr:path LIKE '" + currentNode.getPath() + "/%/" + keyword + "' " + "ORDER BY jcr:score DESC";
        QueryManager queManager = session.getWorkspace().getQueryManager();
        Query query = queManager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        int pageSize = 10;
        return new PaginatedQueryResult(queryResult, pageSize);
    }

    private List<String> getDocumentTypes(Session session) throws Exception {
        ArrayList<String> webContentTypes = new ArrayList<String>(10);
        NodeTypeManager nodeTypeManager = session.getWorkspace().getNodeTypeManager();
        NodeTypeIterator nodeTypeIterator = nodeTypeManager.getAllNodeTypes();
        while (nodeTypeIterator.hasNext()) {
            NodeType nodeType = nodeTypeIterator.nextNodeType();
            if (!nodeType.isNodeType("exo:webContent")) continue;
            webContentTypes.add(nodeType.getName());
        }
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        TemplateService tempService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List documentTypes = tempService.getDocumentTemplates(repositoryName);
        documentTypes.removeAll(webContentTypes);
        return documentTypes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchDMSActionListener
    extends EventListener<UIDocumentSearch> {
        public void execute(Event<UIDocumentSearch> event) throws Exception {
            UIDocumentSearch uiDMSSearch = (UIDocumentSearch)((Object)event.getSource());
            UIDocumentPathSelector uiDMSPathSelector = (UIDocumentPathSelector)uiDMSSearch.getAncestorOfType(UIDocumentPathSelector.class);
            Node currentNode = uiDMSPathSelector.getCurrentNode();
            if (currentNode.getPath().equals("/sites content/live")) {
                UIApplication uiApp = (UIApplication)uiDMSSearch.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIWebContentSearchForm.msg-choose-portal", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            }
            String workspace = currentNode.getSession().getWorkspace().getName();
            ManageableRepository maRepository = (ManageableRepository)currentNode.getSession().getRepository();
            UISelectPathPanel uiSelectPathPanel = (UISelectPathPanel)uiDMSPathSelector.getChild(UISelectPathPanel.class);
            String searchType = (String)uiDMSSearch.getUIFormSelectBox(SEARCH_TYPE).getValue();
            String keyword = (String)uiDMSSearch.getUIStringInput(KEYWORD_INPUT).getValue();
            if (searchType.equals(SEARCH_TYPE_NAME)) {
                PaginatedQueryResult paQueryResult = uiDMSSearch.searchDMSByName(currentNode, keyword, workspace, maRepository);
                uiSelectPathPanel.getUIPageIterator().setPageList((PageList)paQueryResult);
            } else {
                WCMPaginatedQueryResult wcmPaQueryResult = uiDMSSearch.searchFullText(currentNode, keyword);
                uiSelectPathPanel.getUIPageIterator().setPageList((PageList)wcmPaQueryResult);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDMSPathSelector);
        }
    }
}

