/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.document;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.search.PaginatedQueryResult;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.wcm.webui.selector.document.UIDocumentTabSelector;
import org.exoplatform.wcm.webui.selector.webcontent.UIWCMSearchResult;
import org.exoplatform.wcm.webui.selector.webcontent.UIWebContentSearchForm;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/UIWebContentSearchForm.gtmpl", events={@EventConfig(listeners={SearchWebContentActionListener.class}), @EventConfig(listeners={AddMetadataTypeActionListener.class}), @EventConfig(listeners={AddNodeTypeActionListener.class})})
public class UIDocumentSearchForm
extends UIForm {
    private String checkedRadioId;

    public String getCheckedRadioId() {
        return this.checkedRadioId;
    }

    public void setCheckedRadioId(String checkedRadioId) {
        this.checkedRadioId = checkedRadioId;
    }

    public void init() throws Exception {
        ArrayList<SelectItemOption> portalNameOptions = new ArrayList<SelectItemOption>();
        List<String> portalNames = this.getPortalNames();
        for (String portalName : portalNames) {
            portalNameOptions.add(new SelectItemOption(portalName, (Object)portalName));
        }
        UIFormSelectBox portalNameSelectBox = new UIFormSelectBox(UIWebContentSearchForm.LOCATION, UIWebContentSearchForm.LOCATION, portalNameOptions);
        portalNameSelectBox.setDefaultValue((Object)portalNames.get(0));
        this.addChild((UIComponent)portalNameSelectBox);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(UIWebContentSearchForm.SEARCH_BY_NAME, UIWebContentSearchForm.SEARCH_BY_NAME, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(UIWebContentSearchForm.SEARCH_BY_CONTENT, UIWebContentSearchForm.SEARCH_BY_CONTENT, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("property", "property", null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("contain", "contain", null));
        ArrayList<SelectItemOption> dateOptions = new ArrayList<SelectItemOption>();
        dateOptions.add(new SelectItemOption("CREATED", (Object)"CREATED"));
        dateOptions.add(new SelectItemOption("MODIFIED", (Object)"MODIFIED"));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox("timeOpt", "timeOpt", dateOptions));
        UIFormDateTimeInput startTime = new UIFormDateTimeInput("startTime", "startTime", null, true);
        this.addUIFormInput((UIFormInput)startTime);
        UIFormDateTimeInput endTime = new UIFormDateTimeInput("endTime", "endTime", null, true);
        this.addUIFormInput((UIFormInput)endTime);
        this.addUIFormInput((UIFormInput)new UIFormStringInput("docType", "docType", null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("category", "category", null));
        this.setActions(new String[]{"SearchWebContent"});
    }

    private List<String> getPortalNames() throws Exception {
        ArrayList<String> portalNames = new ArrayList<String>();
        String currentPortalName = Util.getUIPortal().getName();
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String repository = repoService.getCurrentRepository().getConfiguration().getName();
        WCMConfigurationService configService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        String sharedPortalName = configService.getSharedPortalName(repository);
        portalNames.add(currentPortalName);
        portalNames.add(sharedPortalName);
        return portalNames;
    }

    private QueryCriteria getInitialQueryCriteria(String siteName) {
        QueryCriteria qCriteria = new QueryCriteria();
        qCriteria.setSearchDocument(true);
        qCriteria.setSearchWebpage(false);
        qCriteria.setSearchWebContent(false);
        qCriteria.setLiveMode(false);
        qCriteria.setSiteName(siteName);
        return qCriteria;
    }

    private PaginatedQueryResult searchDocumentByName(String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(false);
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(qCriteria, SessionProviderFactory.createSessionProvider(), pageSize);
    }

    private PaginatedQueryResult searchDocumentByFulltext(String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(".");
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(qCriteria, SessionProviderFactory.createSessionProvider(), pageSize);
    }

    private PaginatedQueryResult searchDocumentByProperty(String property, String keyword, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(property);
        qCriteria.setKeyword(keyword);
        SiteSearchService siteSearchService = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearchService.searchSiteContents(qCriteria, SessionProviderFactory.createSessionProvider(), pageSize);
    }

    private PaginatedQueryResult searchDocumentByDate(QueryCriteria.DATE_RANGE_SELECTED dateRangeSelected, Calendar fromDate, Calendar endDate, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setDateRangeSelected(dateRangeSelected);
        QueryCriteria.DatetimeRange dateTimeRange = new QueryCriteria.DatetimeRange(fromDate, endDate);
        if (QueryCriteria.DATE_RANGE_SELECTED.CREATED.equals((Object)dateRangeSelected)) {
            qCriteria.setCreatedDateRange(dateTimeRange);
        } else if (QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED.equals((Object)dateRangeSelected)) {
            qCriteria.setLastModifiedDateRange(dateTimeRange);
        }
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(null);
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(qCriteria, SessionProviderFactory.createSessionProvider(), pageSize);
    }

    private PaginatedQueryResult searchDocumentByType(String documentType, QueryCriteria qCriteria, int pageSize) throws Exception {
        qCriteria.setFulltextSearch(true);
        qCriteria.setFulltextSearchProperty(null);
        qCriteria.setContentTypes(documentType.split(","));
        SiteSearchService siteSearch = (SiteSearchService)this.getApplicationComponent(SiteSearchService.class);
        return siteSearch.searchSiteContents(qCriteria, SessionProviderFactory.createSessionProvider(), pageSize);
    }

    private boolean haveEmptyField(UIApplication uiApp, Event<UIDocumentSearchForm> event, Object ... fields) throws Exception {
        for (Object field : fields) {
            if (field != null) continue;
            uiApp.addMessage(new ApplicationMessage("UIWebContentSearchForm.empty-field", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddNodeTypeActionListener
    extends EventListener<UIDocumentSearchForm> {
        public void execute(Event<UIDocumentSearchForm> event) throws Exception {
            UIDocumentSearchForm uiDocSearchForm = (UIDocumentSearchForm)((Object)event.getSource());
            UIDocumentTabSelector uiDocTabSelector = (UIDocumentTabSelector)uiDocSearchForm.getParent();
            uiDocSearchForm.setCheckedRadioId(event.getRequestContext().getRequestParameter(UIWebContentSearchForm.CHECKED_RADIO_ID));
            uiDocTabSelector.initNodeTypePopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocTabSelector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddMetadataTypeActionListener
    extends EventListener<UIDocumentSearchForm> {
        public void execute(Event<UIDocumentSearchForm> event) throws Exception {
            UIDocumentSearchForm uiDocumentSearch = (UIDocumentSearchForm)((Object)event.getSource());
            UIDocumentTabSelector uiDocumentTabSelector = (UIDocumentTabSelector)uiDocumentSearch.getParent();
            uiDocumentSearch.setCheckedRadioId(event.getRequestContext().getRequestParameter(UIWebContentSearchForm.CHECKED_RADIO_ID));
            uiDocumentTabSelector.initMetadataPopup();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentTabSelector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchWebContentActionListener
    extends EventListener<UIDocumentSearchForm> {
        public void execute(Event<UIDocumentSearchForm> event) throws Exception {
            String keyword;
            UIDocumentSearchForm uiDocSearchForm = (UIDocumentSearchForm)((Object)event.getSource());
            String radioValue = event.getRequestContext().getRequestParameter(UIWebContentSearchForm.RADIO_NAME);
            String siteName = (String)uiDocSearchForm.getUIStringInput(UIWebContentSearchForm.LOCATION).getValue();
            UIDocumentTabSelector uiDocTabSelector = (UIDocumentTabSelector)uiDocSearchForm.getParent();
            UIApplication uiApp = (UIApplication)uiDocSearchForm.getAncestorOfType(UIApplication.class);
            QueryCriteria qCriteria = uiDocSearchForm.getInitialQueryCriteria(siteName);
            int pageSize = 5;
            PaginatedQueryResult pagResult = null;
            if (UIWebContentSearchForm.SEARCH_BY_NAME.equals(radioValue)) {
                keyword = (String)uiDocSearchForm.getUIStringInput(radioValue).getValue();
                if (uiDocSearchForm.haveEmptyField(uiApp, (Event<UIDocumentSearchForm>)event, new Object[]{keyword})) {
                    return;
                }
                pagResult = uiDocSearchForm.searchDocumentByName(keyword, qCriteria, pageSize);
            } else if (UIWebContentSearchForm.SEARCH_BY_CONTENT.equals(radioValue)) {
                keyword = (String)uiDocSearchForm.getUIStringInput(radioValue).getValue();
                if (uiDocSearchForm.haveEmptyField(uiApp, (Event<UIDocumentSearchForm>)event, new Object[]{keyword})) {
                    return;
                }
                pagResult = uiDocSearchForm.searchDocumentByFulltext(keyword, qCriteria, pageSize);
            } else if ("property".equals(radioValue)) {
                String property = (String)uiDocSearchForm.getUIStringInput("property").getValue();
                String keyword2 = (String)uiDocSearchForm.getUIStringInput("contain").getValue();
                if (uiDocSearchForm.haveEmptyField(uiApp, (Event<UIDocumentSearchForm>)event, new Object[]{property, keyword2})) {
                    return;
                }
                pagResult = uiDocSearchForm.searchDocumentByProperty(property, keyword2, qCriteria, pageSize);
            } else if ("timeOpt".equals(radioValue)) {
                String dateRangeSelected;
                Calendar fromDate = uiDocSearchForm.getUIFormDateTimeInput("startTime").getCalendar();
                if (uiDocSearchForm.haveEmptyField(uiApp, (Event<UIDocumentSearchForm>)event, new Object[]{fromDate})) {
                    return;
                }
                Calendar endDate = uiDocSearchForm.getUIFormDateTimeInput("endTime").getCalendar();
                if (endDate == null) {
                    endDate = Calendar.getInstance();
                }
                pagResult = "CREATED".equals(dateRangeSelected = (String)uiDocSearchForm.getUIStringInput("timeOpt").getValue()) ? uiDocSearchForm.searchDocumentByDate(QueryCriteria.DATE_RANGE_SELECTED.CREATED, fromDate, endDate, qCriteria, pageSize) : uiDocSearchForm.searchDocumentByDate(QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED, fromDate, endDate, qCriteria, pageSize);
            } else if ("docType".equals(radioValue)) {
                String documentType = (String)uiDocSearchForm.getUIStringInput("docType").getValue();
                if (uiDocSearchForm.haveEmptyField(uiApp, (Event<UIDocumentSearchForm>)event, new Object[]{documentType})) {
                    return;
                }
                pagResult = uiDocSearchForm.searchDocumentByType(documentType, qCriteria, pageSize);
            }
            UIWCMSearchResult uiWCSearchResult = (UIWCMSearchResult)uiDocTabSelector.getChild(UIWCMSearchResult.class);
            uiWCSearchResult.updateGrid(pagResult);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocTabSelector);
            uiDocTabSelector.setSelectedTab(uiWCSearchResult.getId());
        }
    }
}

