/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.container;

import java.io.Writer;
import java.util.ResourceBundle;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.form.UIForm;

public class UIFormFieldSet
extends UIContainer {
    public UIFormFieldSet(String name) {
        this.setId(name);
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        for (UIComponent child : this.getChildren()) {
            child.processDecode(context);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.getComponentConfig() != null) {
            super.processRender(context);
            return;
        }
        ResourceBundle ressourceBundle = context.getApplicationResourceBundle();
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        Writer writer = context.getWriter();
        writer.write("<div class=\"" + this.getId() + "\">");
        writer.write("<fieldset>");
        writer.write("<legend>" + uiForm.getLabel(this.getId()) + "</legend>");
        writer.write("<table class=\"UIFormGrid\">");
        for (UIComponent component : this.getChildren()) {
            if (!component.isRendered()) continue;
            writer.write("<tr>");
            String componentName = uiForm.getLabel(ressourceBundle, component.getId());
            if (componentName != null && componentName.length() > 0 && !componentName.equals(this.getId())) {
                writer.write("<td class=\"FieldLabel\">" + componentName + "</td>");
                writer.write("<td class=\"FieldComponent\">");
                this.renderUIComponent(component);
                writer.write("</td>");
            } else {
                writer.write("<td class=\"FieldComponent\" colspans=\"2\">");
                this.renderUIComponent(component);
                writer.write("</td>");
            }
            writer.write("</tr>");
        }
        writer.write("</table>");
        writer.write("</fieldset>");
        writer.write("</div>");
    }
}

