/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.page;

import java.util.ResourceBundle;
import org.exoplatform.wcm.webui.selector.page.UIPageNodeSelector;
import org.exoplatform.wcm.webui.selector.page.UIPageSelectorPanel;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/selector/page/UIPageSelector.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIPageSelector
extends UIForm {
    private UIComponent sourceUIComponent;
    private String returnFieldName;
    private String pageTitle;

    public UIPageSelector() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle bundle = context.getApplicationResourceBundle();
        String rootBundleKey = "UICategoryNavigationTargetPathPopupWindow.title.UIPageSelector";
        this.setPageTitle(bundle.getString(rootBundleKey));
        UIPageNodeSelector pageNodeSelector = (UIPageNodeSelector)this.addChild(UIPageNodeSelector.class, null, null);
        UITree uiTree = (UITree)pageNodeSelector.getChild(UITree.class);
        uiTree.setUIRightClickPopupMenu(null);
        pageNodeSelector.selectPageNodeByUri(null);
        UIPageSelectorPanel pageSelectorPanel = (UIPageSelectorPanel)this.addChild(UIPageSelectorPanel.class, null, null);
        pageSelectorPanel.updateGrid();
    }

    public String getReturnFieldName() {
        return this.returnFieldName;
    }

    public void setReturnFieldName(String name) {
        this.returnFieldName = name;
    }

    public UIComponent getSourceComponent() {
        return this.sourceUIComponent;
    }

    public void setSourceComponent(UIComponent uicomponent, String[] initParams) {
        this.sourceUIComponent = uicomponent;
        if (initParams == null || initParams.length < 0) {
            return;
        }
        for (int i = 0; i < initParams.length; ++i) {
            if (initParams[i].indexOf("returnField") > -1) {
                String[] array = initParams[i].split("=");
                this.returnFieldName = array[1];
                break;
            }
            this.returnFieldName = initParams[0];
        }
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        String action = context.getRequestParameter("formOp");
        Event event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIPageSelector> {
        public void execute(Event<UIPageSelector> event) throws Exception {
            UIPageSelector pageSelector = (UIPageSelector)((Object)event.getSource());
            UIPageNodeSelector pageNodeSelector = (UIPageNodeSelector)pageSelector.getChild(UIPageNodeSelector.class);
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UITree tree = (UITree)pageNodeSelector.getChild(UITree.class);
            if (tree.getParentSelected() == null && (uri == null || uri.length() < 1)) {
                pageNodeSelector.selectNavigation(pageNodeSelector.getSelectedNavigation().getId());
            } else {
                pageNodeSelector.selectPageNodeByUri(uri);
            }
            UIPageSelectorPanel pageSelectorPanel = (UIPageSelectorPanel)pageSelector.getChild(UIPageSelectorPanel.class);
            pageSelectorPanel.setSelectedPage(pageNodeSelector.getSelectedNode().getNode());
            pageSelectorPanel.updateGrid();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pageSelector);
        }
    }
}

