/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.webcontent;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.search.PaginatedQueryResult;
import org.exoplatform.wcm.webui.selector.document.UIDocumentPathSelector;
import org.exoplatform.wcm.webui.selector.document.UIDocumentTabSelector;
import org.exoplatform.wcm.webui.selector.webcontent.UIResultView;
import org.exoplatform.wcm.webui.selector.webcontent.UIWebContentPathSelector;
import org.exoplatform.wcm.webui.selector.webcontent.UIWebContentTabSelector;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/wcm/webui/UIWCMSearchResult.gtmpl", events={@EventConfig(listeners={SelectActionListener.class}), @EventConfig(listeners={ViewActionListener.class})})
public class UIWCMSearchResult
extends UIGrid {
    public static final String TITLE = "title".intern();
    public static final String NODE_EXPECT = "excerpt".intern();
    public static final String SCORE = "score".intern();
    public static final String CREATE_DATE = "CreateDate".intern();
    public static final String PUBLICATION_STATE = "publicationstate".intern();
    public static final String NODE_PATH = "path".intern();
    public String[] Actions = new String[]{"Select", "View"};
    public String[] BEAN_FIELDS = new String[]{TITLE, SCORE, PUBLICATION_STATE};

    public UIWCMSearchResult() throws Exception {
        this.configure(NODE_PATH, this.BEAN_FIELDS, this.Actions);
        this.getUIPageIterator().setId("UIWCMSearchResultPaginator");
    }

    public DateFormat getDateFormat() {
        Locale locale = new Locale(Util.getUIPortal().getLocale());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, locale);
        return dateFormat;
    }

    public void updateGrid(PaginatedQueryResult paginatedResult) throws Exception {
        this.getUIPageIterator().setPageList((PageList)paginatedResult);
    }

    public String getTitleNode(Node node) throws Exception {
        return node.hasProperty("exo:title") ? node.getProperty("exo:title").getValue().getString() : node.getName();
    }

    public Date getCreateDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar cal = node.getProperty("exo:dateCreated").getValue().getDate();
            return cal.getTime();
        }
        return null;
    }

    private Node getResultNode(String nodePath) throws Exception {
        Session session = this.getSession();
        Node resultNode = (Node)session.getItem(nodePath);
        return resultNode;
    }

    public String getExpect(String expect) {
        expect = expect.replaceAll("<[^>]*/?>", "");
        return expect;
    }

    public String getCurrentState(Node node) throws Exception {
        PublicationService pubService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        return pubService.getCurrentState(node);
    }

    public Session getSession() throws Exception {
        RepositoryService repoService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository maRepository = repoService.getCurrentRepository();
        String repository = maRepository.getConfiguration().getName();
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences prefs = pContext.getRequest().getPreferences();
        String workspace = prefs.getValue("workspace", null);
        if (workspace == null) {
            WCMConfigurationService wcmConfService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
            NodeLocation nodeLocation = wcmConfService.getLivePortalsLocation(repository);
            workspace = nodeLocation.getWorkspace();
        }
        Session session = SessionProviderFactory.createSessionProvider().getSession(workspace, maRepository);
        return session;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewActionListener
    extends EventListener<UIWCMSearchResult> {
        public void execute(Event<UIWCMSearchResult> event) throws Exception {
            UIWCMSearchResult uiWCSearchResult = (UIWCMSearchResult)((Object)event.getSource());
            UIWebContentTabSelector uiWCTabSelector = (UIWebContentTabSelector)uiWCSearchResult.getAncestorOfType(UIWebContentTabSelector.class);
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            if (uiWCTabSelector == null) {
                UIDocumentTabSelector uiDocTabSelector = (UIDocumentTabSelector)uiWCSearchResult.getAncestorOfType(UIDocumentTabSelector.class);
                Node resultNode = uiWCSearchResult.getResultNode(nodePath);
                UIResultView uiResultView = (UIResultView)uiDocTabSelector.getChild(UIResultView.class);
                if (uiResultView == null) {
                    uiResultView = (UIResultView)uiDocTabSelector.addChild(UIResultView.class, null, null);
                }
                uiResultView.init(resultNode, false);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocTabSelector);
                uiDocTabSelector.setSelectedTab(uiResultView.getId());
            } else {
                Node resultNode = uiWCSearchResult.getResultNode(nodePath);
                UIResultView uiResultView = (UIResultView)uiWCTabSelector.getChild(UIResultView.class);
                if (uiResultView == null) {
                    uiResultView = (UIResultView)uiWCTabSelector.addChild(UIResultView.class, null, null);
                }
                uiResultView.init(resultNode, false);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWCTabSelector);
                uiWCTabSelector.setSelectedTab(uiResultView.getId());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UIWCMSearchResult> {
        public void execute(Event<UIWCMSearchResult> event) throws Exception {
            UIWCMSearchResult uiWCSearchResult = (UIWCMSearchResult)((Object)event.getSource());
            UIWebContentTabSelector uiWCTabSelector = (UIWebContentTabSelector)uiWCSearchResult.getAncestorOfType(UIWebContentTabSelector.class);
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            if (uiWCTabSelector == null) {
                UIDocumentTabSelector uiDocTabSelector = (UIDocumentTabSelector)uiWCSearchResult.getAncestorOfType(UIDocumentTabSelector.class);
                UIDocumentPathSelector uiDocPathSelector = (UIDocumentPathSelector)uiDocTabSelector.getChild(UIDocumentPathSelector.class);
                String returnField = uiDocPathSelector.getReturnFieldName();
                ((UISelectable)uiDocPathSelector.getSourceComponent()).doSelect(returnField, (Object)nodePath);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiDocPathSelector.getSourceComponent().getParent());
            } else {
                UIWebContentPathSelector uiWCPathSelector = (UIWebContentPathSelector)uiWCTabSelector.getChild(UIWebContentPathSelector.class);
                String returnField = uiWCPathSelector.getReturnFieldName();
                ((UISelectable)uiWCPathSelector.getSourceComponent()).doSelect(returnField, (Object)nodePath);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiWCPathSelector.getSourceComponent().getParent());
            }
        }
    }
}

