/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.friendly.FriendlyService;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.CategoryBean;
import org.exoplatform.wcm.webui.clv.UICLVPortlet;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.wcm.webui.paginator.UICustomizeablePaginator;
import org.exoplatform.wcm.webui.reader.ContentReader;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={RefreshActionListener.class}), @EventConfig(listeners={DeleteContentActionListener.class}, confirm="UICLVPresentation.msg.confirm-delete"), @EventConfig(listeners={FastPublishActionListener.class})}), @ComponentConfig(type=UICustomizeablePaginator.class, events={@EventConfig(listeners={UICustomizeablePaginator.ShowPageActionListener.class})})})
public class UICLVPresentation
extends UIContainer {
    public static final String defaultScvParam = "content-id";
    private static final Log LOG = ExoLogger.getLogger((String)UICLVPresentation.class.getName());
    private String templatePath;
    private ResourceResolver resourceResolver;
    private UICustomizeablePaginator uiPaginator;
    private DateFormat dateFormatter = null;
    private Map<String, String> tagStyles = null;

    public void init(ResourceResolver resourceResolver, PageList dataPageList) throws Exception {
        String paginatorTemplatePath = Utils.getPortletPreference((String)"paginatorTemplatePath");
        this.templatePath = Utils.getPortletPreference((String)"formViewTemplatePath");
        this.resourceResolver = resourceResolver;
        this.uiPaginator = (UICustomizeablePaginator)this.addChild(UICustomizeablePaginator.class, null, null);
        this.uiPaginator.setTemplatePath(paginatorTemplatePath);
        this.uiPaginator.setResourceResolver(resourceResolver);
        this.uiPaginator.setPageList(dataPageList);
        Locale locale = Util.getPortalRequestContext().getLocale();
        this.dateFormatter = SimpleDateFormat.getDateTimeInstance(2, 2, locale);
    }

    public List<CategoryBean> getCategories() throws Exception {
        String fullPath = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPath();
        return this.getCategories(fullPath, "exo:taxonomy", 0);
    }

    public List<CategoryBean> getCategories(String primaryType) throws Exception {
        String fullPath = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPath();
        return this.getCategories(fullPath, primaryType, 0);
    }

    public List<CategoryBean> getCategories(boolean withChildren) throws Exception {
        String fullPath = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPath();
        return this.getCategories(fullPath, "exo:taxonomy", 0, withChildren);
    }

    public List<CategoryBean> getCategories(String fullPath, String primaryType, int depth) throws Exception {
        return this.getCategories(fullPath, primaryType, depth, true);
    }

    public List<CategoryBean> getCategories(String fullPath, String primaryType, int depth, boolean withChildren) throws Exception {
        if (fullPath == null || fullPath.length() == 0) {
            return null;
        }
        WCMComposer wcmComposer = (WCMComposer)this.getApplicationComponent(WCMComposer.class);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("filter-mode", Utils.getCurrentMode());
        String orderType = Utils.getPortletPreference((String)"orderType");
        String orderBy = Utils.getPortletPreference((String)"orderBy");
        filters.put("filter-order-by", orderBy);
        filters.put("filter-order-type", orderType);
        filters.put("filter-language", Util.getPortalRequestContext().getLocale().getLanguage());
        filters.put("filter-primary-type", primaryType);
        String clvBy = Utils.getPortletPreference((String)"showClvBy");
        String paramPath = Util.getPortalRequestContext().getRequestParameter(clvBy);
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByExpression((String)fullPath);
        List nodes = wcmComposer.getContents(nodeLocation.getWorkspace(), nodeLocation.getPath(), filters, WCMCoreUtils.getUserSessionProvider());
        LinkedList<CategoryBean> categories = new LinkedList<CategoryBean>();
        for (Node node : nodes) {
            List childs;
            String title = this.getTitle(node);
            String url = this.getCategoryURL(node);
            String path = node.getPath();
            long total = node.hasProperty("exo:total") ? node.getProperty("exo:total").getValue().getLong() : 0L;
            boolean isSelected = paramPath != null && paramPath.endsWith(path);
            CategoryBean cat = new CategoryBean(node.getName(), node.getPath(), title, url, isSelected, depth, total);
            NodeLocation catLocation = NodeLocation.getNodeLocationByNode((Node)node);
            if (withChildren && (childs = this.getCategories(catLocation.toString(), primaryType, depth + 1)) != null && childs.size() > 0) {
                cat.setChilds(childs);
            }
            categories.add(cat);
        }
        return categories;
    }

    public String getTagHtmlStyle(long tagCount) throws Exception {
        for (Map.Entry entry : this.getTagStyles().entrySet()) {
            if (!this.checkTagRate(tagCount, (String)entry.getKey())) continue;
            return (String)entry.getValue();
        }
        return "";
    }

    private Map<String, String> getTagStyles() throws Exception {
        if (this.tagStyles == null) {
            NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
            String workspace = "dms-system";
            this.tagStyles = new HashMap();
            for (Node tag : folksonomyService.getAllTagStyle(workspace)) {
                this.tagStyles.put(tag.getProperty("exo:styleRange").getValue().getString(), tag.getProperty("exo:htmlStyle").getValue().getString());
            }
        }
        return this.tagStyles;
    }

    private boolean checkTagRate(long numOfDocument, String range) throws Exception {
        String[] vals = StringUtils.split((String)range, (String)"..");
        int minValue = Integer.parseInt(vals[0]);
        int maxValue = vals[1].equals("*") ? Integer.MAX_VALUE : Integer.parseInt(vals[1]);
        return (long)minValue <= numOfDocument && numOfDocument < (long)maxValue;
    }

    public String getCategoryURL(Node node) throws Exception {
        String link = null;
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        String basePath = Utils.getPortletPreference((String)"basePath");
        String clvBy = Utils.getPortletPreference((String)"showClvBy");
        if (clvBy == null || clvBy.length() == 0) {
            clvBy = "folder-id";
        }
        String params = nodeLocation.getRepository() + ":" + nodeLocation.getWorkspace() + ":" + node.getPath();
        NodeURL nodeURL = (NodeURL)Util.getPortalRequestContext().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), basePath);
        nodeURL.setResource(resource).setQueryParameterValue(clvBy, params);
        link = baseURI + nodeURL.toString();
        FriendlyService friendlyService = (FriendlyService)this.getApplicationComponent(FriendlyService.class);
        link = friendlyService.getFriendlyUri(link);
        return link;
    }

    public boolean isShowField(String field) {
        String visible = Utils.getPortletPreference((String)field);
        return visible != null ? Boolean.parseBoolean(visible) : false;
    }

    public boolean showPaginator() throws Exception {
        String itemsPerPage = Utils.getPortletPreference((String)"itemsPerPage");
        int totalItems = this.uiPaginator.getTotalItems();
        return totalItems > Integer.parseInt(itemsPerPage);
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return this.resourceResolver;
    }

    public String getTitle(Node node) throws Exception {
        Node content;
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (title == null) {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                Node originalNode = node.getSession().getNodeByUUID(uuid);
                title = originalNode.getName();
            } else {
                title = node.getName();
            }
        }
        return ContentReader.getXSSCompatibilityContent((String)title);
    }

    public String getSummary(Node node) throws Exception {
        Node content;
        String desc = null;
        if (node.hasProperty("exo:summary")) {
            desc = node.getProperty("exo:summary").getValue().getString();
        } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:description")) {
            try {
                desc = content.getProperty("dc:description").getValues()[0].getString();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return desc;
    }

    public static String getInlineEditingField(Node orgNode, String propertyName, String defaultValue, String inputType, String idGenerator, String cssClass, boolean isGenericProperty, String ... arguments) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getInlineEditingField((Node)orgNode, (String)propertyName, (String)defaultValue, (String)inputType, (String)idGenerator, (String)cssClass, (boolean)isGenericProperty, (String[])arguments);
    }

    public String getSummaryField(Node node) throws Exception {
        Node content;
        String desc = null;
        if (node.hasProperty("exo:summary")) {
            return "exo:summary";
        }
        if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:description")) {
            try {
                desc = content.getProperty("dc:description").getValues()[0].getString();
                return "jcr:content/dc:description";
            }
            catch (Exception ex) {
                return null;
            }
        }
        return desc;
    }

    public String getURL(Node node) throws Exception {
        String link = null;
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        String basePath = Utils.getPortletPreference((String)"basePath");
        String scvWith = Utils.getPortletPreference((String)"showScvWith");
        if (scvWith == null || scvWith.length() == 0) {
            scvWith = defaultScvParam;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("/").append(nodeLocation.getRepository()).append("/").append(nodeLocation.getWorkspace());
        if (node.isNodeType("nt:frozenNode")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            Node originalNode = node.getSession().getNodeByUUID(uuid);
            sb.append(originalNode.getPath());
        } else {
            sb.append(node.getPath());
        }
        String param = sb.toString();
        param = Text.escapeIllegalJcrChars((String)param);
        NodeURL nodeURL = (NodeURL)Util.getPortalRequestContext().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), basePath);
        nodeURL.setResource(resource).setQueryParameterValue(scvWith, param);
        String fullPath = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPathParamValue();
        if (fullPath != null) {
            String clvBy = Utils.getPortletPreference((String)"showClvBy");
            nodeURL.setQueryParameterValue(clvBy, fullPath);
        }
        link = nodeURL.toString();
        FriendlyService friendlyService = (FriendlyService)this.getApplicationComponent(FriendlyService.class);
        link = friendlyService.getFriendlyUri(link);
        return link;
    }

    public String getWebdavURL(Node node) throws Exception {
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        String repository = nodeLocation.getRepository();
        String workspace = nodeLocation.getWorkspace();
        FriendlyService friendlyService = (FriendlyService)this.getApplicationComponent(FriendlyService.class);
        String link = "#";
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        if (node.isNodeType("nt:frozenNode")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            Node originalNode = node.getSession().getNodeByUUID(uuid);
            link = "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + originalNode.getPath() + "?version=" + node.getParent().getName();
        } else {
            link = "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + node.getPath();
        }
        return friendlyService.getFriendlyUri(link);
    }

    public String getAuthor(Node node) throws Exception {
        if (node.hasProperty("exo:owner")) {
            String ownerId = node.getProperty("exo:owner").getValue().getString();
            return ownerId;
        }
        return null;
    }

    public String getCreatedDate(Node node) throws Exception {
        Calendar calendar;
        if (node.hasProperty("exo:dateCreated") && (calendar = node.getProperty("exo:dateCreated").getValue().getDate()) != null) {
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getModifiedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateModified")) {
            Calendar calendar = node.getProperty("exo:dateModified").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getContentIcon(Node node) {
        try {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                Node originalNode = node.getSession().getNodeByUUID(uuid);
                return org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)originalNode, (String)"uiIcon16x16");
            }
            return org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)node, (String)"uiIcon16x16");
        }
        catch (RepositoryException e) {
            Utils.createPopupMessage((org.exoplatform.webui.core.UIContainer)this, (String)"UIMessageBoard.msg.get-content-icon", null, (int)0);
            return null;
        }
    }

    public String getHeader() {
        String header = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getHeader();
        if (header == null) {
            header = Utils.getPortletPreference((String)"header");
        }
        return header;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPaginator;
    }

    public List getCurrentPageData() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.uiPaginator.getCurrentPageData());
    }

    public void setDateTimeFormat(String format) {
        ((SimpleDateFormat)this.dateFormatter).applyPattern(format);
    }

    public String getEditLink(Node node, boolean isEditable, boolean isNew) {
        return Utils.getEditLink((Node)node, (boolean)isEditable, (boolean)isNew);
    }

    public boolean isShowEdit(Node node) {
        if (Utils.isShowQuickEdit()) {
            try {
                Node parent = node.getParent();
                ((ExtendedNode)node).checkPermission("set_property");
                ((ExtendedNode)parent).checkPermission("add_node");
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getIllustrativeImage(Node node) {
        String uri;
        block3: {
            WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)this.getApplicationComponent(WebSchemaConfigService.class);
            WebContentSchemaHandler contentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
            Node illustrativeImage = null;
            uri = null;
            try {
                illustrativeImage = contentSchemaHandler.getIllustrationImage(node);
                uri = WCMCoreUtils.generateImageURI((Node)illustrativeImage, null);
            }
            catch (PathNotFoundException ex) {
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return uri;
    }

    public boolean isShowRssLink() {
        if (this.getUIPageIterator().getAvailable() == 0) {
            return false;
        }
        PortletPreferences portletPreferences = Utils.getAllPortletPreferences();
        String currentApplicationMode = portletPreferences.getValue("application", null);
        if (currentApplicationMode.equals("ContentsByQuery")) {
            return false;
        }
        return this.isShowField("showRssLink") && (((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPathParamValue() != null || "AutoViewerMode".equals(Utils.getPortletPreference((String)"mode")));
    }

    public String getRssLink() {
        String portal = PortalContainer.getCurrentPortalContainerName();
        String rest = PortalContainer.getCurrentRestContextName();
        String server = Util.getPortalRequestContext().getRequest().getRequestURL().toString();
        int lastIndex = server.indexOf(portal);
        server = server.substring(0, lastIndex - 1) + Util.getPortalRequestContext().getPortalURI();
        String fullPath = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getFolderPathParamValue();
        if (fullPath == null || fullPath.length() == 0) {
            fullPath = Utils.getPortletPreference((String)"folderPath");
        }
        if (fullPath == null) {
            return "/" + portal + "/" + rest + "&siteName=" + Util.getUIPortal().getSiteKey().getName() + "&orderBy=" + Utils.getPortletPreference((String)"orderBy") + "&orderType=" + Utils.getPortletPreference((String)"orderType") + "&detailPage=" + Utils.getPortletPreference((String)"basePath") + "&detailParam=" + Utils.getPortletPreference((String)"showScvWith");
        }
        String[] repoWsPath = fullPath.split(":");
        return "/" + portal + "/" + rest + "/feed/rss?repository=" + repoWsPath[0] + "&workspace=" + repoWsPath[1] + "&server=" + server + "&siteName=" + Util.getUIPortal().getSiteKey().getName() + "&folderPath=" + repoWsPath[2] + "&orderBy=" + Utils.getPortletPreference((String)"orderBy") + "&orderType=" + Utils.getPortletPreference((String)"orderType") + "&detailPage=" + Utils.getPortletPreference((String)"basePath") + "&detailParam=" + Utils.getPortletPreference((String)"showScvWith");
    }

    public String addQuickEditDiv(String cssClass, Node viewNode) throws Exception {
        StringBuffer sb = new StringBuffer();
        String hoverClass = Utils.isShowQuickEdit() ? " containerHoverClassInner" : "";
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        sb.append("<div class=\"" + cssClass + " " + hoverClass + " \">");
        if (Utils.isShowQuickEdit()) {
            sb.append("  <div class=\"edittingContent\" style=\" z-index: 5\">");
            sb.append("    <div class=\"edittingToolBar clearfix\" >");
            sb.append("    <div class=\"btn-group\" >");
            if (this.isShowEdit(viewNode) && !LockUtil.isLocked((Node)viewNode)) {
                String strEditBundle;
                block18: {
                    strEditBundle = "Edit in the Content Explorer";
                    try {
                        strEditBundle = portletRequestContext.getApplicationResourceBundle().getString("UICLVPresentation.action.edit");
                    }
                    catch (MissingResourceException e) {
                        if (!LOG.isWarnEnabled()) break block18;
                        LOG.warn((Object)e.getMessage());
                    }
                }
                if (org.exoplatform.wcm.webui.utils.Utils.isShowFastPublish((Node)viewNode)) {
                    String strFastPublishBundle;
                    String fastPublishLink;
                    block19: {
                        fastPublishLink = this.event("FastPublish", NodeLocation.getExpressionByNode((Node)viewNode));
                        strFastPublishBundle = "Publish";
                        try {
                            strFastPublishBundle = portletRequestContext.getApplicationResourceBundle().getString("UICLVPresentation.action.publish");
                        }
                        catch (MissingResourceException e) {
                            if (!LOG.isWarnEnabled()) break block19;
                            LOG.warn((Object)e.getMessage());
                        }
                    }
                    sb.append("          <a class=\"btn\" href=\"" + fastPublishLink + "\" rel=\"tooltip\" data-placement=\"bottom\" title=\"" + strFastPublishBundle + "\">");
                    sb.append("            <i class=\"uiIconEcmsPublish\" ></i>");
                    sb.append("          </a>");
                }
                String contentEditLink = this.getEditLink(viewNode, true, false);
                sb.append("          <a class=\"btn\" onclick = 'eXo.ecm.CLV.addURL(this)' href=\"" + contentEditLink + "\" rel=\"tooltip\" data-placement=\"bottom\" title=\"" + strEditBundle + "\">");
                sb.append("            <i class=\"uiIconEdit\" \"></i>");
                sb.append("          </a>");
            } else {
                sb.append("          <a class=\"btn\" >");
                sb.append("            <i class=\"uiIconEcmsLock\" ></i>");
                sb.append("          </a>");
            }
            if (Utils.isShowDelete((Node)viewNode)) {
                String strDeleteBundle;
                String contentDeleteLink;
                block20: {
                    contentDeleteLink = this.event("DeleteContent", NodeLocation.getExpressionByNode((Node)viewNode));
                    strDeleteBundle = "Delete";
                    try {
                        strDeleteBundle = portletRequestContext.getApplicationResourceBundle().getString("UICLVPresentation.action.delete");
                    }
                    catch (MissingResourceException e) {
                        if (!LOG.isWarnEnabled()) break block20;
                        LOG.warn((Object)e.getMessage());
                    }
                }
                sb.append("          <a class=\"btn\" href=\"" + contentDeleteLink + "\"  rel=\"tooltip\" data-placement=\"bottom\" title=\"" + strDeleteBundle + "\">");
                sb.append("            <i class=\"uiIconRemove\"></i>");
                sb.append("          </a>");
            }
            sb.append("    </div>");
            if (viewNode.hasProperty("publication:currentState")) {
                String state;
                block21: {
                    state = viewNode.getProperty("publication:currentState").getValue().getString();
                    try {
                        state = portletRequestContext.getApplicationResourceBundle().getString("PublicationStates." + state);
                    }
                    catch (MissingResourceException e) {
                        if (!LOG.isWarnEnabled()) break block21;
                        LOG.warn((Object)e.getMessage());
                    }
                }
                sb.append("<div class=\"edittingCurrentState pull-left\">");
                if ("Published".equals(state)) {
                    sb.append("<span class=\"publishText\"><i class=\"uiIconTick\"></i>" + state + "</span>");
                } else if ("Draft".equals(state)) {
                    sb.append("<span class=\"draftText\">" + state + "</span>");
                } else {
                    sb.append("<span>" + state + "</span>");
                }
                sb.append(" </div>");
            }
            sb.append("      </div>");
            sb.append("    </div>");
        }
        return sb.toString();
    }

    public String getBackLink(String currentPath) {
        String treePath;
        String[] treeNodes;
        String preferencePath = Utils.getPortletPreference((String)"folderPath");
        String targetPage = Utils.getPortletPreference((String)"basePath");
        NodeURL nodeURL = (NodeURL)Util.getPortalRequestContext().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), targetPage);
        nodeURL.setResource(resource);
        if (currentPath.contains(preferencePath) && (treeNodes = (treePath = currentPath.substring(preferencePath.length() + 1)).split("/")).length > 1) {
            String paramPath = currentPath.substring(0, currentPath.lastIndexOf("/"));
            String clvBy = Utils.getPortletPreference((String)"showClvBy");
            nodeURL.setQueryParameterValue(clvBy, paramPath);
        }
        return nodeURL.toString();
    }
}

