/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.comparator.PropertyValueComparator;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.PaginatedResultIterator;
import org.exoplatform.services.wcm.publication.Result;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.PageListFactory;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVContainer;
import org.exoplatform.wcm.webui.clv.UICLVPortlet;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ContentListViewer/UICLVContainer.gtmpl", events={@EventConfig(listeners={UICLVContainer.PreferencesActionListener.class})})
public class UICLVManualMode
extends UICLVContainer {
    private static final Log LOG = ExoLogger.getLogger((String)UICLVManualMode.class.getName());

    public void init() throws Exception {
        String sharedCache;
        PortletPreferences portletPreferences = Utils.getAllPortletPreferences();
        String query = portletPreferences.getValue("query", "");
        String contextualMode = portletPreferences.getValue("contextualFolder", null);
        String workspace = portletPreferences.getValue("workspace", null);
        ArrayList<Node> nodes = new ArrayList<Node>();
        String folderPath = "";
        HashMap<String, String> filters = new HashMap<String, String>();
        if ("contextualEnable".equals(contextualMode)) {
            String folderParamName = portletPreferences.getValue("showClvBy", null);
            if (folderParamName == null || folderParamName.length() == 0) {
                folderParamName = "folder-id";
            }
            folderPath = Util.getPortalRequestContext().getRequestParameter(folderParamName);
        }
        sharedCache = "true".equals(sharedCache = portletPreferences.getValue("sharedCache", "true")) ? "public" : "user";
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        String strQuery = ((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).getQueryStatement(query);
        if (strQuery != null) {
            strQuery = strQuery.replaceAll("\"", "'");
        }
        if (((UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class)).isQueryApplication() && "contextualEnable".equals(contextualMode) && Utils.checkQuery((String)workspace, (String)strQuery, (String)"sql")) {
            NodeLocation nodeLocation = new NodeLocation();
            nodeLocation.setWorkspace(workspace);
            nodeLocation.setPath("/");
            nodeLocation.setSystemSession(false);
            filters.put("filter-query-full", strQuery);
            Result rNodes = ((WCMComposer)WCMCoreUtils.getService(WCMComposer.class)).getPaginatedContents(nodeLocation, filters, WCMCoreUtils.getUserSessionProvider());
            PaginatedResultIterator paginatedResultIterator = new PaginatedResultIterator(rNodes, itemsPerPage);
            this.getChildren().clear();
            ResourceResolver resourceResolver = this.getTemplateResourceResolver();
            PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            UICLVPresentation clvPresentation = (UICLVPresentation)this.addChild(UICLVPresentation.class, null, UICLVPresentation.class.getSimpleName() + "_" + pContext.getWindowId());
            clvPresentation.init(resourceResolver, (PageList)paginatedResultIterator);
            return;
        }
        String[] listContent = portletPreferences.getValue("folderPath", null).split(";");
        LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        ArrayList<Node> originalList = new ArrayList<Node>();
        if (listContent != null && listContent.length != 0) {
            for (String itemPath : listContent) {
                Node currentNode;
                block10: {
                    currentNode = NodeLocation.getNodeByExpression((String)itemPath);
                    if (currentNode == null) continue;
                    try {
                        linkManager.updateSymlink(currentNode);
                        currentNode = NodeLocation.getNodeByExpression((String)itemPath);
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) break block10;
                        LOG.error((Object)("Can not update symlink: " + currentNode.getPath()), (Throwable)e);
                    }
                }
                originalList.add(currentNode);
            }
        }
        String orderBy = portletPreferences.getValue("orderBy", "exo:title");
        String orderType = portletPreferences.getValue("orderType", "ASC");
        Collections.sort(originalList, new PropertyValueComparator(orderBy, "ASC".equals(orderType) ? "Ascending" : "Descending"));
        for (Node node : originalList) {
            Node viewNode = Utils.getViewableNodeByComposer((String)WCMCoreUtils.getRepository().getConfiguration().getName(), (String)Text.escapeIllegalJcrChars((String)node.getSession().getWorkspace().getName()), (String)Text.escapeIllegalJcrChars((String)node.getPath()), null, (String)sharedCache);
            if (viewNode == null) continue;
            nodes.add(viewNode);
        }
        if (nodes.size() == 0) {
            this.messageKey = "UICLVContainer.msg.non-contents";
        }
        this.getChildren().clear();
        AbstractPageList pageList = PageListFactory.createPageList(nodes, (int)itemsPerPage, null, (SearchDataCreator)new UICLVContainer.CLVNodeCreator());
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        UICLVPresentation clvPresentation = (UICLVPresentation)this.addChild(UICLVPresentation.class, null, UICLVPresentation.class.getSimpleName() + "_" + pContext.getWindowId());
        clvPresentation.init(resourceResolver, (PageList)pageList);
    }

    public boolean isShowInfoBar() throws Exception {
        return UIPortlet.getCurrentUIPortlet().getShowInfoBar();
    }

    public String getPortletName() throws Exception {
        return UICLVManualMode.class.getSimpleName();
    }
}

