/*
 * Decompiled with CFR 0.152.
 */
package exo.exoplatform.services.wcm.extensions.publication;

import exo.exoplatform.services.wcm.extensions.publication.BasePublicationTestCase;
import java.util.Date;
import java.util.LinkedList;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.AuthoringPublicationPlugin;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class TestWCMPublicationService
extends BasePublicationTestCase {
    private static final String CURRENT_STATE = "publication:currentState";
    private static final String TEST = "test";
    private static final String ENROLLED = "enrolled";
    private static final String PUBLISHED = "published";
    private WCMPublicationService publicationService_;
    private WebpagePublicationPlugin plugin_;
    private Node node_;
    private Node testSite;
    private Node documentTest;
    private final String testPage = "portal::classic::testPage";
    private final String testPortletPreferences = "portal#classic:/web/BannerPortlet/testPortletPreferences";
    private DataStorage storage_;
    private NavigationService navService;
    private LinkedList<Event> events;
    private ListenerService listenerService;
    private OrganizationService org;

    public void setUp() throws Exception {
        super.setUp();
        this.publicationService_ = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        this.applySystemSession();
        Node rootSite = (Node)this.session.getItem("/sites content/live");
        this.testSite = rootSite.addNode(TEST);
        this.documentTest = this.testSite.addNode("documents");
        this.node_ = this.testSite.addNode(TEST);
        this.node_.addMixin("mix:referenceable");
        this.session.save();
        ConversationState c = new ConversationState(new Identity(this.session.getUserID()));
        ConversationState.setCurrent((ConversationState)c);
        this.plugin_ = new AuthoringPublicationPlugin();
        this.plugin_.setName("Authoring publication");
        this.plugin_.setDescription("Authoring publication");
        this.publicationService_.addPublicationPlugin(this.plugin_);
        Listener listener = new Listener(){

            public void onEvent(Event event) throws Exception {
                TestWCMPublicationService.this.events.add(event);
            }
        };
        PortalContainer container = PortalContainer.getInstance();
        this.storage_ = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
        this.navService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        this.events = new LinkedList();
        this.listenerService = (ListenerService)container.getComponentInstanceOfType(ListenerService.class);
        this.org = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
        this.listenerService.addListener(DataStorage.PAGE_CREATED, listener);
        this.listenerService.addListener(DataStorage.PAGE_REMOVED, listener);
        this.listenerService.addListener(DataStorage.PAGE_UPDATED, listener);
        this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_created", listener);
        this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_destroyed", listener);
        this.listenerService.addListener("org.exoplatform.portal.mop.navigation.navigation_updated", listener);
        this.listenerService.addListener(DataStorage.PORTAL_CONFIG_CREATED, listener);
        this.listenerService.addListener(DataStorage.PORTAL_CONFIG_UPDATED, listener);
        this.listenerService.addListener(DataStorage.PORTAL_CONFIG_REMOVED, listener);
    }

    public void tearDown() throws Exception {
        this.publicationService_.getWebpagePublicationPlugins().clear();
        this.node_.remove();
        this.testSite.remove();
        this.session.save();
        RequestLifeCycle.end();
        super.tearDown();
    }

    public void testEnrollNodeInLifecycle1() throws Exception {
        this.publicationService_.enrollNodeInLifecycle(this.node_, this.plugin_.getLifecycleName());
        TestWCMPublicationService.assertEquals((String)ENROLLED, (String)this.node_.getProperty(CURRENT_STATE).getString());
    }

    public void testEnrollNodeInLifecycle2() throws Exception {
        this.publicationService_.enrollNodeInLifecycle(this.node_, TEST, this.node_.getSession().getUserID());
        TestWCMPublicationService.assertEquals((String)"draft", (String)this.node_.getProperty(CURRENT_STATE).getString());
    }

    public void testIsEnrolledWCMInLifecycle() throws Exception {
        TestWCMPublicationService.assertFalse((boolean)this.publicationService_.isEnrolledInWCMLifecycle(this.node_));
        this.publicationService_.enrollNodeInLifecycle(this.node_, this.plugin_.getLifecycleName());
        TestWCMPublicationService.assertTrue((boolean)this.publicationService_.isEnrolledInWCMLifecycle(this.node_));
    }

    public void testGetContentState() throws Exception {
        this.publicationService_.enrollNodeInLifecycle(this.node_, this.plugin_.getLifecycleName());
        TestWCMPublicationService.assertEquals((String)ENROLLED, (String)this.publicationService_.getContentState(this.node_));
    }

    public void testUnsubscribeLifecycle() throws Exception {
        this.publicationService_.enrollNodeInLifecycle(this.node_, this.plugin_.getLifecycleName());
        this.publicationService_.unsubcribeLifecycle(this.node_);
        TestWCMPublicationService.assertFalse((boolean)this.publicationService_.isEnrolledInWCMLifecycle(this.node_));
    }

    public void testUpdateLifecyleOnChangeContent1() throws Exception {
        this.publicationService_.updateLifecyleOnChangeContent(this.node_, TEST, this.node_.getSession().getUserID(), PUBLISHED);
        TestWCMPublicationService.assertEquals((String)PUBLISHED, (String)this.publicationService_.getContentState(this.node_));
        this.publicationService_.updateLifecyleOnChangeContent(this.node_, TEST, this.node_.getSession().getUserID(), "draft");
        TestWCMPublicationService.assertEquals((String)"draft", (String)this.publicationService_.getContentState(this.node_));
    }

    public void testUpdateLifecyleOnChangeContent2() throws Exception {
        this.publicationService_.updateLifecyleOnChangeContent(this.node_, TEST, this.node_.getSession().getUserID());
        TestWCMPublicationService.assertEquals((String)"draft", (String)this.publicationService_.getContentState(this.node_));
    }

    public void testUpdateLifecyleOnChangeContent3() throws Exception {
        Node htmlContent;
        Node htmlNode;
        String htmlData = "This is the default.html file.";
        Node webContent = this.createWebcontentNode(this.documentTest, "webcontent", "html", "css", "js");
        Node documentFolder = webContent.getNode("documents");
        try {
            htmlNode = documentFolder.getNode("default.html");
        }
        catch (Exception ex) {
            htmlNode = documentFolder.addNode("default.html", "nt:file");
        }
        if (!htmlNode.isNodeType("exo:htmlFile")) {
            htmlNode.addMixin("exo:htmlFile");
        }
        try {
            htmlContent = htmlNode.getNode("jcr:content");
        }
        catch (Exception ex) {
            htmlContent = htmlNode.addNode("jcr:content", "nt:resource");
        }
        htmlContent.setProperty("jcr:encoding", "UTF-8");
        htmlContent.setProperty("jcr:mimeType", "text/html");
        htmlContent.setProperty("jcr:lastModified", new Date().getTime());
        htmlContent.setProperty("jcr:data", htmlData);
        documentFolder.save();
        this.publicationService_.updateLifecyleOnChangeContent(webContent, TEST, webContent.getSession().getUserID());
        TestWCMPublicationService.assertEquals((String)"draft", (String)this.publicationService_.getContentState(webContent));
        this.publicationService_.updateLifecyleOnChangeContent(htmlNode, TEST, webContent.getSession().getUserID());
        TestWCMPublicationService.assertEquals(null, (String)this.publicationService_.getContentState(htmlNode));
    }
}

