/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui.UIPublicationPanel;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.mockito.Mockito;

public class TestUIPublicationPanel
extends TestCase {
    public void testIsAuthorizedByRole() throws Exception {
        UIPublicationPanel panel = (UIPublicationPanel)Mockito.mock(UIPublicationPanel.class);
        Identity tom = this.createIdentity("tom", "validator:/org/human-resources");
        Identity bill = this.createIdentity("bill", "redactor:/org/human-resources", "validator:/org/finances");
        ArrayList<AccessControlEntry> entries = new ArrayList<AccessControlEntry>();
        entries.add(new AccessControlEntry("*:/org/finance", "read"));
        entries.add(new AccessControlEntry("*:/org/human-resources", "set_property"));
        AccessControlList acl = new AccessControlList("foo", entries);
        NodeImpl node = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)node.getACL()).thenReturn((Object)acl);
        LifecyclesConfig.State state = new LifecyclesConfig.State();
        state.setRole("validator");
        Mockito.when((Object)panel.isAuthorizedByRole((LifecyclesConfig.State)Mockito.any(LifecyclesConfig.State.class), (Identity)Mockito.any(Identity.class), (NodeImpl)Mockito.any(NodeImpl.class))).thenCallRealMethod();
        TestUIPublicationPanel.assertTrue((String)"tom should be allowed", (boolean)panel.isAuthorizedByRole(state, tom, node));
        TestUIPublicationPanel.assertFalse((String)"bill should not be allowed", (boolean)panel.isAuthorizedByRole(state, bill, node));
    }

    public void testIsAuthorizedByRoles() throws Exception {
        UIPublicationPanel panel = (UIPublicationPanel)Mockito.mock(UIPublicationPanel.class);
        Identity tom = this.createIdentity("tom", "validator:/org/human-resources");
        Identity bill = this.createIdentity("bill", "redactor:/org/human-resources", "validator:/org/finances");
        Identity bart = this.createIdentity("bart", "member:/org/human-resources");
        ArrayList<AccessControlEntry> entries = new ArrayList<AccessControlEntry>();
        entries.add(new AccessControlEntry("*:/org/finance", "read"));
        entries.add(new AccessControlEntry("*:/org/human-resources", "set_property"));
        AccessControlList acl = new AccessControlList("foo", entries);
        NodeImpl node = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)node.getACL()).thenReturn((Object)acl);
        LifecyclesConfig.State state = new LifecyclesConfig.State();
        state.setRoles(Arrays.asList("validator", "redactor"));
        Mockito.when((Object)panel.isAuthorizedByRole((LifecyclesConfig.State)Mockito.any(LifecyclesConfig.State.class), (Identity)Mockito.any(Identity.class), (NodeImpl)Mockito.any(NodeImpl.class))).thenCallRealMethod();
        TestUIPublicationPanel.assertTrue((String)"tom should be allowed", (boolean)panel.isAuthorizedByRole(state, tom, node));
        TestUIPublicationPanel.assertTrue((String)"bill should be allowed", (boolean)panel.isAuthorizedByRole(state, bill, node));
        TestUIPublicationPanel.assertFalse((String)"bart should not be allowed", (boolean)panel.isAuthorizedByRole(state, bart, node));
    }

    public void testIsAuthorizedByMemberships() throws Exception {
        UIPublicationPanel panel = (UIPublicationPanel)Mockito.mock(UIPublicationPanel.class);
        Identity tom = this.createIdentity("tom", "validator:/org/human-resources");
        Identity bill = this.createIdentity("bill", "author:/CA/alerteInformatique", "validator:/CA/informations");
        ArrayList<String> memberships = new ArrayList<String>();
        memberships.add("author:/CA/communicationDG");
        memberships.add("author:/CA/alerteSanitaire");
        memberships.add("author:/CA/alerteInformatique");
        memberships.add("author:/CA/informations");
        LifecyclesConfig.State state = new LifecyclesConfig.State();
        state.setMemberships(memberships);
        Mockito.when((Object)panel.isAuthorizedByMembership((LifecyclesConfig.State)Mockito.any(LifecyclesConfig.State.class), (Identity)Mockito.any(Identity.class))).thenCallRealMethod();
        TestUIPublicationPanel.assertFalse((String)"tom should not be allowed", (boolean)panel.isAuthorizedByMembership(state, tom));
        TestUIPublicationPanel.assertTrue((String)"bill should be allowed", (boolean)panel.isAuthorizedByMembership(state, bill));
    }

    public void testIsAuthorizedByMembership() throws Exception {
        UIPublicationPanel panel = (UIPublicationPanel)Mockito.mock(UIPublicationPanel.class);
        Identity tom = this.createIdentity("tom", "validator:/org/human-resources");
        Identity bill = this.createIdentity("bill", "redactor:/org/human-resources", "redactor:/org/finance");
        LifecyclesConfig.State state = new LifecyclesConfig.State();
        state.setMembership("redactor:/org/finance");
        Mockito.when((Object)panel.isAuthorizedByMembership((LifecyclesConfig.State)Mockito.any(LifecyclesConfig.State.class), (Identity)Mockito.any(Identity.class))).thenCallRealMethod();
        TestUIPublicationPanel.assertFalse((String)"tom should not be allowed", (boolean)panel.isAuthorizedByMembership(state, tom));
        TestUIPublicationPanel.assertTrue((String)"bill should be allowed", (boolean)panel.isAuthorizedByMembership(state, bill));
    }

    public void testCheckAllowed() throws Exception {
        UIPublicationPanel panel = (UIPublicationPanel)Mockito.mock(UIPublicationPanel.class);
        IdentityRegistry registry = new IdentityRegistry(null);
        this.registerUser(registry, "tom", "validator:/org/human-resources");
        this.registerUser(registry, "bill", "redactor:/org/human-resources", "validator:/org/finances");
        Mockito.when((Object)((IdentityRegistry)panel.getApplicationComponent(IdentityRegistry.class))).thenReturn((Object)registry);
        ArrayList<AccessControlEntry> entries = new ArrayList<AccessControlEntry>();
        entries.add(new AccessControlEntry("*:/org/finances", "read"));
        entries.add(new AccessControlEntry("*:/org/human-resources", "set_property"));
        AccessControlList acl = new AccessControlList("foo", entries);
        NodeImpl node = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)node.getACL()).thenReturn((Object)acl);
        LifecyclesConfig.State state = new LifecyclesConfig.State();
        state.setMembership("redactor:/org/finances");
        state.setRole("validator");
        Mockito.when((Object)panel.canReachState((LifecyclesConfig.State)Mockito.any(LifecyclesConfig.State.class), Mockito.anyString(), (NodeImpl)Mockito.any(NodeImpl.class))).thenCallRealMethod();
        Mockito.when((Object)panel.isAuthorizedByMembership((LifecyclesConfig.State)Mockito.any(LifecyclesConfig.State.class), (Identity)Mockito.any(Identity.class))).thenCallRealMethod();
        Mockito.when((Object)panel.isAuthorizedByRole((LifecyclesConfig.State)Mockito.any(LifecyclesConfig.State.class), (Identity)Mockito.any(Identity.class), (NodeImpl)Mockito.any(NodeImpl.class))).thenCallRealMethod();
        TestUIPublicationPanel.assertTrue((String)"tom should be allowed", (boolean)panel.canReachState(state, "tom", node));
        TestUIPublicationPanel.assertFalse((String)"bill should be allowed", (boolean)panel.canReachState(state, "bill", node));
    }

    private void registerUser(IdentityRegistry registry, String userId, String ... memberships) {
        Identity identity = this.createIdentity(userId, memberships);
        registry.register(identity);
    }

    private Identity createIdentity(String userId, String ... memberships) {
        ArrayList<MembershipEntry> membershipEntries = new ArrayList<MembershipEntry>();
        for (String membership : memberships) {
            membershipEntries.add(new MembershipEntry(membership.split(":")[1], membership.split(":")[0]));
        }
        Identity identity = new Identity(userId, membershipEntries);
        return identity;
    }
}

