/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.scheduler.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.extensions.scheduler.impl.ChangeStateCronJobImpl;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"javax.management.*", "javax.xml.*", "org.apache.xerces.*", "org.xml.*"})
@PrepareForTest(value={ChangeStateCronJobImpl.class, SessionProvider.class, WCMCoreUtils.class})
public class TestChangeStateCronJob {
    @Test
    public void testChangeStateOnContentInTrash() throws Exception {
        PowerMockito.mockStatic(ManagementFactory.class, (Answer)new Answer<Object>(this){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String methodName = invocation.getMethod().getName();
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"getRuntimeMXBean")) {
                    RuntimeMXBean mxBean = (RuntimeMXBean)Mockito.mock(RuntimeMXBean.class);
                    Mockito.when((Object)mxBean.getUptime()).thenReturn((Object)150000L);
                    return mxBean;
                }
                return invocation.callRealMethod();
            }
        });
        final Session session = (Session)Mockito.mock(Session.class);
        final PublicationPlugin publicationPlugin = (PublicationPlugin)Mockito.mock(PublicationPlugin.class);
        PowerMockito.mockStatic(SessionProvider.class, (Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String methodName = invocation.getMethod().getName();
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"createSystemProvider")) {
                    SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
                    Mockito.when((Object)sessionProvider.getSession(Mockito.anyString(), (ManageableRepository)Mockito.any())).thenReturn((Object)session);
                    QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
                    Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
                    Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
                    Mockito.when((Object)session.getWorkspace().getQueryManager()).thenReturn((Object)queryManager);
                    Query query = (Query)Mockito.mock(Query.class);
                    Mockito.when((Object)queryManager.createQuery(Mockito.anyString(), (String)Mockito.eq((Object)"sql"))).thenReturn((Object)query);
                    QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
                    Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
                    Property dateProperty = (Property)Mockito.mock(Property.class);
                    Mockito.when((Object)dateProperty.getDate()).thenReturn((Object)Calendar.getInstance());
                    Node nodeInTrash = (Node)PowerMockito.mock(Node.class);
                    PowerMockito.when((Object)nodeInTrash.getPath()).thenReturn((Object)"/Trash/nodeInTrash");
                    PowerMockito.when((Object)nodeInTrash.getProperty((String)Mockito.eq((Object)"publication:startPublishedDate"))).thenReturn((Object)dateProperty);
                    Node nodeUnderJCRSystem = (Node)PowerMockito.mock(Node.class);
                    PowerMockito.when((Object)nodeUnderJCRSystem.getPath()).thenReturn((Object)"/jcr:system/nodeUnderJCRSystem");
                    PowerMockito.when((Object)nodeUnderJCRSystem.getProperty((String)Mockito.eq((Object)"publication:startPublishedDate"))).thenReturn((Object)dateProperty);
                    Node nodeToPublish = (Node)PowerMockito.mock(Node.class);
                    PowerMockito.when((Object)nodeToPublish.getPath()).thenReturn((Object)"/sites/sample/nodeToPublish");
                    PowerMockito.when((Object)nodeToPublish.getProperty((String)Mockito.eq((Object)"publication:startPublishedDate"))).thenReturn((Object)dateProperty);
                    Node nodeToPublishWithoutStartDate = (Node)PowerMockito.mock(Node.class);
                    PowerMockito.when((Object)nodeToPublishWithoutStartDate.getPath()).thenReturn((Object)"/sites/sample/nodeToPublishWithoutStartDate");
                    PowerMockito.when((Object)nodeToPublishWithoutStartDate.getProperty((String)Mockito.eq((Object)"publication:startPublishedDate"))).thenReturn(null);
                    PowerMockito.when((Object)nodeToPublishWithoutStartDate.getProperty((String)Mockito.eq((Object)"publication:endPublishedDate"))).thenReturn((Object)dateProperty);
                    Node nodeToPublishWithoutEndDate = (Node)PowerMockito.mock(Node.class);
                    PowerMockito.when((Object)nodeToPublishWithoutEndDate.getPath()).thenReturn((Object)"/sites/sample/nodeToPublishWithoutEndDate");
                    PowerMockito.when((Object)nodeToPublishWithoutEndDate.getProperty((String)Mockito.eq((Object)"publication:startPublishedDate"))).thenReturn((Object)dateProperty);
                    PowerMockito.when((Object)nodeToPublishWithoutEndDate.getProperty((String)Mockito.eq((Object)"publication:endPublishedDate"))).thenReturn(null);
                    NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
                    Object[] hasNextReturns = new Boolean[]{true, true, true, false, true, true, false};
                    Object[] nextReturnedNodes = new Node[]{nodeInTrash, nodeUnderJCRSystem, nodeToPublish, nodeToPublishWithoutStartDate, nodeToPublishWithoutEndDate};
                    Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, hasNextReturns);
                    Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)nodeInTrash, nextReturnedNodes);
                    Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator);
                    return sessionProvider;
                }
                return invocation.callRealMethod();
            }
        });
        PowerMockito.mockStatic(WCMCoreUtils.class, (Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String methodName = invocation.getMethod().getName();
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"getService") && invocation.getArgument(0, Class.class) != null) {
                    Class serviceClass = (Class)invocation.getArgument(0, Class.class);
                    if (serviceClass.equals(TrashService.class)) {
                        return new TrashService(this){

                            public String moveToTrash(Node node, SessionProvider sessionProvider) throws Exception {
                                return null;
                            }

                            public String moveToTrash(Node node, SessionProvider sessionProvider, int deep) throws Exception {
                                return null;
                            }

                            public void restoreFromTrash(String trashNodePath, SessionProvider sessionProvider) throws Exception {
                            }

                            public List<Node> getAllNodeInTrash(SessionProvider sessionProvider) throws Exception {
                                return null;
                            }

                            public List<Node> getAllNodeInTrashByUser(SessionProvider sessionProvider, String userName) throws Exception {
                                return null;
                            }

                            public void removeRelations(Node node, SessionProvider sessionProvider) throws Exception {
                            }

                            public boolean isInTrash(Node node) throws RepositoryException {
                                return node.getPath().startsWith("/Trash") && !node.getPath().equals("/Trash");
                            }

                            public Node getTrashHomeNode() {
                                return null;
                            }

                            public Node getNodeByTrashId(String trashId) throws InvalidQueryException, RepositoryException {
                                return null;
                            }
                        };
                    }
                    if (serviceClass.equals(PublicationService.class)) {
                        PublicationService publicationService = (PublicationService)Mockito.mock(PublicationService.class);
                        HashMap<String, PublicationPlugin> publicationPlugins = new HashMap<String, PublicationPlugin>();
                        publicationPlugins.put("Authoring publication", publicationPlugin);
                        Mockito.when((Object)publicationService.getPublicationPlugins()).thenReturn(publicationPlugins);
                        return publicationService;
                    }
                    if (serviceClass.equals(RepositoryService.class)) {
                        RepositoryService repositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
                        ManageableRepository manageableRepository = (ManageableRepository)PowerMockito.mock(ManageableRepository.class);
                        PowerMockito.when((Object)repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
                        return repositoryService;
                    }
                }
                return invocation.callRealMethod();
            }
        });
        JobExecutionContext context = (JobExecutionContext)Mockito.mock(JobExecutionContext.class);
        JobDetail jobDetail = (JobDetail)Mockito.mock(JobDetail.class);
        JobDataMap jobDataMap = (JobDataMap)Mockito.mock(JobDataMap.class);
        Mockito.when((Object)context.getJobDetail()).thenReturn((Object)jobDetail);
        Mockito.when((Object)jobDetail.getJobDataMap()).thenReturn((Object)jobDataMap);
        Mockito.when((Object)jobDataMap.getString((String)Mockito.eq((Object)"fromState"))).thenReturn((Object)"staged");
        Mockito.when((Object)jobDataMap.getString((String)Mockito.eq((Object)"toState"))).thenReturn((Object)"published");
        Mockito.when((Object)jobDataMap.getString((String)Mockito.eq((Object)"predefinedPath"))).thenReturn((Object)"collaboration:/");
        ChangeStateCronJobImpl cronJobImpl = new ChangeStateCronJobImpl();
        cronJobImpl.execute(context);
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)0))).save();
        ((PublicationPlugin)Mockito.verify((Object)publicationPlugin, (VerificationMode)Mockito.times((int)1))).changeState((Node)Mockito.any(), Mockito.anyString(), (HashMap)Matchers.any());
    }
}

