/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.contrib.http;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.contrib.http.AbstractHttpHandler;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.contrib.http.HttpExtractor;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.contrib.http.HttpRequestContext;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.contrib.http.util.HttpMeasureConstants;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats.Stats;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.stats.StatsRecorder;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.tags.TagContext;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.tags.TagValue;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.tags.Tagger;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.tags.Tags;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.trace.Link;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.trace.Span;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.trace.SpanBuilder;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.trace.SpanContext;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.trace.Tracer;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.trace.propagation.SpanContextParseException;
import org.exoplatform.services.cms.clouddrives.gdrive.shaded.io.opencensus.trace.propagation.TextFormat;

public class HttpServerHandler<Q, P, C>
extends AbstractHttpHandler<Q, P> {
    private final TextFormat.Getter<C> getter;
    private final TextFormat textFormat;
    private final Tracer tracer;
    private final Boolean publicEndpoint;
    private final StatsRecorder statsRecorder;
    private final Tagger tagger;

    public HttpServerHandler(Tracer tracer, HttpExtractor<Q, P> extractor, TextFormat textFormat, TextFormat.Getter<C> getter, Boolean publicEndpoint) {
        super(extractor);
        Preconditions.checkNotNull((Object)tracer, (Object)"tracer");
        Preconditions.checkNotNull((Object)textFormat, (Object)"textFormat");
        Preconditions.checkNotNull(getter, (Object)"getter");
        Preconditions.checkNotNull((Object)publicEndpoint, (Object)"publicEndpoint");
        this.tracer = tracer;
        this.textFormat = textFormat;
        this.getter = getter;
        this.publicEndpoint = publicEndpoint;
        this.statsRecorder = Stats.getStatsRecorder();
        this.tagger = Tags.getTagger();
    }

    public HttpRequestContext handleStart(C carrier, Q request) {
        Preconditions.checkNotNull(carrier, (Object)"carrier");
        Preconditions.checkNotNull(request, (Object)"request");
        SpanBuilder spanBuilder = null;
        String spanName = this.getSpanName(request, this.extractor);
        SpanContext spanContext = null;
        try {
            spanContext = this.textFormat.extract(carrier, this.getter);
        }
        catch (SpanContextParseException spanContextParseException) {
            // empty catch block
        }
        spanBuilder = spanContext == null || this.publicEndpoint != false ? this.tracer.spanBuilder(spanName) : this.tracer.spanBuilderWithRemoteParent(spanName, spanContext);
        Span span = spanBuilder.startSpan();
        if (this.publicEndpoint.booleanValue() && spanContext != null) {
            span.addLink(Link.fromSpanContext(spanContext, Link.Type.PARENT_LINKED_SPAN));
        }
        if (span.getOptions().contains((Object)Span.Options.RECORD_EVENTS)) {
            this.addSpanRequestAttributes(span, request, this.extractor);
        }
        return this.getNewContext(span, this.tagger.getCurrentTagContext());
    }

    public void handleEnd(HttpRequestContext context, Q request, @Nullable P response, @Nullable Throwable error) {
        Preconditions.checkNotNull((Object)context, (Object)"context");
        Preconditions.checkNotNull(request, (Object)"request");
        this.recordStats(context, request, response, error);
        this.spanEnd(context.span, response, error);
    }

    private void recordStats(HttpRequestContext context, Q request, @Nullable P response, @Nullable Throwable error) {
        double requestLatency = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - context.requestStartTime);
        String methodStr = this.extractor.getMethod(request);
        String routeStr = this.extractor.getRoute(request);
        int status = this.extractor.getStatusCode(response);
        TagContext startCtx = this.tagger.toBuilder(context.tagContext).put(HttpMeasureConstants.HTTP_SERVER_METHOD, TagValue.create(methodStr == null ? "" : methodStr)).put(HttpMeasureConstants.HTTP_SERVER_ROUTE, TagValue.create(routeStr == null ? "" : routeStr)).put(HttpMeasureConstants.HTTP_SERVER_STATUS, TagValue.create(status == 0 ? "error" : Integer.toString(status))).build();
        this.statsRecorder.newMeasureMap().put(HttpMeasureConstants.HTTP_SERVER_LATENCY, requestLatency).put(HttpMeasureConstants.HTTP_SERVER_RECEIVED_BYTES, context.receiveMessageSize.get()).put(HttpMeasureConstants.HTTP_SERVER_SENT_BYTES, context.sentMessageSize.get()).record(startCtx);
    }
}

