/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.UsedInsight;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IUsedInsightCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IUsedInsightCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.UsedInsightCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.UsedInsightCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.UsedInsightCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.UsedInsightRequestBuilder;

public class UsedInsightCollectionRequest
extends BaseCollectionRequest<UsedInsightCollectionResponse, IUsedInsightCollectionPage>
implements IUsedInsightCollectionRequest {
    public UsedInsightCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UsedInsightCollectionResponse.class, IUsedInsightCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IUsedInsightCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(UsedInsightCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUsedInsightCollectionPage get() throws ClientException {
        UsedInsightCollectionResponse response = (UsedInsightCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(UsedInsight newUsedInsight, ICallback<UsedInsight> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new UsedInsightRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newUsedInsight, callback);
    }

    @Override
    public UsedInsight post(UsedInsight newUsedInsight) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new UsedInsightRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newUsedInsight);
    }

    @Override
    public IUsedInsightCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IUsedInsightCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUsedInsightCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IUsedInsightCollectionPage buildFromResponse(UsedInsightCollectionResponse response) {
        UsedInsightCollectionRequestBuilder builder = response.nextLink != null ? new UsedInsightCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UsedInsightCollectionPage page = new UsedInsightCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

