/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.action;

import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.component.explorer.rightclick.viewinfor.UIViewInfoManager;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={ViewInfoActionListener.class})})
public class ViewInfoActionComponent
extends UIAbstractManagerComponent {
    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class ViewInfoActionListener
    extends UIWorkingAreaActionListener<ViewInfoActionComponent> {
        protected void processEvent(Event<ViewInfoActionComponent> event) throws Exception {
            ViewInfoActionComponent uicomp = (ViewInfoActionComponent)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((ViewInfoActionComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIPopupContainer objUIPopupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            Node selectedNode = null;
            if (nodePath != null && nodePath.length() != 0) {
                Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
                String wsName = null;
                if (!matcher.find()) {
                    throw new IllegalArgumentException("The ObjectId is invalid '" + nodePath + "'");
                }
                wsName = matcher.group(1);
                nodePath = matcher.group(2);
                Session session = uiExplorer.getSessionByWorkspace(wsName);
                UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
                try {
                    selectedNode = uiExplorer.getNodeByPath(nodePath, session);
                }
                catch (PathNotFoundException path) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
                    return;
                }
                catch (AccessDeniedException ace) {
                    uiApp.addMessage(new ApplicationMessage("UIDocumentInfo.msg.null-exception", null, 1));
                    return;
                }
                catch (Exception e) {
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                    return;
                }
            }
            if (selectedNode == null) {
                selectedNode = uiExplorer.getCurrentNode();
            }
            UIViewInfoManager uiViewInfoManager = (UIViewInfoManager)uiExplorer.createUIComponent(UIViewInfoManager.class, null, null);
            uiViewInfoManager.setSelectedNode(selectedNode);
            objUIPopupContainer.activate((UIComponent)uiViewInfoManager, 600, 360);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)objUIPopupContainer);
        }
    }
}

