/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.viewinfor;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.rightclick.viewinfor.UIViewInfoManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:templates/viewinfo/UIViewInfoContainer.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UIViewInfoContainer
extends UIContainer {
    private Map<String, String> inforMap = new LinkedHashMap<String, String>();
    private static final String NAME = "name";
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private static final String SIZE = "size";
    private static final String OWNER = "owner";
    private static final String LAST_MODIFIER = "lastModifier";
    private static final String CREATED = "created";
    private static final String LAST_MODIFIED = "lastModified";
    private static final String PUBLICATION_STATE = "publicationState";
    private static final String DC_TITLE = "dc:title";
    private static final String PUBLICATION_CURRENT_STATE = "publication:currentState";
    private static final String EXO_LAST_MODIFIED_DATE = "exo:lastModifiedDate";
    private boolean isFolder = false;

    public Map<String, String> getInforMap() {
        return this.inforMap;
    }

    public void setInforMap(Map<String, String> inforMap) {
        this.inforMap = inforMap;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public void readNodeInformation() throws Exception {
        Node contentNode;
        Node selectedNode = this.getSelectedNode();
        this.inforMap.put(NAME, selectedNode.getName());
        this.inforMap.put(TITLE, this.getTitle(selectedNode));
        this.inforMap.put(TYPE, this.getType(selectedNode));
        if (selectedNode.hasNode("jcr:content") && (contentNode = selectedNode.getNode("jcr:content")).hasProperty("jcr:data")) {
            double size = contentNode.getProperty("jcr:data").getLength();
            String fileSize = Utils.calculateFileSize((double)size);
            this.inforMap.put(SIZE, fileSize);
        }
        if (selectedNode.hasProperty("exo:owner")) {
            this.inforMap.put(OWNER, selectedNode.getProperty("exo:owner").getString());
        }
        if (selectedNode.hasProperty("exo:lastModifier")) {
            this.inforMap.put(LAST_MODIFIER, selectedNode.getProperty("exo:lastModifier").getString());
        }
        if (selectedNode.hasProperty("exo:dateCreated")) {
            this.inforMap.put(CREATED, selectedNode.getProperty("exo:dateCreated").getString());
        }
        if (selectedNode.hasProperty(EXO_LAST_MODIFIED_DATE)) {
            this.inforMap.put(LAST_MODIFIED, selectedNode.getProperty(EXO_LAST_MODIFIED_DATE).getString());
        }
        if (selectedNode.hasProperty(PUBLICATION_CURRENT_STATE)) {
            this.inforMap.put(PUBLICATION_STATE, selectedNode.getProperty(PUBLICATION_CURRENT_STATE).getString());
        }
    }

    private String getType(Node node) throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        NodeType nodeType = node.getPrimaryNodeType();
        String strNodeTypeName = nodeType.getName();
        String strType = "";
        this.isFolder = false;
        if (nodeType.isNodeType("nt:file")) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            Node contentNode = node.getNode("jcr:content");
            strType = contentNode.getProperty("jcr:mimeType").getString();
        } else if (templateService.isManagedNodeType(strNodeTypeName)) {
            strType = templateService.getTemplateLabel(strNodeTypeName);
        } else if (nodeType.isNodeType("nt:unstructured") || nodeType.isNodeType("nt:folder")) {
            this.isFolder = true;
        } else {
            strType = strNodeTypeName;
        }
        return strType;
    }

    private String getTitle(Node node) throws Exception {
        String title = null;
        if (node.hasNode("jcr:content")) {
            Node content = node.getNode("jcr:content");
            if (content.hasProperty(DC_TITLE)) {
                try {
                    title = content.getProperty(DC_TITLE).getValues()[0].getString();
                }
                catch (Exception ex) {
                    title = null;
                }
            }
        } else if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        }
        if (title == null || title != null && title.trim().length() == 0) {
            title = node.getName();
        }
        return Text.unescapeIllegalJcrChars((String)title);
    }

    public String getCloseAction() {
        return "Close";
    }

    private Node getSelectedNode() {
        UIViewInfoManager uiManager = (UIViewInfoManager)this.getParent();
        return uiManager.getSelectedNode();
    }

    public static class CloseActionListener
    extends EventListener<UIViewInfoContainer> {
        public void execute(Event<UIViewInfoContainer> event) throws Exception {
            ((UIJCRExplorer)((UIViewInfoContainer)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class)).cancelAction();
        }
    }
}

