/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.tika.mime.MimeTypeException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.ecms.xcmis.sp.StorageProviderImpl;
import org.exoplatform.ecms.xcmis.sp.index.Jcr2XcmisChangesListener;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;
import org.xcmis.search.SearchService;
import org.xcmis.search.SearchServiceException;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.spi.CmisRegistry;
import org.xcmis.spi.CmisRegistryFactory;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.RenditionManager;
import org.xcmis.spi.StorageProvider;

public class JcrCmisRegistry
extends CmisRegistry
implements Startable,
CmisRegistryFactory {
    private final Map<String, SearchService> wsSearchServices;
    protected String rootIndexDir;
    protected final InitParams initParams;
    private final RepositoryService repositoryService;

    public JcrCmisRegistry(RepositoryService repositoryService, InitParams initParams) {
        this.initParams = initParams;
        this.repositoryService = repositoryService;
        this.wsSearchServices = new HashMap<String, SearchService>();
    }

    public void addStorage(StorageProvider storageProvider) {
        super.addStorage(storageProvider);
        StorageProviderImpl sp = (StorageProviderImpl)storageProvider;
        sp.setSearchService(this.wsSearchServices.get(sp.getStorageConfiguration().getRepository() + '@' + sp.getStorageConfiguration().getWorkspace()));
    }

    public Map<String, StorageProvider> getStorageProviders() {
        return this.storageProviders;
    }

    public String[] getAffectedWorkspaceNames() throws RepositoryException {
        return this.repositoryService.getCurrentRepository().getWorkspaceNames();
    }

    private void addSearchService(String jcrRepositoryName, String jcrWorkspaceName, SearchService searchService) {
        if (searchService != null) {
            this.wsSearchServices.put(jcrRepositoryName + "@" + jcrWorkspaceName, searchService);
            for (Map.Entry spEntry : this.storageProviders.entrySet()) {
                StorageProviderImpl sp = (StorageProviderImpl)spEntry.getValue();
                if (!sp.getStorageConfiguration().getRepository().equals(jcrRepositoryName) || !sp.getStorageConfiguration().getWorkspace().equals(jcrWorkspaceName)) continue;
                sp.setSearchService(searchService);
            }
        }
    }

    public SearchService getSearchService(String jcrRepositoryName, String jcrWorkspaceName) {
        return this.wsSearchServices.get(jcrRepositoryName + "@" + jcrWorkspaceName);
    }

    public void start() {
        if (this.initParams != null) {
            this.rootIndexDir = this.getValueParameter("indexDir", null);
            Iterator vparams = this.initParams.getValuesParamIterator();
            while (vparams.hasNext()) {
                ValuesParam next = (ValuesParam)vparams.next();
                if (!next.getName().equalsIgnoreCase("renditionProviders")) continue;
                this.renditionProviders.addAll(next.getValues());
            }
        }
        RenditionManager manager = RenditionManager.getInstance();
        manager.addRenditionProviders(this.renditionProviders);
        JcrCmisRegistry.setFactory((CmisRegistryFactory)this);
        if (this.rootIndexDir != null) {
            try {
                IndexConfiguration indexConfiguration = new IndexConfiguration(this.rootIndexDir, Constants.ROOT_PARENT_UUID, "00exo0jcr0root0uuid0000000000000");
                String[] wsNames = this.getAffectedWorkspaceNames();
                String currentRepositoryName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
                for (String wsName : wsNames) {
                    WorkspaceContainerFacade wsContainer = this.repositoryService.getCurrentRepository().getWorkspaceContainer(wsName);
                    PersistentDataManager dm = (PersistentDataManager)wsContainer.getComponent(PersistentDataManager.class);
                    SessionProviderService sessionProviderService = (SessionProviderService)wsContainer.getComponent(SessionProviderService.class);
                    NamespaceAccessor namespaceAccessor = (NamespaceAccessor)wsContainer.getComponent(NamespaceAccessor.class);
                    DocumentReaderService documentReaderService = (DocumentReaderService)wsContainer.getComponent(DocumentReaderService.class);
                    Jcr2XcmisChangesListener changesListener = new Jcr2XcmisChangesListener(currentRepositoryName, wsName, dm, sessionProviderService, this.repositoryService.getCurrentRepository(), namespaceAccessor, documentReaderService);
                    changesListener.onRegistryStart(indexConfiguration);
                    dm.addItemPersistenceListener((ItemsPersistenceListener)changesListener);
                    this.addSearchService(currentRepositoryName, wsName, changesListener.getSearchService());
                }
            }
            catch (RepositoryException e) {
                throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (SearchServiceException e) {
                throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (MimeTypeException e) {
                throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void stop() {
        for (Map.Entry<String, SearchService> entry : this.wsSearchServices.entrySet()) {
            SearchService value = entry.getValue();
            if (value == null) continue;
            value.stop();
        }
    }

    protected String getValueParameter(String name, String defaultValue) {
        ValueParam valueParam;
        String value = null;
        if (this.initParams != null && (valueParam = this.initParams.getValueParam(name)) != null) {
            value = valueParam.getValue();
        }
        return value != null ? value : defaultValue;
    }

    public CmisRegistry getRegistry() {
        return (CmisRegistry)WCMCoreUtils.getService(CmisRegistry.class);
    }
}

