/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp.index;

import java.io.IOException;
import java.util.ArrayList;
import org.exoplatform.ecms.xcmis.sp.index.CmisSchema;
import org.exoplatform.ecms.xcmis.sp.index.MockContentEntry;
import org.xcmis.search.content.ContentEntry;
import org.xcmis.search.content.Property;
import org.xcmis.search.value.PropertyType;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.model.Property;

public class ContentEntryAdapter {
    public ContentEntry createEntry(ObjectData objectData) throws IOException {
        if (objectData != null) {
            switch (objectData.getBaseType()) {
                case DOCUMENT: {
                    return this.createFromDocument((DocumentData)objectData);
                }
                case FOLDER: {
                    return this.createFromFolder((FolderData)objectData);
                }
                case POLICY: {
                    return this.createFromPolicy((PolicyData)objectData);
                }
                case RELATIONSHIP: {
                    return this.createFromRelationship((RelationshipData)objectData);
                }
            }
            throw new UnsupportedOperationException(objectData.getBaseType().toString() + " is not supported for indexing");
        }
        return null;
    }

    private ContentEntry createFromRelationship(RelationshipData objectData) {
        MockContentEntry mockEntry = this.fillCommonInformation((ObjectData)objectData);
        mockEntry.parentIdentifiers.add("");
        return new ContentEntry(mockEntry.name, mockEntry.getTableNames(), mockEntry.identifier, mockEntry.getParentIdentifiers(), mockEntry.getProperties());
    }

    private ContentEntry createFromPolicy(PolicyData objectData) {
        MockContentEntry mockEntry = this.fillCommonInformation((ObjectData)objectData);
        mockEntry.parentIdentifiers.add("");
        return new ContentEntry(mockEntry.name, mockEntry.getTableNames(), mockEntry.identifier, mockEntry.getParentIdentifiers(), mockEntry.getProperties());
    }

    private MockContentEntry fillCommonInformation(ObjectData objectData) {
        MockContentEntry contentEntry = new MockContentEntry();
        contentEntry.tableNames.add(objectData.getTypeDefinition().getQueryName());
        contentEntry.identifier = objectData.getObjectId();
        contentEntry.name = objectData.getName();
        for (FolderData folder : objectData.getParents()) {
            contentEntry.parentIdentifiers.add(folder.getObjectId());
        }
        for (Property property : objectData.getProperties().values()) {
            if (property.getValues().size() <= 0) continue;
            contentEntry.properties.add(this.convertProperty(property));
        }
        return contentEntry;
    }

    private <G> org.xcmis.search.content.Property<G> convertProperty(Property<G> property) {
        ArrayList<Property.SimpleValue> value = new ArrayList<Property.SimpleValue>();
        for (Object contentValue : property.getValues()) {
            value.add(new Property.SimpleValue(contentValue));
        }
        return new org.xcmis.search.content.Property(CmisSchema.PROPERTY_TYPES_MAP.get(property.getType()), property.getQueryName(), value);
    }

    private ContentEntry createFromFolder(FolderData objectData) {
        MockContentEntry mockEntry = this.fillCommonInformation((ObjectData)objectData);
        return new ContentEntry(mockEntry.name, mockEntry.getTableNames(), mockEntry.identifier, mockEntry.getParentIdentifiers(), mockEntry.getProperties());
    }

    private ContentEntry createFromDocument(DocumentData objectData) throws IOException {
        MockContentEntry mockEntry = this.fillCommonInformation((ObjectData)objectData);
        ContentStream cs = objectData.getContentStream();
        if (cs != null) {
            ArrayList<Property.BinaryValue> vals = new ArrayList<Property.BinaryValue>(1);
            vals.add(new Property.BinaryValue(cs.getStream(), cs.getMediaType().getBaseType(), cs.getMediaType().getParameter("charset"), cs.length()));
            mockEntry.properties.add(new org.xcmis.search.content.Property(PropertyType.BINARY, "content", vals));
        }
        return new ContentEntry(mockEntry.name, mockEntry.getTableNames(), mockEntry.identifier, mockEntry.getParentIdentifiers(), mockEntry.getProperties());
    }
}

