/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.notification.plugin;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.wcm.notification.plugin.ShareFileToSpacePlugin;

@TemplateConfigs(templates={@TemplateConfig(pluginId="ShareFileToUserPlugin", template="war:/groovy/ecm/social-integration/plugin/notification/ShareDocumentToUser.gtmpl"), @TemplateConfig(pluginId="ShareFileToSpacePlugin", template="war:/groovy/ecm/social-integration/plugin/notification/ShareDocumentToSpace.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    private static final String SHARE_NOTIFICATION_VEW = "$UIShareDocuments.label.notification.read";
    private static final String SHARE_NOTIFICATION_MODIFY = "$UIShareDocuments.label.notification.modify";
    private AbstractTemplateBuilder shareFileToUserPlugin = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String permission = notification.getValueOwnerParameter("permission");
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getFrom(), true);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
            templateContext.put((Object)"DOCUMENT", (Object)notification.getValueOwnerParameter("documentName"));
            templateContext.put((Object)"PERMISSION", (Object)permission);
            templateContext.put((Object)"NOTIF_PERM", (Object)(permission.equals("read") ? MailTemplateProvider.SHARE_NOTIFICATION_VEW : MailTemplateProvider.SHARE_NOTIFICATION_MODIFY));
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            Identity receiver = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getTo(), true);
            templateContext.put((Object)"FIRSTNAME", (Object)notification.getValueOwnerParameter("firstName"));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)identity.getRemoteId()));
            templateContext.put((Object)"DOCUMENT_URL", (Object)notification.getValueOwnerParameter("documentUrl"));
            templateContext.put((Object)"MESSAGE", (Object)notification.getValueOwnerParameter("comment"));
            templateContext.put((Object)"TYPE", (Object)notification.getValueOwnerParameter("type"));
            templateContext.put((Object)"THUMBNAIL_URL", (Object)notification.getValueOwnerParameter("documentIcon"));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            Identity receiver = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", first.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            try {
                writer.append(this.buildDigestMsg(notifications, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }

        protected String buildDigestMsg(List<NotificationInfo> notifications, TemplateContext templateContext) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            HashMap<String, LinkedList<NotificationInfo>> map = new HashMap<String, LinkedList<NotificationInfo>>();
            for (NotificationInfo notif : notifications) {
                String nodeID = notif.getValueOwnerParameter("nodeId");
                LinkedList<NotificationInfo> tmp = (LinkedList<NotificationInfo>)map.get(nodeID);
                if (tmp == null) {
                    tmp = new LinkedList<NotificationInfo>();
                    map.put(nodeID, tmp);
                }
                tmp.add(notif);
            }
            StringBuilder sb = new StringBuilder();
            for (String nodeID : map.keySet()) {
                List notifs = (List)map.get(nodeID);
                NotificationInfo first = (NotificationInfo)notifs.get(0);
                String documentUrl = first.getValueOwnerParameter("documentUrl");
                String documentName = first.getValueOwnerParameter("documentName");
                Identity sender = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", first.getFrom(), true);
                templateContext.put((Object)"DOCUMENT", (Object)this.buildDocumentUrl(documentUrl, documentName));
                templateContext.put((Object)"USER", (Object)this.buildUserUrl(sender));
                templateContext.digestType(DigestTemplate.ElementType.DIGEST_ONE.getValue());
                sb.append("<li style=\"margin: 0 0 13px 14px; font-size: 13px; line-height: 18px; font-family: HelveticaNeue, Helvetica, Arial, sans-serif;\">");
                String digester = TemplateUtils.processDigest((TemplateContext)templateContext);
                sb.append(digester);
                sb.append("</div></li>");
            }
            return sb.toString();
        }

        protected String buildUserUrl(Identity identity) {
            StringBuilder sb = new StringBuilder();
            sb.append("<a target=\"_blank\" style=\"text-decoration: none; font-weight: bold; color: #2f5e92; font-family: 'HelveticaNeue Bold', Helvetica, Arial, sans-serif; font-size: 13px; line-height: 18px;\"");
            sb.append("href=\"" + LinkProviderUtils.getRedirectUrl((String)"user", (String)identity.getRemoteId()) + "\">");
            sb.append(identity.getProfile().getFullName());
            sb.append("</a>");
            return sb.toString();
        }

        protected String buildDocumentUrl(String docUrl, String docName) {
            return "<a target=\"_blank\" style=\"text-decoration: none; font-weight: bold; color: #2f5e92; font-family: 'HelveticaNeue Bold', Helvetica, Arial, sans-serif; font-size: 13px; line-height: 18px;\" href=\"" + docUrl + "\">" + docName + "</a>";
        }
    };
    private AbstractTemplateBuilder shareFileToSpacePlugin = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            String permission = notification.getValueOwnerParameter("permission");
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getFrom(), true);
            TemplateContext templateContext = new TemplateContext(notification.getKey().getId(), language);
            templateContext.put((Object)"USER", (Object)identity.getProfile().getFullName());
            templateContext.put((Object)"DOCUMENT", (Object)notification.getValueOwnerParameter("documentName"));
            templateContext.put((Object)"PERMISSION", (Object)notification.getValueOwnerParameter("permission"));
            templateContext.put((Object)"NOTIF_PERM", (Object)(permission.equals("read") ? MailTemplateProvider.SHARE_NOTIFICATION_VEW : MailTemplateProvider.SHARE_NOTIFICATION_MODIFY));
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            Identity receiver = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getTo(), true);
            templateContext.put((Object)"FIRSTNAME", (Object)ShareFileToSpacePlugin.capitalizeFirstLetter(notification.getTo()));
            templateContext.put((Object)"PROFILE_URL", (Object)LinkProviderUtils.getRedirectUrl((String)"user", (String)identity.getRemoteId()));
            templateContext.put((Object)"DOCUMENT_URL", (Object)notification.getValueOwnerParameter("documentUrl"));
            templateContext.put((Object)"MESSAGE", (Object)notification.getValueOwnerParameter("comment"));
            templateContext.put((Object)"SPACE", (Object)notification.getValueOwnerParameter("spaceName"));
            templateContext.put((Object)"SPACE_URL", (Object)notification.getValueOwnerParameter("spaceUrl"));
            templateContext.put((Object)"TYPE", (Object)notification.getValueOwnerParameter("type"));
            templateContext.put((Object)"REPLY_ACTION_URL", (Object)notification.getValueOwnerParameter("reply"));
            templateContext.put((Object)"VIEW_FULL_DISCUSSION_ACTION_URL", (Object)notification.getValueOwnerParameter("fullDiscussion"));
            templateContext.put((Object)"THUMBNAIL_URL", (Object)notification.getValueOwnerParameter("documentIcon"));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            List notifications = ctx.getNotificationInfos();
            NotificationInfo first = (NotificationInfo)notifications.get(0);
            String language = this.getLanguage(first);
            TemplateContext templateContext = new TemplateContext(first.getKey().getId(), language);
            Identity receiver = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", first.getTo(), true);
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            try {
                writer.append(this.buildDigestMsg(notifications, templateContext));
            }
            catch (IOException e) {
                ctx.setException((Throwable)e);
                return false;
            }
            return true;
        }

        protected String buildDigestMsg(List<NotificationInfo> notifications, TemplateContext templateContext) {
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            HashMap<String, LinkedList<NotificationInfo>> map = new HashMap<String, LinkedList<NotificationInfo>>();
            for (NotificationInfo notif : notifications) {
                String nodeID = notif.getValueOwnerParameter("nodeId");
                LinkedList<NotificationInfo> tmp = (LinkedList<NotificationInfo>)map.get(nodeID);
                if (tmp == null) {
                    tmp = new LinkedList<NotificationInfo>();
                    map.put(nodeID, tmp);
                }
                tmp.add(notif);
            }
            StringBuilder sb = new StringBuilder();
            for (String nodeID : map.keySet()) {
                List notifs = (List)map.get(nodeID);
                NotificationInfo first = (NotificationInfo)notifs.get(0);
                String documentUrl = first.getValueOwnerParameter("documentUrl");
                String documentName = first.getValueOwnerParameter("documentName");
                Identity sender = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", first.getFrom(), true);
                templateContext.put((Object)"DOCUMENT", (Object)this.buildDocumentUrl(documentUrl, documentName));
                templateContext.put((Object)"USER", (Object)this.buildUserUrl(sender));
                templateContext.digestType(DigestTemplate.ElementType.DIGEST_ONE.getValue());
                sb.append("<li style=\"margin: 0 0 13px 14px; font-size: 13px; line-height: 18px; font-family: HelveticaNeue, Helvetica, Arial, sans-serif;\">");
                String digester = TemplateUtils.processDigest((TemplateContext)templateContext);
                sb.append(digester);
                sb.append("</div></li>");
            }
            return sb.toString();
        }

        protected String buildUserUrl(Identity identity) {
            StringBuilder sb = new StringBuilder();
            sb.append("<a target=\"_blank\" style=\"text-decoration: none; font-weight: bold; color: #2f5e92; font-family: 'HelveticaNeue Bold', Helvetica, Arial, sans-serif; font-size: 13px; line-height: 18px;\"");
            sb.append("href=\"" + LinkProviderUtils.getRedirectUrl((String)"user", (String)identity.getRemoteId()) + "\">");
            sb.append(identity.getProfile().getFullName());
            sb.append("</a>");
            return sb.toString();
        }

        protected String buildDocumentUrl(String docUrl, String docName) {
            return "<a target=\"_blank\" style=\"text-decoration: none; font-weight: bold; color: #2f5e92; font-family: 'HelveticaNeue Bold', Helvetica, Arial, sans-serif; font-size: 13px; line-height: 18px;\" href=\"" + docUrl + "\">" + docName + "</a>";
        }
    };

    public MailTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"ShareFileToUserPlugin"), this.shareFileToUserPlugin);
        this.templateBuilders.put(PluginKey.key((String)"ShareFileToSpacePlugin"), this.shareFileToSpacePlugin);
    }
}

