/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Node;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.search.es.ElasticSearchFilter;
import org.exoplatform.commons.search.es.ElasticSearchFilterType;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.connector.FileSearchServiceConnector;

@Path(value="search/documents")
@Api(tags={"search/documents"}, value="search/documents", description="Managing search documents")
public class FileSearchRestService
implements ResourceContainer {
    private FileSearchServiceConnector fileSearchServiceConnector;
    private NodeHierarchyCreator nodeHierarchyCreator;
    private static final int DEFAULT_LIMIT = 20;

    public FileSearchRestService(FileSearchServiceConnector fileSearchServiceConnector, NodeHierarchyCreator nodeHierarchyCreator) {
        this.fileSearchServiceConnector = fileSearchServiceConnector;
        this.nodeHierarchyCreator = nodeHierarchyCreator;
    }

    @GET
    @Path(value="/recent")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets recent documents", httpMethod="GET", response=Response.class, notes="This returns recent documents")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response searchRecentDocuments(@ApiParam(value="Query string", required=false) @QueryParam(value="q") String query, @ApiParam(value="My work", required=false, defaultValue="false") @QueryParam(value="myWork") boolean myWork, @ApiParam(value="Sort field", required=false, defaultValue="date") @QueryParam(value="sort") String sortField, @ApiParam(value="Sort direction", required=false, defaultValue="desc") @QueryParam(value="direction") String sortDirection, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (limit <= 0) {
            limit = 20;
        }
        if (StringUtils.isBlank((CharSequence)sortField)) {
            sortField = "date";
        }
        if (StringUtils.isBlank((CharSequence)sortDirection)) {
            sortDirection = "desc";
        }
        ArrayList<ElasticSearchFilter> recentFilters = new ArrayList<ElasticSearchFilter>();
        if (myWork) {
            recentFilters.add(this.filterMyWorkingDocuments());
        }
        recentFilters.add(this.getFileTypesFilter(myWork));
        UserACL userACL = (UserACL)PortalContainer.getInstance().getComponentInstanceOfType(UserACL.class);
        if (!userACL.isSuperUser() && !userACL.isUserInGroup(userACL.getAdminGroups())) {
            recentFilters.add(this.getPathsFilter(Arrays.asList("/Groups/spaces", this.getUserPrivateNode().getPath())));
        }
        Collection recentDocuments = this.fileSearchServiceConnector.filteredSearch(null, query, recentFilters, null, 0, limit, sortField, sortDirection);
        return Response.ok((Object)recentDocuments).build();
    }

    @GET
    @Path(value="/recentSpaces")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets recent spaces documents", httpMethod="GET", response=Response.class, notes="This returns recent spaces documents")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response searchRecentSpacesDocuments(@ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (limit <= 0) {
            limit = 20;
        }
        ArrayList<ElasticSearchFilter> recentSpacesFilters = new ArrayList<ElasticSearchFilter>();
        recentSpacesFilters.add(this.getFileTypesFilter());
        recentSpacesFilters.add(this.getPathsFilter(Arrays.asList("/Groups/spaces")));
        Collection recentSpacesDocuments = this.fileSearchServiceConnector.filteredSearch(null, null, recentSpacesFilters, null, 0, limit, "date", "desc");
        return Response.ok((Object)recentSpacesDocuments).build();
    }

    private ElasticSearchFilter getFileTypesFilter(boolean myWork) {
        StringBuilder fileTypesFilter = new StringBuilder();
        fileTypesFilter.append("{\n \"term\" : { \"fileType\" : \"application/pdf\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.ms-excel\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"text/plain\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/rtf\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.openxmlformats-officedocument.presentationml.presentation\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.ms-powerpoint\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.oasis.opendocument.text\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/msword\" }\n }");
        fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"application/vnd.openxmlformats-officedocument.wordprocessingml.document\" }\n }");
        if (!myWork) {
            fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"image/jpeg\" }\n }");
            fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"image/png\" }\n }");
            fileTypesFilter.append(",{\n \"term\" : { \"fileType\" : \"image/gif\" }\n }");
        }
        return new ElasticSearchFilter(ElasticSearchFilterType.FILTER_CUSTOM, "fileType", fileTypesFilter.toString());
    }

    private ElasticSearchFilter getFileTypesFilter() {
        return this.getFileTypesFilter(false);
    }

    private ElasticSearchFilter getPathsFilter(List<String> paths) {
        StringBuilder pathsFilter = new StringBuilder();
        int count = 0;
        for (String path : paths) {
            pathsFilter.append("{\n \"regexp\" : { \"path\" : \"" + path + ".*\" }\n }");
            if (++count >= paths.size()) continue;
            pathsFilter.append(",");
        }
        return new ElasticSearchFilter(ElasticSearchFilterType.FILTER_CUSTOM, "path", pathsFilter.toString());
    }

    private ElasticSearchFilter filterMyWorkingDocuments() {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        StringBuilder recentFilter = new StringBuilder();
        recentFilter.append("{\n \"term\" : { \"author\" : \"" + userId + "\" }\n }");
        recentFilter.append(",{\n \"term\" : { \"lastModifier\" : \"" + userId + "\" }\n }");
        return new ElasticSearchFilter(ElasticSearchFilterType.FILTER_CUSTOM, "", recentFilter.toString());
    }

    private Node getUserPrivateNode() throws Exception {
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node userNode = this.nodeHierarchyCreator.getUserNode(sessionProvider, userId);
        return userNode.getNode("Private");
    }
}

