/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.core;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.core.UIPermissionFormBase;
import org.exoplatform.ecm.webui.core.UIPermissionInfoGrid;
import org.exoplatform.ecm.webui.core.UIPermissionManagerBase;
import org.exoplatform.ecm.webui.core.bean.PermissionBean;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public abstract class UIPermissionInfoBase
extends UIContainer {
    protected static final String FIELD_NAME = "fieldName";
    protected static final String FIELD_VALUE = "fieldValue";
    protected static final String EDIT_ACTION = "Edit";
    private static final String PERMISSION_ADD_NODE_ACTION = "addNode";
    public static String[] PERMISSION_BEAN_FIELD = new String[]{"usersOrGroups", "read", "addNode", "remove"};
    private static String[] PERMISSION_ACTION = new String[]{"Delete"};
    private int sizeOfListPermission = 0;

    public UIPermissionInfoBase() throws Exception {
        UIGrid uiGrid = (UIGrid)this.createUIComponent(UIPermissionInfoGrid.class, null, "PermissionInfo");
        this.addChild((UIComponent)uiGrid);
        uiGrid.getUIPageIterator().setId("PermissionInfoIterator");
        uiGrid.configure("usersOrGroups", PERMISSION_BEAN_FIELD, PERMISSION_ACTION);
    }

    public abstract Node getCurrentNode() throws Exception;

    public int getSizeOfListPermission() {
        return this.sizeOfListPermission;
    }

    public void setSizeOfListPermission(int sizeOfListPermission) {
        this.sizeOfListPermission = sizeOfListPermission;
    }

    public void updateGrid(int currentPage) throws Exception {
        ArrayList<PermissionBean> permBeans = new ArrayList<PermissionBean>();
        ExtendedNode node = (ExtendedNode)this.getCurrentNode();
        Map<String, List<String>> permsMap = this.getPermissionsMap(node);
        Set<String> keys = permsMap.keySet();
        Iterator<String> keysIter = keys.iterator();
        int iSystemOwner = 0;
        String owner = IdentityConstants.SYSTEM;
        if (this.getExoOwner((Node)node) != null) {
            owner = this.getExoOwner((Node)node);
        }
        if (owner.equals(IdentityConstants.SYSTEM)) {
            iSystemOwner = -1;
        }
        PermissionBean permOwnerBean = new PermissionBean();
        if (!permsMap.containsKey(owner)) {
            permOwnerBean.setUsersOrGroups(owner);
            permOwnerBean.setRead(true);
            permOwnerBean.setAddNode(true);
            permOwnerBean.setRemove(true);
            permBeans.add(permOwnerBean);
        }
        while (keysIter.hasNext()) {
            String userOrGroup = keysIter.next();
            PermissionBean permBean = new PermissionBean();
            permBean.setUsersOrGroups(userOrGroup);
            if (owner.equals(userOrGroup)) {
                permBean.setRead(true);
                permBean.setAddNode(true);
                permBean.setRemove(true);
            } else {
                List<String> permissions = permsMap.get(userOrGroup);
                for (String perm : permissions) {
                    if ("read".equals(perm)) {
                        permBean.setRead(true);
                        continue;
                    }
                    if ("add_node".equals(perm)) {
                        permBean.setAddNode(true);
                        continue;
                    }
                    if (!"remove".equals(perm)) continue;
                    permBean.setRemove(true);
                }
            }
            permBeans.add(permBean);
            this.sizeOfListPermission = permBeans.size() + iSystemOwner;
        }
        UIGrid uiGrid = (UIGrid)this.findFirstComponentOfType(UIGrid.class);
        Collections.sort(permBeans, new PermissionBeanComparator());
        ListAccessImpl permList = new ListAccessImpl(PermissionBean.class, permBeans);
        LazyPageList dataPageList = new LazyPageList((ListAccess)permList, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)dataPageList);
        if (currentPage > uiGrid.getUIPageIterator().getAvailablePage()) {
            uiGrid.getUIPageIterator().setCurrentPage(uiGrid.getUIPageIterator().getAvailablePage());
        } else {
            uiGrid.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    protected String getExoOwner(Node node) throws Exception {
        return org.exoplatform.ecm.webui.utils.Utils.getNodeOwner(node);
    }

    private Map<String, List<String>> getPermissionsMap(ExtendedNode node) throws RepositoryException {
        HashMap<String, List<String>> permsMap = new HashMap<String, List<String>>();
        for (AccessControlEntry accessControlEntry : node.getACL().getPermissionEntries()) {
            String currentIdentity = accessControlEntry.getIdentity();
            String currentPermission = accessControlEntry.getPermission();
            ArrayList<String> currentPermissionsList = (ArrayList<String>)permsMap.get(currentIdentity);
            if (!permsMap.containsKey(currentIdentity)) {
                permsMap.put(currentIdentity, null);
            }
            if (currentPermissionsList == null) {
                currentPermissionsList = new ArrayList<String>();
            }
            if (!currentPermissionsList.contains(currentPermission)) {
                currentPermissionsList.add(currentPermission);
            }
            permsMap.put(currentIdentity, currentPermissionsList);
        }
        return permsMap;
    }

    public List<PermissionBean> getPermBeans() {
        return new ArrayList<PermissionBean>();
    }

    public class PermissionBeanComparator
    implements Comparator<PermissionBean> {
        @Override
        public int compare(PermissionBean o1, PermissionBean o2) throws ClassCastException {
            try {
                String name1 = o1.getUsersOrGroups();
                String name2 = o2.getUsersOrGroups();
                return name1.compareToIgnoreCase(name2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    public static class EditActionListener
    extends EventListener<UIPermissionInfoBase> {
        public void execute(Event<UIPermissionInfoBase> event) throws Exception {
            UIPermissionInfoBase uiPermissionInfo = (UIPermissionInfoBase)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiPermissionInfo.getAncestorOfType(UIApplication.class);
            WebuiRequestContext requestContext = event.getRequestContext();
            ExtendedNode node = (ExtendedNode)uiPermissionInfo.getCurrentNode();
            String userOrGroupId = requestContext.getRequestParameter("objectId");
            String selectedPermission = requestContext.getRequestParameter(UIPermissionInfoBase.FIELD_NAME);
            String selectedPermissionValue = requestContext.getRequestParameter(UIPermissionInfoBase.FIELD_VALUE);
            if (node == null) {
                List<PermissionBean> perBeans = uiPermissionInfo.getPermBeans();
                for (PermissionBean perm : perBeans) {
                    if (!perm.getUsersOrGroups().equals(userOrGroupId)) continue;
                    if ("read".equals(selectedPermission) && !perm.isAddNode() && !perm.isRemove()) {
                        if (Boolean.FALSE.toString().equals(selectedPermissionValue)) {
                            uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.checkbox-require", null, 1));
                            return;
                        }
                        perm.setRead("true".equals(selectedPermissionValue));
                        continue;
                    }
                    if (UIPermissionInfoBase.PERMISSION_ADD_NODE_ACTION.equals(selectedPermission) || "set_property".equals(selectedPermission)) {
                        perm.setAddNode("true".equals(selectedPermissionValue));
                        if (!perm.isAddNode()) continue;
                        perm.setRead(true);
                        continue;
                    }
                    if (!"remove".equals(selectedPermission)) continue;
                    perm.setRemove("true".equals(selectedPermissionValue));
                    if (!perm.isRemove()) continue;
                    perm.setRead(true);
                }
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPermissionInfo);
                return;
            }
            if (!node.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                return;
            }
            Map permsMap = uiPermissionInfo.getPermissionsMap(node);
            List identityPermissions = (List)permsMap.get(userOrGroupId);
            Utils.addLockToken((Node)node);
            try {
                if (PermissionUtil.canChangePermission((Node)node)) {
                    if (node.canAddMixin("exo:privilegeable")) {
                        node.addMixin("exo:privilegeable");
                        node.setPermission(org.exoplatform.ecm.webui.utils.Utils.getNodeOwner((Node)node), PermissionType.ALL);
                    }
                    if (Boolean.valueOf(selectedPermissionValue).booleanValue()) {
                        if (UIPermissionInfoBase.PERMISSION_ADD_NODE_ACTION.equals(selectedPermission)) {
                            identityPermissions.add("set_property");
                            identityPermissions.add("add_node");
                        } else {
                            identityPermissions.add(selectedPermission);
                        }
                    } else {
                        if (identityPermissions.size() == 1) {
                            uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.checkbox-require", null, 1));
                            return;
                        }
                        if (UIPermissionInfoBase.PERMISSION_ADD_NODE_ACTION.equals(selectedPermission)) {
                            identityPermissions.remove("set_property");
                            identityPermissions.remove("add_node");
                        } else if ("remove".equals(selectedPermission)) {
                            identityPermissions.remove(selectedPermission);
                        }
                    }
                    node.setPermission(userOrGroupId, identityPermissions.toArray(new String[identityPermissions.size()]));
                }
                UIPermissionFormBase uiPermissionForm = (UIPermissionFormBase)((UIPermissionManagerBase)uiPermissionInfo.getAncestorOfType(UIPermissionManagerBase.class)).getChild(UIPermissionFormBase.class);
                uiPermissionForm.updateSymlinks((Node)node);
                node.getSession().save();
                uiPermissionInfo.updateGrid(((UIGrid)uiPermissionInfo.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage());
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPermissionInfo);
            }
            catch (AccessControlException | AccessDeniedException e) {
                uiApp.addMessage(new ApplicationMessage("UIPermissionForm.msg.access-denied", null, 1));
            }
        }
    }
}

