/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.rightclick.manager.PasteManageComponent;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.clipboard.jcr.model.ClipboardCommand;
import org.exoplatform.services.cms.documents.AutoVersionService;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.reader.ContentReader;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(template="app:/groovy/webui/component/explorer/versions/UIDocumentAutoVersionForm.gtmpl", lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={KeepBothActionListener.class}), @EventConfig(listeners={CreateNewVersionActionListener.class}), @EventConfig(listeners={ReplaceActionListener.class}), @EventConfig(listeners={OnChangeActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIDocumentAutoVersionForm
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UIDocumentAutoVersionForm.class.getName());
    public static final String KEEP_BOTH = "KeepBoth";
    public static final String CREATE_VERSION = "CreateNewVersion";
    public static final String REPLACE = "Replace";
    public static final String CREATE_OR_REPLACE = "CreateVersionOrReplace";
    public static final String CANCEL = "Cancel";
    public static final String REMEMBER_VERSIONED_COMPONENT = "UIDocumentAutoVersionForm.UIChkRememberVersioned";
    public static final String REMEMBER_NONVERSIONED_COMPONENT = "UIDocumentAutoVersionForm.UIChkRememberNonVersioned";
    private boolean isVersioned;
    private boolean isSingleProcess = false;
    private String sourcePath;
    private String destPath;
    private String sourceWorkspace;
    private String destWorkspace;
    private String message_;
    private String[] args_ = new String[0];
    private static String[] actions = new String[]{"KeepBoth", "CreateNewVersion", "Replace", "CreateVersionOrReplace", "Cancel"};
    private static Set<ClipboardCommand> clipboardCommands = null;
    private ClipboardCommand currentClipboard = null;
    private static AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);

    public void activate() {
    }

    public void deActivate() {
    }

    public UIDocumentAutoVersionForm() {
        UICheckBoxInput chkRememberVersioned = new UICheckBoxInput(REMEMBER_VERSIONED_COMPONENT, "", Boolean.valueOf(false));
        UICheckBoxInput chkRememberNonVersioned = new UICheckBoxInput(REMEMBER_NONVERSIONED_COMPONENT, "", Boolean.valueOf(false));
        chkRememberVersioned.setOnChange("OnChange");
        chkRememberVersioned.setChecked(true);
        chkRememberNonVersioned.setChecked(true);
        chkRememberVersioned.setRendered(false);
        chkRememberNonVersioned.setRendered(false);
        this.addChild((UIComponent)chkRememberVersioned);
        this.addChild((UIComponent)chkRememberNonVersioned);
    }

    public void init(Node currentNode) throws Exception {
        UICheckBoxInput chkRemVersion = (UICheckBoxInput)this.findComponentById(REMEMBER_VERSIONED_COMPONENT);
        UICheckBoxInput chkRemNonVersioned = (UICheckBoxInput)this.findComponentById(REMEMBER_NONVERSIONED_COMPONENT);
        if (currentNode.isNodeType("mix:versionable")) {
            this.setActions(new String[]{KEEP_BOTH, CREATE_VERSION, CANCEL});
            chkRemVersion.setRendered(true);
            chkRemNonVersioned.setRendered(false);
        } else {
            this.setActions(new String[]{KEEP_BOTH, REPLACE, CANCEL});
            chkRemVersion.setRendered(false);
            chkRemNonVersioned.setRendered(true);
        }
        if (this.isSingleProcess) {
            chkRemVersion.setRendered(false);
            chkRemNonVersioned.setRendered(false);
        }
    }

    public String[] getActions() {
        return actions;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    public String getSourceWorkspace() {
        return this.sourceWorkspace;
    }

    public void setSourceWorkspace(String sourceWorkspace) {
        this.sourceWorkspace = sourceWorkspace;
    }

    public String getDestWorkspace() {
        return this.destWorkspace;
    }

    public void setDestWorkspace(String destWorkspace) {
        this.destWorkspace = destWorkspace;
    }

    public void setMessage(String message) {
        this.message_ = message;
    }

    public String getMessage() {
        return this.message_;
    }

    public void setArguments(String[] args) {
        this.args_ = args;
    }

    public String[] getArguments() {
        return this.args_;
    }

    public boolean isVersioned() {
        return this.isVersioned;
    }

    public void setVersioned(boolean isVersioned) {
        this.isVersioned = isVersioned;
    }

    public void setActions(String[] actions) {
        UIDocumentAutoVersionForm.actions = actions;
    }

    public void setSingleProcess(boolean isSingleProcess) {
        this.isSingleProcess = isSingleProcess;
    }

    public static void copyNode(Session session, String srcWorkspaceName, String srcPath, String destPath, UIApplication uiApp, UIJCRExplorer uiExplorer, Event<?> event, String type) throws Exception {
        block18: {
            Workspace workspace = session.getWorkspace();
            if (workspace.getName().equals(srcWorkspaceName)) {
                try {
                    workspace.copy(srcPath, destPath);
                    Node destNode = (Node)session.getItem(destPath);
                    Utils.removeReferences((Node)destNode);
                }
                catch (ConstraintViolationException ce) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.current-node-not-allow-paste", null, 1));
                    uiExplorer.updateAjax(event);
                    return;
                }
                catch (VersionException ve) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.copied-node-in-versioning", null, 1));
                    uiExplorer.updateAjax(event);
                    return;
                }
                catch (ItemExistsException iee) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.paste-node-same-name", null, 1));
                    uiExplorer.updateAjax(event);
                    return;
                }
                catch (LoginException e) {
                    if ("cut".equals(type)) {
                        uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-login-node", null, 1));
                        uiExplorer.updateAjax(event);
                        return;
                    }
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-paste-nodetype", null, 1));
                    uiExplorer.updateAjax(event);
                    return;
                }
                catch (AccessDeniedException ace) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.access-denied", null, 1));
                    uiExplorer.updateAjax(event);
                    return;
                }
                catch (LockException locke) {
                    Object[] arg = new Object[]{srcPath};
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.paste-lock-exception", arg, 1));
                }
                catch (Exception e) {
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                    uiExplorer.updateAjax(event);
                    return;
                }
            } else {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Copy to another workspace");
                    }
                    workspace.copy(srcWorkspaceName, srcPath, destPath);
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"an unexpected error occurs while pasting the node", (Throwable)e);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Copy to other workspace by clone");
                    }
                    try {
                        workspace.clone(srcWorkspaceName, srcPath, destPath, false);
                    }
                    catch (Exception f) {
                        if (!LOG.isErrorEnabled()) break block18;
                        LOG.error((Object)"an unexpected error occurs while pasting the node", (Throwable)f);
                    }
                }
            }
        }
    }

    public Set<ClipboardCommand> getClipboardCommands() {
        return clipboardCommands;
    }

    public void setClipboardCommands(Set<ClipboardCommand> clipboardCommands) {
        UIDocumentAutoVersionForm.clipboardCommands = clipboardCommands;
    }

    public ClipboardCommand getCurrentClipboard() {
        return this.currentClipboard;
    }

    public void setCurrentClipboard(ClipboardCommand currentClipboard) {
        this.currentClipboard = currentClipboard;
    }

    public static void closePopup(UIDocumentAutoVersionForm autoVersionComponent, UIJCRExplorer uijcrExplorer, Event<?> event) throws Exception {
        UIPopupWindow popupAction = (UIPopupWindow)uijcrExplorer.findFirstComponentOfType(UIPopupWindow.class);
        UICheckBoxInput chkRememberVersioned = (UICheckBoxInput)autoVersionComponent.findComponentById(REMEMBER_VERSIONED_COMPONENT);
        UICheckBoxInput chkRememberNonVersioned = (UICheckBoxInput)autoVersionComponent.findComponentById(REMEMBER_NONVERSIONED_COMPONENT);
        chkRememberVersioned.setChecked(false);
        chkRememberNonVersioned.setChecked(false);
        PasteManageComponent.setVersionedRemember(null);
        PasteManageComponent.setNonVersionedRemember(null);
        autoVersionComponent.setCurrentClipboard(null);
        popupAction.setShow(false);
        popupAction.setRendered(false);
        uijcrExplorer.updateAjax(event);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public static class OnChangeActionListener
    extends EventListener<UIDocumentAutoVersionForm> {
        public void execute(Event<UIDocumentAutoVersionForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)event.getSource());
        }
    }

    public static class CancelActionListener
    extends EventListener<UIDocumentAutoVersionForm> {
        public void execute(Event<UIDocumentAutoVersionForm> event) throws Exception {
            Matcher matcher;
            UIDocumentAutoVersionForm autoVersionComponent = (UIDocumentAutoVersionForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)autoVersionComponent.getAncestorOfType(UIJCRExplorer.class);
            UICheckBoxInput chkRemVersion = (UICheckBoxInput)autoVersionComponent.findComponentById(UIDocumentAutoVersionForm.REMEMBER_VERSIONED_COMPONENT);
            UICheckBoxInput chkRemNonVersioned = (UICheckBoxInput)autoVersionComponent.findComponentById(UIDocumentAutoVersionForm.REMEMBER_NONVERSIONED_COMPONENT);
            boolean chkRem = chkRemVersion.isChecked() && chkRemVersion.isRendered();
            boolean chkRemNon = chkRemNonVersioned.isChecked() && chkRemNonVersioned.isRendered();
            Session destSession = uiExplorer.getSessionByWorkspace(autoVersionComponent.getDestWorkspace());
            Session srcSession = uiExplorer.getSessionByWorkspace(autoVersionComponent.getSourceWorkspace());
            Node sourceNode = uiExplorer.getNodeByPath(autoVersionComponent.getSourcePath(), srcSession);
            String destPath = autoVersionComponent.getDestPath();
            if (autoVersionComponent.isSingleProcess) {
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uiExplorer, event);
            }
            if (destPath != null && (matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(destPath)).find()) {
                destPath = matcher.group(2);
            }
            if (!"/".equals(destPath)) {
                destPath = destPath.concat("/");
            }
            destPath = destPath.concat(sourceNode.getName());
            Node destNode = (Node)destSession.getItem(destPath);
            HashMap<String, Boolean> remember = new HashMap<String, Boolean>();
            if (destNode.isNodeType("mix:versionable") && chkRem) {
                remember.put(UIDocumentAutoVersionForm.CANCEL, true);
                PasteManageComponent.setVersionedRemember(remember);
            } else if (!destNode.isNodeType("mix:versionable") && chkRemNon) {
                remember.put(UIDocumentAutoVersionForm.CANCEL, true);
                PasteManageComponent.setNonVersionedRemember(remember);
            }
            Set<ClipboardCommand> _clipboardCommands = autoVersionComponent.getClipboardCommands();
            if (!autoVersionComponent.isSingleProcess && _clipboardCommands != null && _clipboardCommands.size() > 0) {
                _clipboardCommands.remove(autoVersionComponent.getCurrentClipboard());
                if (_clipboardCommands.isEmpty()) {
                    UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uiExplorer, event);
                    return;
                }
                PasteManageComponent.processPasteMultiple(destNode.getParent(), event, uiExplorer, _clipboardCommands, UIDocumentAutoVersionForm.CANCEL);
            } else {
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uiExplorer, event);
            }
            if (chkRem && chkRemNon) {
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uiExplorer, event);
            }
        }
    }

    public static class ReplaceActionListener
    extends EventListener<UIDocumentAutoVersionForm> {
        public void execute(Event<UIDocumentAutoVersionForm> event) throws Exception {
            Matcher matcher;
            UIDocumentAutoVersionForm autoVersionComponent = (UIDocumentAutoVersionForm)((Object)event.getSource());
            UIJCRExplorer uijcrExplorer = (UIJCRExplorer)autoVersionComponent.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uijcrExplorer.getAncestorOfType(UIApplication.class);
            UICheckBoxInput chkRemVersion = (UICheckBoxInput)autoVersionComponent.findComponentById(UIDocumentAutoVersionForm.REMEMBER_VERSIONED_COMPONENT);
            UICheckBoxInput chkRemNonVersioned = (UICheckBoxInput)autoVersionComponent.findComponentById(UIDocumentAutoVersionForm.REMEMBER_NONVERSIONED_COMPONENT);
            boolean chkRem = chkRemVersion.isChecked() && chkRemVersion.isRendered();
            boolean chkRemNon = chkRemNonVersioned.isChecked() && chkRemNonVersioned.isRendered();
            Session destSession = uijcrExplorer.getSessionByWorkspace(autoVersionComponent.getDestWorkspace());
            Session srcSession = uijcrExplorer.getSessionByWorkspace(autoVersionComponent.getSourceWorkspace());
            Node sourceNode = uijcrExplorer.getNodeByPath(autoVersionComponent.getSourcePath(), srcSession);
            String destPath = autoVersionComponent.getDestPath();
            Set<ClipboardCommand> _clipboardCommands = autoVersionComponent.getClipboardCommands();
            ClipboardCommand currentCliboard = autoVersionComponent.getCurrentClipboard();
            if (destPath != null && (matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(destPath)).find()) {
                destPath = matcher.group(2);
            }
            Node _destNode = (Node)destSession.getItem(destPath);
            if (destPath.equals(sourceNode.getParent().getPath()) && autoVersionComponent.isSingleProcess) {
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uijcrExplorer, event);
                return;
            }
            Node destNode = _destNode.getNode(sourceNode.getName());
            HashMap<String, Boolean> remember = new HashMap<String, Boolean>();
            if (destNode.isNodeType("mix:versionable") && chkRem) {
                remember.put("replace", true);
                PasteManageComponent.setVersionedRemember(remember);
            } else if (!destNode.isNodeType("mix:versionable") && chkRemNon) {
                remember.put("replace", true);
                PasteManageComponent.setNonVersionedRemember(remember);
            }
            TrashService trashService = (TrashService)WCMCoreUtils.getService(TrashService.class);
            String trashID = null;
            destPath = destNode.getPath();
            if ("cut".equals(currentCliboard.getType()) && _destNode.hasNode(sourceNode.getName())) {
                if (_clipboardCommands != null && _clipboardCommands.size() > 0) {
                    if (!StringUtils.equals((String)destNode.getPath(), (String)sourceNode.getPath())) {
                        trashID = trashService.moveToTrash(destNode, WCMCoreUtils.getUserSessionProvider());
                        try {
                            PasteManageComponent.pasteByCut(autoVersionComponent.getCurrentClipboard(), uijcrExplorer, destSession, autoVersionComponent.getCurrentClipboard().getWorkspace(), sourceNode.getPath(), destPath, (ActionServiceContainer)WCMCoreUtils.getService(ActionServiceContainer.class), false, false, false);
                        }
                        catch (Exception ex) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)"Cannot cut files while replace", (Throwable)ex);
                            }
                            trashService.restoreFromTrash(trashID, WCMCoreUtils.getUserSessionProvider());
                        }
                        Node deletedNode = trashService.getNodeByTrashId(trashID);
                        deletedNode.remove();
                        deletedNode.getSession().save();
                    }
                    _clipboardCommands.remove(currentCliboard);
                    PasteManageComponent.processPasteMultiple(_destNode, event, uijcrExplorer, _clipboardCommands, UIDocumentAutoVersionForm.REPLACE);
                } else {
                    UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uijcrExplorer, event);
                }
                return;
            }
            Node destDriectory = destNode.getParent();
            if (autoVersionComponent.isSingleProcess) {
                trashID = trashService.moveToTrash(destNode, WCMCoreUtils.getUserSessionProvider());
                try {
                    UIDocumentAutoVersionForm.copyNode(destSession, autoVersionComponent.getSourceWorkspace(), autoVersionComponent.getSourcePath(), destPath, uiApp, uijcrExplorer, event, "copy");
                }
                catch (Exception ex) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"Cannot copy files while replace", (Throwable)ex);
                    }
                    trashService.restoreFromTrash(trashID, WCMCoreUtils.getUserSessionProvider());
                }
                Node deletedNode = trashService.getNodeByTrashId(trashID);
                deletedNode.remove();
                deletedNode.getSession().save();
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uijcrExplorer, event);
                return;
            }
            if (_clipboardCommands != null && _clipboardCommands.size() > 0) {
                _clipboardCommands.remove(autoVersionComponent.getCurrentClipboard());
                if (!StringUtils.equals((String)destPath, (String)autoVersionComponent.getSourcePath())) {
                    trashID = trashService.moveToTrash(destNode, WCMCoreUtils.getUserSessionProvider());
                    try {
                        UIDocumentAutoVersionForm.copyNode(destSession, autoVersionComponent.getSourceWorkspace(), autoVersionComponent.getSourcePath(), destPath, uiApp, uijcrExplorer, event, "copy");
                    }
                    catch (Exception ex) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)"Cannot copy files while replace", (Throwable)ex);
                        }
                        trashService.restoreFromTrash(trashID, WCMCoreUtils.getUserSessionProvider());
                    }
                    Node deletedNode = trashService.getNodeByTrashId(trashID);
                    deletedNode.remove();
                    deletedNode.getSession().save();
                    destSession.save();
                }
                PasteManageComponent.processPasteMultiple(destDriectory, event, uijcrExplorer, _clipboardCommands, UIDocumentAutoVersionForm.REPLACE);
            } else {
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uijcrExplorer, event);
            }
            if (chkRem && chkRemNon) {
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uijcrExplorer, event);
            }
        }
    }

    public static class CreateNewVersionActionListener
    extends EventListener<UIDocumentAutoVersionForm> {
        public void execute(Event<UIDocumentAutoVersionForm> event) throws Exception {
            Node destNode;
            Node sourceNode;
            Session destSession;
            boolean chkRemNon;
            boolean chkRem;
            UIJCRExplorer uijcrExplorer;
            UIDocumentAutoVersionForm autoVersionComponent;
            block20: {
                block19: {
                    Matcher matcher;
                    autoVersionComponent = (UIDocumentAutoVersionForm)((Object)event.getSource());
                    uijcrExplorer = (UIJCRExplorer)autoVersionComponent.getAncestorOfType(UIJCRExplorer.class);
                    UICheckBoxInput chkRemVersion = (UICheckBoxInput)autoVersionComponent.findComponentById(UIDocumentAutoVersionForm.REMEMBER_VERSIONED_COMPONENT);
                    UICheckBoxInput chkRemNonVersioned = (UICheckBoxInput)autoVersionComponent.findComponentById(UIDocumentAutoVersionForm.REMEMBER_NONVERSIONED_COMPONENT);
                    chkRem = chkRemVersion.isChecked() && chkRemVersion.isRendered();
                    chkRemNon = chkRemNonVersioned.isChecked() && chkRemNonVersioned.isRendered();
                    destSession = uijcrExplorer.getSessionByWorkspace(autoVersionComponent.getDestWorkspace());
                    Session srcSession = uijcrExplorer.getSessionByWorkspace(autoVersionComponent.getSourceWorkspace());
                    sourceNode = uijcrExplorer.getNodeByPath(autoVersionComponent.getSourcePath(), srcSession);
                    String destPath = autoVersionComponent.getDestPath();
                    if (destPath != null && (matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(destPath)).find()) {
                        destPath = matcher.group(2);
                    }
                    if (!"/".equals(destPath)) {
                        destPath = destPath.concat("/");
                    }
                    destPath = destPath.concat(sourceNode.getName());
                    destNode = (Node)destSession.getItem(destPath);
                    if (autoVersionComponent.isSingleProcess) break block19;
                    if (clipboardCommands.size() != 1) break block20;
                }
                if ("cut".equals(autoVersionComponent.getCurrentClipboard().getType())) {
                    PasteManageComponent.pasteByCut(autoVersionComponent.getCurrentClipboard(), uijcrExplorer, destSession, autoVersionComponent.getCurrentClipboard().getWorkspace(), sourceNode.getPath(), destNode.getParent().getPath(), (ActionServiceContainer)WCMCoreUtils.getService(ActionServiceContainer.class), false, false, true);
                } else {
                    autoVersionService.autoVersion(destNode, sourceNode);
                }
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uijcrExplorer, event);
                String msg = event.getRequestContext().getApplicationResourceBundle().getString("DocumentAuto.message");
                msg = msg.replace("{0}", ContentReader.simpleEscapeHtml((String)("<span style='font-weight:bold;'>" + destNode.getName() + "</span>")));
                event.getRequestContext().getJavascriptManager().require("SHARED/wcm-utils", "wcm_utils").addScripts("eXo.ecm.WCMUtils.showNotice(\" " + msg + "\", 'true'); ");
                return;
            }
            HashMap<String, Boolean> remember = new HashMap<String, Boolean>();
            if (destNode.isNodeType("mix:versionable") && chkRem) {
                remember.put("createVersion", true);
                PasteManageComponent.setVersionedRemember(remember);
            } else if (destNode.isNodeType("mix:versionable") && chkRemNon) {
                remember.put("createVersion", true);
                PasteManageComponent.setNonVersionedRemember(remember);
            }
            Set<ClipboardCommand> _clipboardCommands = autoVersionComponent.getClipboardCommands();
            if (!autoVersionComponent.isSingleProcess && _clipboardCommands != null && _clipboardCommands.size() > 0) {
                if ("copy".equals(autoVersionComponent.getCurrentClipboard().getType())) {
                    _clipboardCommands.remove(autoVersionComponent.getCurrentClipboard());
                    AutoVersionService autoVersionService = (AutoVersionService)WCMCoreUtils.getService(AutoVersionService.class);
                    autoVersionService.autoVersion(destNode, sourceNode);
                } else if ("cut".equals(autoVersionComponent.getCurrentClipboard().getType())) {
                    PasteManageComponent.pasteByCut(autoVersionComponent.getCurrentClipboard(), uijcrExplorer, destSession, autoVersionComponent.getCurrentClipboard().getWorkspace(), sourceNode.getPath(), destNode.getParent().getPath(), (ActionServiceContainer)WCMCoreUtils.getService(ActionServiceContainer.class), false, false, true);
                    _clipboardCommands.remove(autoVersionComponent.getCurrentClipboard());
                }
                if (_clipboardCommands.isEmpty()) {
                    UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uijcrExplorer, event);
                    return;
                }
                Map<String, Boolean> versionedRemember = PasteManageComponent.getVersionedRemember();
                if (versionedRemember != null && BooleanUtils.isTrue((Boolean)versionedRemember.get("createVersion")) && !_clipboardCommands.isEmpty()) {
                    String msg = event.getRequestContext().getApplicationResourceBundle().getString("DocumentAuto.messageMultiFile");
                    event.getRequestContext().getJavascriptManager().require("SHARED/wcm-utils", "wcm_utils").addScripts("eXo.ecm.WCMUtils.showNotice(\" " + msg + "\", 'true'); ");
                } else {
                    String msg = event.getRequestContext().getApplicationResourceBundle().getString("DocumentAuto.message");
                    msg = msg.replace("{0}", ContentReader.simpleEscapeHtml((String)("<span style='font-weight:bold;'>" + destNode.getName() + "</span>")));
                    event.getRequestContext().getJavascriptManager().require("SHARED/wcm-utils", "wcm_utils").addScripts("eXo.ecm.WCMUtils.showNotice(\" " + msg + "\", 'true'); ");
                }
                PasteManageComponent.processPasteMultiple(destNode.getParent(), event, uijcrExplorer, _clipboardCommands, UIDocumentAutoVersionForm.CREATE_VERSION);
            } else {
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uijcrExplorer, event);
            }
            if (chkRem && chkRemNon) {
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uijcrExplorer, event);
            }
        }
    }

    public static class KeepBothActionListener
    extends EventListener<UIDocumentAutoVersionForm> {
        public void execute(Event<UIDocumentAutoVersionForm> event) throws Exception {
            Matcher matcher;
            UIDocumentAutoVersionForm autoVersionComponent = (UIDocumentAutoVersionForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)autoVersionComponent.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
            UICheckBoxInput chkRemVersion = (UICheckBoxInput)autoVersionComponent.findComponentById(UIDocumentAutoVersionForm.REMEMBER_VERSIONED_COMPONENT);
            UICheckBoxInput chkRemNonVersioned = (UICheckBoxInput)autoVersionComponent.findComponentById(UIDocumentAutoVersionForm.REMEMBER_NONVERSIONED_COMPONENT);
            boolean chkRem = chkRemVersion.isChecked() && chkRemVersion.isRendered();
            boolean chkRemNon = chkRemNonVersioned.isChecked() && chkRemNonVersioned.isRendered();
            Session destSession = uiExplorer.getSessionByWorkspace(autoVersionComponent.getDestWorkspace());
            Session srcSession = uiExplorer.getSessionByWorkspace(autoVersionComponent.getSourceWorkspace());
            Node sourceNode = uiExplorer.getNodeByPath(autoVersionComponent.getSourcePath(), srcSession);
            String destPath = autoVersionComponent.getDestPath();
            Node destNode = uiExplorer.getNodeByPath(destPath, srcSession);
            boolean isFolder = destNode.isNodeType("nt:folder");
            if (destPath != null && (matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(destPath)).find()) {
                destPath = matcher.group(2);
            }
            if (!"/".equals(destPath)) {
                destPath = destPath.concat("/");
            }
            destPath = destPath.concat(sourceNode.getName());
            if (autoVersionComponent.isSingleProcess) {
                try {
                    if ("cut".equals(autoVersionComponent.getCurrentClipboard().getType())) {
                        PasteManageComponent.pasteByCut(autoVersionComponent.getCurrentClipboard(), uiExplorer, destSession, autoVersionComponent.getCurrentClipboard().getWorkspace(), sourceNode.getPath(), destPath, (ActionServiceContainer)WCMCoreUtils.getService(ActionServiceContainer.class), false, false, false);
                    } else {
                        if (isFolder) {
                            Node existNode = uiExplorer.getNodeByPath(destPath, srcSession);
                            int i = 1;
                            String newDestPath = "";
                            while (existNode != null) {
                                int lastDotIndex = destPath.lastIndexOf(46);
                                newDestPath = destPath.substring(0, lastDotIndex) + i + destPath.substring(lastDotIndex);
                                existNode = uiExplorer.getNodeByPath(newDestPath, srcSession);
                                ++i;
                            }
                            destPath = newDestPath;
                        }
                        UIDocumentAutoVersionForm.copyNode(destSession, autoVersionComponent.getSourceWorkspace(), autoVersionComponent.getSourcePath(), destPath, uiApp, uiExplorer, event, "copy");
                    }
                }
                catch (ItemExistsException iee) {
                    uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.paste-node-same-name", null, 1));
                    uiExplorer.updateAjax(event);
                    return;
                }
            }
            destNode = (Node)destSession.getItem(destPath);
            HashMap<String, Boolean> remember = new HashMap<String, Boolean>();
            if (destNode.isNodeType("mix:versionable") && chkRem) {
                remember.put("keepboth", true);
                PasteManageComponent.setVersionedRemember(remember);
            } else if (!destNode.isNodeType("mix:versionable") && chkRemNon) {
                remember.put("keepboth", true);
                PasteManageComponent.setNonVersionedRemember(remember);
            }
            Set<ClipboardCommand> _clipboardCommands = autoVersionComponent.getClipboardCommands();
            if (!autoVersionComponent.isSingleProcess && _clipboardCommands != null && _clipboardCommands.size() > 0) {
                if ("cut".equals(autoVersionComponent.getCurrentClipboard().getType())) {
                    PasteManageComponent.pasteByCut(autoVersionComponent.getCurrentClipboard(), uiExplorer, destSession, autoVersionComponent.getCurrentClipboard().getWorkspace(), sourceNode.getPath(), destPath, (ActionServiceContainer)WCMCoreUtils.getService(ActionServiceContainer.class), false, false, false);
                } else {
                    UIDocumentAutoVersionForm.copyNode(destSession, autoVersionComponent.getSourceWorkspace(), autoVersionComponent.getSourcePath(), destPath, uiApp, uiExplorer, event, "copy");
                }
                _clipboardCommands.remove(autoVersionComponent.getCurrentClipboard());
                if (_clipboardCommands.isEmpty()) {
                    UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uiExplorer, event);
                    return;
                }
                PasteManageComponent.processPasteMultiple(destNode.getParent(), event, uiExplorer, _clipboardCommands, UIDocumentAutoVersionForm.KEEP_BOTH);
            } else {
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uiExplorer, event);
            }
            if (chkRem && chkRemNon) {
                UIDocumentAutoVersionForm.closePopup(autoVersionComponent, uiExplorer, event);
            }
        }
    }
}

