/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.documents;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.documents.DocumentSelectItemOption;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.cms.documents.DocumentEditorProvider;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.cms.documents.NewDocumentTemplate;
import org.exoplatform.services.cms.documents.NewDocumentTemplateProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:groovy/ecm/webui/UINewDocument.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UINewDocumentForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_TITLE_TEXT_BOX = "titleTextBox";
    public static final String FIELD_TYPE_SELECT_BOX = "typeSelectBox";
    private static final String DEFAULT_NAME = "untitled";
    protected static final Log LOG = ExoLogger.getLogger((String)UINewDocumentForm.class.getName());
    protected DocumentService documentService = (DocumentService)this.getApplicationComponent(DocumentService.class);

    public UINewDocumentForm() {
        UIFormStringInput titleTextBox = new UIFormStringInput(FIELD_TITLE_TEXT_BOX, FIELD_TITLE_TEXT_BOX, null);
        this.addUIFormInput((UIFormInput)titleTextBox);
        List templateProviders = this.documentService.getNewDocumentTemplateProviders();
        ArrayList options = new ArrayList();
        Identity identity = ConversationState.getCurrent().getIdentity();
        templateProviders.forEach(provider -> {
            if (provider.getEditor().isAvailableForUser(identity)) {
                provider.getTemplates().forEach(template -> {
                    DocumentSelectItemOption<String> option = new DocumentSelectItemOption<String>(template.getName(), (NewDocumentTemplateProvider)provider);
                    options.add(option);
                });
            }
        });
        UIFormSelectBox typeSelectBox = new UIFormSelectBox(FIELD_TYPE_SELECT_BOX, FIELD_TYPE_SELECT_BOX, options);
        typeSelectBox.setRendered(true);
        this.addUIFormInput((UIFormInput)typeSelectBox);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public static class CancelActionListener
    extends EventListener<UINewDocumentForm> {
        public void execute(Event<UINewDocumentForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UINewDocumentForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    public static class SaveActionListener
    extends EventListener<UINewDocumentForm> {
        public void execute(Event<UINewDocumentForm> event) throws Exception {
            UINewDocumentForm uiDocumentForm = (UINewDocumentForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiDocumentForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiDocumentForm.getAncestorOfType(UIApplication.class);
            Node currentNode = uiExplorer.getCurrentNode();
            if (uiExplorer.nodeIsLocked(currentNode)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentForm);
                return;
            }
            String title = (String)uiDocumentForm.getUIStringInput(UINewDocumentForm.FIELD_TITLE_TEXT_BOX).getValue();
            if (StringUtils.isBlank((String)title)) {
                uiApp.addMessage(new ApplicationMessage("UINewDocumentForm.msg.name-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocumentForm);
                return;
            }
            UIFormSelectBox typeSelectBox = uiDocumentForm.getUIFormSelectBox(UINewDocumentForm.FIELD_TYPE_SELECT_BOX);
            List options = typeSelectBox.getOptions();
            DocumentSelectItemOption selectedOption = (DocumentSelectItemOption)options.stream().filter(option -> option.isSelected()).findFirst().get();
            NewDocumentTemplateProvider templateProvider = selectedOption.getTemplateProvider();
            String name = selectedOption.getLabel();
            NewDocumentTemplate template = templateProvider.getTemplate(name);
            DocumentEditorProvider editorProvider = templateProvider.getEditor();
            title = this.getFileName(title, template);
            Identity identity = ConversationState.getCurrent().getIdentity();
            if (editorProvider != null && editorProvider.isAvailableForUser(identity)) {
                editorProvider.beforeDocumentCreate(template, currentNode.getPath(), title);
            }
            Node document = null;
            try {
                document = templateProvider.createDocument(currentNode, title, template);
            }
            catch (ConstraintViolationException cve) {
                Object[] arg = new Object[]{typeSelectBox.getValue()};
                throw new MessageException(new ApplicationMessage("UINewDocumentForm.msg.constraint-violation", arg, 1));
            }
            catch (AccessDeniedException accessDeniedException) {
                uiApp.addMessage(new ApplicationMessage("UINewDocumentForm.msg.repository-exception-permission", null, 1));
            }
            catch (ItemExistsException re) {
                uiApp.addMessage(new ApplicationMessage("UINewDocumentForm.msg.not-allow-sameNameSibling", null, 1));
            }
            catch (RepositoryException re) {
                String key = "UINewDocumentForm.msg.repository-exception";
                NodeDefinition[] definitions = currentNode.getPrimaryNodeType().getChildNodeDefinitions();
                boolean isSameNameSiblingsAllowed = false;
                for (NodeDefinition def : definitions) {
                    if (!def.allowsSameNameSiblings()) continue;
                    isSameNameSiblingsAllowed = true;
                    break;
                }
                if (currentNode.hasNode(title) && !isSameNameSiblingsAllowed) {
                    key = "UINewDocumentForm.msg.not-allow-sameNameSibling";
                }
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
            }
            catch (NumberFormatException nume) {
                uiApp.addMessage(new ApplicationMessage("UINewDocumentForm.msg.numberformat-exception", null, 1));
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
            if (document != null && editorProvider != null && editorProvider.isAvailableForUser(identity)) {
                editorProvider.onDocumentCreated(document.getSession().getWorkspace().getName(), document.getPath());
            }
            uiExplorer.updateAjax(event);
        }

        public String getFileName(String title, NewDocumentTemplate template) {
            String path;
            String extension;
            if (StringUtils.isEmpty((String)(title = Text.escapeIllegalJcrChars((String)title)))) {
                title = UINewDocumentForm.DEFAULT_NAME;
            }
            if (((extension = template.getExtension()) == null || extension.trim().isEmpty()) && (path = template.getPath()).contains(".")) {
                extension = path.substring(path.lastIndexOf("."));
            }
            if (!title.endsWith(extension)) {
                title = title + extension;
            }
            return title;
        }
    }
}

