/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.mimetype;

import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Properties;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class DMSMimeTypeResolver {
    private static final String MIMETYPES_FILE_PATH = "exo.files.mimetypes.path";
    private Properties dmsmimeTypes = new Properties();
    private static MimeTypeResolver mimeTypes = new MimeTypeResolver();
    private static DMSMimeTypeResolver dmsMimeTypeResolver;

    private DMSMimeTypeResolver() {
        URLConnection connection;
        URL filePath;
        ConfigurationManager configurationService = WCMCoreUtils.getService(ConfigurationManager.class);
        try {
            filePath = configurationService.getURL("file://" + PropertyManager.getProperty((String)MIMETYPES_FILE_PATH));
            if (filePath != null) {
                connection = filePath.openConnection();
                this.dmsmimeTypes.load(connection.getInputStream());
            }
        }
        catch (Exception filePath2) {
            // empty catch block
        }
        if (this.dmsmimeTypes.isEmpty()) {
            try {
                filePath = configurationService.getURL("war:/conf/wcm-core/mimetype/mimetypes.properties");
                if (filePath != null) {
                    connection = filePath.openConnection();
                    this.dmsmimeTypes.load(connection.getInputStream());
                } else {
                    this.dmsmimeTypes.load(this.getClass().getResourceAsStream("/conf/mimetype/mimetypes.properties"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DMSMimeTypeResolver getInstance() throws Exception {
        if (dmsMimeTypeResolver != null) return dmsMimeTypeResolver;
        Class<DMSMimeTypeResolver> clazz = DMSMimeTypeResolver.class;
        synchronized (DMSMimeTypeResolver.class) {
            if (dmsMimeTypeResolver != null) return dmsMimeTypeResolver;
            dmsMimeTypeResolver = new DMSMimeTypeResolver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dmsMimeTypeResolver;
        }
    }

    public String getMimeType(String filename) {
        String mimeType;
        String ext = filename.substring(filename.lastIndexOf(".") + 1);
        if (ext.equals("")) {
            ext = filename;
        }
        if ((mimeType = this.dmsmimeTypes.getProperty(ext.toLowerCase(), mimeTypes.getDefaultMimeType())) == null || mimeType.length() == 0) {
            return mimeTypes.getMimeType(filename);
        }
        return mimeType;
    }

    public String getExtension(String mimeType) {
        if (mimeType.equals("") || mimeType.equals(mimeTypes.getDefaultMimeType())) {
            return "";
        }
        Iterator<Object> iterator = this.dmsmimeTypes.keySet().iterator();
        String ext = "";
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)this.dmsmimeTypes.get(key);
            if (value.equals(mimeType) && mimeType.endsWith(key)) {
                return key;
            }
            if (value.equals(mimeType) && ext.equals("")) {
                ext = new String(key);
                continue;
            }
            if (!value.equals(mimeType) || ext.equals("")) continue;
            return ext;
        }
        return ext;
    }
}

