/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.notification.plugin;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="ShareFileToUserPlugin", template="war:/wcm-notification/templates/intranet-notification/ShareDocumentToUser.gtmpl"), @TemplateConfig(pluginId="ShareFileToSpacePlugin", template="war:/wcm-notification/templates/intranet-notification/ShareDocumentToSpace.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    private AbstractTemplateBuilder shareFileToUserPlugin = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getFrom(), true);
            Profile profile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"THUMBNAIL_URL", (Object)notification.getValueOwnerParameter("documentIcon"));
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"USER", (Object)profile.getFullName());
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png"));
            templateContext.put((Object)"DOCUMENT", (Object)notification.getValueOwnerParameter("documentName"));
            templateContext.put((Object)"DOCUMENT_URL", (Object)notification.getValueOwnerParameter("documentUrl"));
            templateContext.put((Object)"PERMISSION", (Object)notification.getValueOwnerParameter("permission"));
            templateContext.put((Object)"MESSAGE", (Object)notification.getValueOwnerParameter("comment"));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };
    private AbstractTemplateBuilder shareFileToSpacePlugin = new AbstractTemplateBuilder(){

        protected MessageInfo makeMessage(NotificationContext ctx) {
            NotificationInfo notification = ctx.getNotificationInfo();
            String language = this.getLanguage(notification);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)notification.getKey().getId(), (String)language);
            Identity identity = Utils.getIdentityManager().getOrCreateIdentity("organization", notification.getFrom(), true);
            Profile profile = identity.getProfile();
            templateContext.put((Object)"isIntranet", (Object)"true");
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(notification.getLastModifiedDate());
            templateContext.put((Object)"THUMBNAIL_URL", (Object)notification.getValueOwnerParameter("documentIcon"));
            templateContext.put((Object)"READ", (Object)(Boolean.valueOf(notification.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey())) != false ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notification.getId());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)cal.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            templateContext.put((Object)"USER", (Object)profile.getFullName());
            templateContext.put((Object)"AVATAR", (Object)(profile.getAvatarUrl() != null ? profile.getAvatarUrl() : "/eXoSkin/skin/images/avatar/DefaultUserAvatar.png"));
            templateContext.put((Object)"DOCUMENT", (Object)notification.getValueOwnerParameter("documentName"));
            templateContext.put((Object)"DOCUMENT_URL", (Object)notification.getValueOwnerParameter("documentUrl"));
            templateContext.put((Object)"SPACE", (Object)notification.getValueOwnerParameter("spaceName"));
            templateContext.put((Object)"PERMISSION", (Object)notification.getValueOwnerParameter("permission"));
            templateContext.put((Object)"MESSAGE", (Object)notification.getValueOwnerParameter("comment"));
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            ctx.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext ctx, Writer writer) {
            return false;
        }
    };

    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"ShareFileToUserPlugin"), this.shareFileToUserPlugin);
        this.templateBuilders.put(PluginKey.key((String)"ShareFileToSpacePlugin"), this.shareFileToSpacePlugin);
    }
}

