/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.DefaultHttpProvider;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.GraphServiceException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.IConnection;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.IHttpRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.IStatefulResponseHandler;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.logger.ILogger;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.UploadSession;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.ChunkedUploadResult;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.serializer.ISerializer;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.okhttp3.Response;

public class ChunkedUploadResponseHandler<UploadType>
implements IStatefulResponseHandler<ChunkedUploadResult, UploadType> {
    private final Class<UploadType> deserializeTypeClass;

    public ChunkedUploadResponseHandler(Class<UploadType> uploadType) {
        this.deserializeTypeClass = uploadType;
    }

    @Override
    public void configConnection(IConnection connection) {
    }

    @Override
    public void configConnection(Response response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkedUploadResult<UploadType> generateResult(IHttpRequest request, IConnection connection, ISerializer serializer, ILogger logger) throws Exception {
        InputStream in = null;
        try {
            if (connection.getResponseCode() == 202) {
                logger.logDebug("Chunk bytes has been accepted by the server.");
                in = new BufferedInputStream(connection.getInputStream());
                UploadSession session = serializer.deserializeObject(DefaultHttpProvider.streamToString(in), UploadSession.class);
                ChunkedUploadResult chunkedUploadResult = new ChunkedUploadResult(session);
                return chunkedUploadResult;
            }
            if (connection.getResponseCode() == 201 || connection.getResponseCode() == 200) {
                logger.logDebug("Upload session is completed, uploaded item returned.");
                in = new BufferedInputStream(connection.getInputStream());
                String rawJson = DefaultHttpProvider.streamToString(in);
                UploadType uploadedItem = serializer.deserializeObject(rawJson, this.deserializeTypeClass);
                ChunkedUploadResult<UploadType> chunkedUploadResult = new ChunkedUploadResult<UploadType>(uploadedItem);
                return chunkedUploadResult;
            }
            if (connection.getResponseCode() >= 400) {
                logger.logDebug("Receiving error during upload, see detail on result error");
                ChunkedUploadResult rawJson = new ChunkedUploadResult(GraphServiceException.createFromConnection(request, null, serializer, connection, logger));
                return rawJson;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.logError(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChunkedUploadResult<UploadType> generateResult(IHttpRequest request, Response response, ISerializer serializer, ILogger logger) throws Exception {
        InputStream in = null;
        try {
            if (response.code() == 202) {
                logger.logDebug("Chunk bytes has been accepted by the server.");
                in = new BufferedInputStream(response.body().byteStream());
                UploadSession session = serializer.deserializeObject(DefaultHttpProvider.streamToString(in), UploadSession.class);
                ChunkedUploadResult chunkedUploadResult = new ChunkedUploadResult(session);
                return chunkedUploadResult;
            }
            if (response.code() == 201 || response.code() == 200) {
                logger.logDebug("Upload session is completed, uploaded item returned.");
                in = new BufferedInputStream(response.body().byteStream());
                String rawJson = DefaultHttpProvider.streamToString(in);
                UploadType uploadedItem = serializer.deserializeObject(rawJson, this.deserializeTypeClass);
                ChunkedUploadResult<UploadType> chunkedUploadResult = new ChunkedUploadResult<UploadType>(uploadedItem);
                return chunkedUploadResult;
            }
            if (response.code() >= 400) {
                logger.logDebug("Receiving error during upload, see detail on result error");
                ChunkedUploadResult rawJson = new ChunkedUploadResult(GraphServiceException.createFromConnection(request, null, serializer, response, logger));
                return rawJson;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.logError(e.getMessage(), e);
                }
            }
        }
        return null;
    }
}

