/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.permission.info.UIPermissionInputSet;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.views.UITabContainer;
import org.exoplatform.ecm.webui.component.admin.views.UITabList;
import org.exoplatform.ecm.webui.component.admin.views.UIViewContainer;
import org.exoplatform.ecm.webui.component.admin.views.UIViewForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewFormTabPane;
import org.exoplatform.ecm.webui.component.admin.views.UIViewPermissionContainer;
import org.exoplatform.ecm.webui.component.admin.views.UIViewPermissionForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewPermissionList;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.cms.views.impl.ManageViewPlugin;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIViewList.msg.confirm-delete"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={AddViewActionListener.class})})
public class UIViewList
extends UIPagingGrid {
    public static final String[] ACTIONS = new String[]{"AddView"};
    public static final String ST_VIEW = "ViewPopup";
    public static final String ST_EDIT = "EditPopup";
    public static final String ST_ADD = "AddPopup";
    private static String[] VIEW_BEAN_FIELD = new String[]{"name", "permissions", "tabList", "baseVersion"};
    private static String[] VIEW_ACTION = new String[]{"View", "EditInfo", "Delete"};

    public UIViewList() throws Exception {
        this.getUIPageIterator().setId("UIViewsGrid");
        this.configure("id", VIEW_BEAN_FIELD, VIEW_ACTION);
    }

    private String getBaseVersion(String name) throws Exception {
        Node node = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getViewByName(name, WCMCoreUtils.getSystemSessionProvider());
        if (node == null) {
            return null;
        }
        if (!node.isNodeType("mix:versionable") || node.isNodeType("nt:frozenNode")) {
            return "";
        }
        return node.getBaseVersion().getName();
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void refresh(int currentPage) throws Exception {
        List<ViewBean> viewBean = this.getViewsBean();
        Collections.sort(viewBean, new ViewComparator());
        ListAccessImpl viewBeanList = new ListAccessImpl(ViewBean.class, viewBean);
        this.getUIPageIterator().setPageList((PageList)new LazyPageList((ListAccess)viewBeanList, this.getUIPageIterator().getItemsPerPage()));
        this.getUIPageIterator().setTotalItems(viewBean.size());
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    private List<ViewBean> getViewsBean() throws Exception {
        List views = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getAllViews();
        ArrayList<ViewBean> viewBeans = new ArrayList<ViewBean>();
        for (ViewConfig view : views) {
            ArrayList<String> tabsName = new ArrayList<String>();
            for (ViewConfig.Tab tab : view.getTabList()) {
                tabsName.add(tab.getTabName());
            }
            ViewBean bean = new ViewBean(view.getName(), this.getFriendlyViewPermission(view.getPermissions()), tabsName);
            if (this.getBaseVersion(view.getName()) == null) continue;
            bean.setBaseVersion(this.getBaseVersion(view.getName()));
            viewBeans.add(bean);
        }
        return viewBeans;
    }

    public boolean canDelete(List<DriveData> drivers, String viewName) {
        for (DriveData driver : drivers) {
            String views = driver.getViews();
            for (String view : views.split(",")) {
                if (!viewName.equals(view.trim())) continue;
                return false;
            }
        }
        return true;
    }

    public String getRepository() {
        return ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
    }

    private String getFriendlyViewPermission(String permissions) throws Exception {
        UIViewContainer uiViewContainer = (UIViewContainer)this.getParent();
        String[] arrPers = new String[]{};
        if (permissions.contains(",")) {
            arrPers = permissions.split(",");
        } else if (permissions.length() > 0) {
            arrPers = new String[]{permissions};
        }
        StringBuilder perBuilder = new StringBuilder();
        for (String per : arrPers) {
            if (perBuilder.length() > 0) {
                perBuilder.append(", ");
            }
            perBuilder.append(uiViewContainer.getFriendlyPermission(per));
        }
        return perBuilder.toString();
    }

    public class ViewBean {
        private String id;
        private String name;
        private String permissions;
        private String tabList;
        private String baseVersion = "";

        public ViewBean(String n, String per, List<String> tabs) {
            this.id = n;
            this.name = n;
            this.permissions = per;
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < tabs.size(); ++i) {
                str.append(" [").append(tabs.get(i)).append("]");
            }
            this.tabList = str.toString();
        }

        public String getBaseVersion() {
            return this.baseVersion;
        }

        public void setBaseVersion(String s) {
            this.baseVersion = s;
        }

        public String getName() {
            ResourceBundle res = RequestContext.getCurrentInstance().getApplicationResourceBundle();
            String label = null;
            try {
                label = res.getString("Views.label." + this.name);
            }
            catch (MissingResourceException e) {
                label = this.name;
            }
            return label;
        }

        public void setName(String s) {
            this.name = s;
        }

        public String getPermissions() {
            return this.permissions;
        }

        public void setPermissions(String s) {
            this.permissions = s;
        }

        public String getTabList() {
            return this.tabList;
        }

        public void setTabList(String ls) {
            this.tabList = ls;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class ViewActionListener
    extends EventListener<UIViewList> {
        public void execute(Event<UIViewList> event) throws Exception {
            UIViewList uiViewList = (UIViewList)((Object)event.getSource());
            uiViewList.setRenderSibling(UIViewList.class);
            String viewName = event.getRequestContext().getRequestParameter("objectId");
            Node viewNode = ((ManageViewService)uiViewList.getApplicationComponent(ManageViewService.class)).getViewByName(viewName, WCMCoreUtils.getSystemSessionProvider());
            UIViewContainer uiViewContainer = (UIViewContainer)uiViewList.getParent();
            uiViewContainer.removeChildById(UIViewList.ST_EDIT);
            uiViewContainer.removeChildById(UIViewList.ST_ADD);
            UIViewFormTabPane viewTabPane = (UIViewFormTabPane)uiViewContainer.createUIComponent(UIViewFormTabPane.class, null, null);
            viewTabPane.update(false);
            viewTabPane.view(true);
            UIViewPermissionList uiPerList = (UIViewPermissionList)viewTabPane.findFirstComponentOfType(UIViewPermissionList.class);
            uiPerList.configure("permission", UIViewPermissionList.PERMISSION_BEAN_FIELD, null);
            uiPerList.setViewName(viewName);
            UIViewPermissionContainer uiPerContainer = (UIViewPermissionContainer)uiPerList.getParent();
            uiPerContainer.setRenderedChild(UIViewPermissionList.class);
            uiViewContainer.initPopup(UIViewList.ST_VIEW, (UIComponent)viewTabPane);
            uiPerList.refresh(uiPerList.getUIPageIterator().getCurrentPage());
            UITabContainer uiTabContainer = (UITabContainer)viewTabPane.getChild(UITabContainer.class);
            UITabList uiTab = (UITabList)uiTabContainer.getChild(UITabList.class);
            uiTab.setViewName(viewName);
            uiTab.setActions(new String[0]);
            uiTab.configure("tabName", UITabList.TAB_BEAN_FIELD, null);
            uiTab.refresh(uiTab.getUIPageIterator().getCurrentPage());
            UIViewForm uiViewForm = (UIViewForm)viewTabPane.getChild(UIViewForm.class);
            uiViewForm.refresh(false);
            uiViewForm.update(viewNode, true, null);
            viewTabPane.setActions(new String[]{"Close"});
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }

    public static class EditInfoActionListener
    extends EventListener<UIViewList> {
        public void execute(Event<UIViewList> event) throws Exception {
            UIViewList uiViewList = (UIViewList)((Object)event.getSource());
            uiViewList.setRenderSibling(UIViewList.class);
            String viewName = event.getRequestContext().getRequestParameter("objectId");
            Node viewNode = ((ManageViewService)uiViewList.getApplicationComponent(ManageViewService.class)).getViewByName(viewName, WCMCoreUtils.getSystemSessionProvider());
            UIViewContainer uiViewContainer = (UIViewContainer)uiViewList.getParent();
            uiViewContainer.removeChildById(UIViewList.ST_VIEW);
            uiViewContainer.removeChildById(UIViewList.ST_ADD);
            UIViewFormTabPane viewTabPane = (UIViewFormTabPane)uiViewContainer.createUIComponent(UIViewFormTabPane.class, null, null);
            viewTabPane.update(true);
            UIViewForm viewForm = (UIViewForm)viewTabPane.getChild(UIViewForm.class);
            viewForm.refresh(true);
            viewForm.update(viewNode, false, null);
            if (viewForm.getUICheckBoxInput("enableVersion").isChecked()) {
                viewForm.getUICheckBoxInput("enableVersion").setDisabled(true);
            } else {
                viewForm.getUICheckBoxInput("enableVersion").setDisabled(false);
            }
            UIViewPermissionList uiPerList = (UIViewPermissionList)viewTabPane.findFirstComponentOfType(UIViewPermissionList.class);
            uiPerList.setViewName(viewName);
            UIViewPermissionForm uiPermissionForm = (UIViewPermissionForm)viewTabPane.findFirstComponentOfType(UIViewPermissionForm.class);
            UIPermissionInputSet uiPermissionInputSet = (UIPermissionInputSet)uiPermissionForm.getChildById("permission");
            for (UIComponent uiComp : uiPermissionInputSet.getChildren()) {
                if (!(uiComp instanceof UICheckBoxInput)) continue;
                uiPermissionInputSet.removeChildById(uiComp.getId());
            }
            uiViewContainer.initPopup(UIViewList.ST_EDIT, (UIComponent)viewTabPane);
            uiPerList.refresh(uiPerList.getUIPageIterator().getCurrentPage());
            UITabContainer uiTabContainer = (UITabContainer)viewTabPane.getChild(UITabContainer.class);
            UITabList uiTab = (UITabList)uiTabContainer.getChild(UITabList.class);
            uiTab.setViewName(viewName);
            uiTab.refresh(uiTab.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }

    public static class DeleteActionListener
    extends EventListener<UIViewList> {
        public void execute(Event<UIViewList> event) throws Exception {
            UIViewList viewList = (UIViewList)((Object)event.getSource());
            viewList.setRenderSibling(UIViewList.class);
            String viewName = event.getRequestContext().getRequestParameter("objectId");
            ManageDriveService manageDrive = (ManageDriveService)viewList.getApplicationComponent(ManageDriveService.class);
            ManageViewService manageViewService = (ManageViewService)viewList.getApplicationComponent(ManageViewService.class);
            if (!viewList.canDelete(manageDrive.getAllDrives(), viewName)) {
                ResourceBundle res = RequestContext.getCurrentInstance().getApplicationResourceBundle();
                String viewDisplayName = null;
                try {
                    viewDisplayName = res.getString("Views.label." + viewName);
                }
                catch (MissingResourceException e) {
                    viewDisplayName = viewName;
                }
                UIApplication app = (UIApplication)viewList.getAncestorOfType(UIApplication.class);
                Object[] args = new Object[]{viewDisplayName};
                app.addMessage(new ApplicationMessage("UIViewList.msg.template-in-use", args));
                event.getRequestContext().addUIComponentToUpdateByAjax(viewList.getParent());
                return;
            }
            manageViewService.removeView(viewName);
            Utils.addEditedConfiguredData((String)viewName, (String)ManageViewPlugin.class.getSimpleName(), (String)"EditedConfiguredViews", (boolean)true);
            viewList.refresh(viewList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax(viewList.getParent());
        }
    }

    public static class AddViewActionListener
    extends EventListener<UIViewList> {
        public void execute(Event<UIViewList> event) throws Exception {
            UIViewList uiViewList = (UIViewList)((Object)event.getSource());
            if (uiViewList.getViewsBean().size() == 0) {
                UIApplication uiApp = (UIApplication)((UIViewList)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIViewList.msg.access-denied", null, 1));
                return;
            }
            UIViewContainer uiViewContainer = (UIViewContainer)uiViewList.getParent();
            uiViewContainer.removeChildById(UIViewList.ST_VIEW);
            uiViewContainer.removeChildById(UIViewList.ST_EDIT);
            UIViewFormTabPane uiTabPane = (UIViewFormTabPane)uiViewContainer.createUIComponent(UIViewFormTabPane.class, null, null);
            uiTabPane.update(false);
            UIViewPermissionForm uiPermissionForm = (UIViewPermissionForm)uiTabPane.findFirstComponentOfType(UIViewPermissionForm.class);
            UIPermissionInputSet uiPermissionInputSet = (UIPermissionInputSet)uiPermissionForm.getChildById("permission");
            for (UIComponent uiComp : uiPermissionInputSet.getChildren()) {
                if (!(uiComp instanceof UICheckBoxInput)) continue;
                uiPermissionInputSet.removeChildById(uiComp.getId());
            }
            uiViewContainer.initPopup(UIViewList.ST_ADD, (UIComponent)uiTabPane);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }

    public static class ViewComparator
    implements Comparator<ViewBean> {
        @Override
        public int compare(ViewBean v1, ViewBean v2) throws ClassCastException {
            String name1 = v1.getName();
            String name2 = v2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

