/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.ecm.utils.lock.LockUtil;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.info.UIViewMetadataManager;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfigs(value={@ComponentConfig(type=UIFormMultiValueInputSet.class, id="WYSIWYGRichTextMultipleInputset", events={@EventConfig(listeners={UIDialogForm.AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormMultiValueInputSet.RemoveActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIViewMetadataForm
extends UIDialogForm {
    private String nodeType_;
    private static final Log LOG = ExoLogger.getLogger((String)UIViewMetadataForm.class.getName());

    public UIViewMetadataForm() throws Exception {
        this.setActions(ACTIONS);
    }

    public void setNodeType(String nodeType) {
        this.nodeType_ = nodeType;
    }

    public String getNodeType() {
        return this.nodeType_;
    }

    public String getDialogTemplatePath() {
        this.repositoryName = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        MetadataService metadataService = (MetadataService)this.getApplicationComponent(MetadataService.class);
        try {
            return metadataService.getMetadataPath(this.nodeType_, true);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
            return null;
        }
    }

    public String getTemplate() {
        return this.getDialogTemplatePath();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public boolean isEqualsValueStringArrays(Value[] arrayValue1, String[] arrayValue2) throws ValueFormatException, IllegalStateException, RepositoryException {
        if (arrayValue1 != null) {
            Object[] stringArray = new String[arrayValue1.length];
            int i = 0;
            for (Value valueItem : arrayValue1) {
                if (valueItem != null && valueItem.getString() != null) {
                    stringArray[i] = valueItem.getString();
                }
                ++i;
            }
            if (stringArray != null && stringArray.length > 0) {
                Arrays.sort(stringArray);
            }
            if (arrayValue2 != null && arrayValue2.length > 0) {
                Arrays.sort(arrayValue2);
            }
            return ArrayUtils.isEquals((Object)stringArray, (Object)arrayValue2);
        }
        return arrayValue2 == null;
    }

    public static class RemoveActionListener
    extends EventListener<UIViewMetadataForm> {
        public void execute(Event<UIViewMetadataForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIViewMetadataForm)((Object)event.getSource())).getParent());
        }
    }

    public static class AddActionListener
    extends EventListener<UIViewMetadataForm> {
        public void execute(Event<UIViewMetadataForm> event) throws Exception {
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIViewMetadataForm)((Object)event.getSource())).getParent());
        }
    }

    public static class CancelActionListener
    extends EventListener<UIViewMetadataForm> {
        public void execute(Event<UIViewMetadataForm> event) throws Exception {
            UIViewMetadataForm uiForm = (UIViewMetadataForm)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(((UIViewMetadataForm)((Object)event.getSource())).getParent());
        }
    }

    public static class SaveActionListener
    extends EventListener<UIViewMetadataForm> {
        public void execute(Event<UIViewMetadataForm> event) throws Exception {
            UIViewMetadataForm uiForm = (UIViewMetadataForm)((Object)event.getSource());
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
            UIViewMetadataManager uiViewManager = (UIViewMetadataManager)uiForm.getAncestorOfType(UIViewMetadataManager.class);
            Node node = uiViewManager.getViewNode(uiForm.getNodeType());
            Node parent = node.getParent();
            if (parent.isLocked()) {
                parent.getSession().addLockToken(LockUtil.getLockToken((Node)parent));
            }
            Node activityNode = node;
            if (node.isNodeType("nt:resource")) {
                activityNode = node.getParent();
            }
            if (activityNode.canAddMixin(ActivityCommonService.MIX_COMMENT)) {
                activityNode.addMixin(ActivityCommonService.MIX_COMMENT);
            }
            NodeTypeManager ntManager = uiJCRExplorer.getSession().getWorkspace().getNodeTypeManager();
            PropertyDefinition[] props = ntManager.getNodeType(uiForm.getNodeType()).getPropertyDefinitions();
            ArrayList<Value> valueList = new ArrayList<Value>();
            for (PropertyDefinition prop : props) {
                UIFormInput uiInput;
                String name = prop.getName();
                String inputName = name.substring(name.indexOf(":") + 1);
                if (prop.isProtected()) continue;
                int requiredType = prop.getRequiredType();
                if (prop.isMultiple()) {
                    if (requiredType == 5) {
                        UIFormDateTimeInput uiFormDateTime = (UIFormDateTimeInput)uiForm.getUIInput(inputName);
                        if (uiFormDateTime == null) continue;
                        valueList.add(uiJCRExplorer.getSession().getValueFactory().createValue(uiFormDateTime.getCalendar()));
                        if (node.hasProperty(name) && node.getProperty(name).getValues()[0].getDate().compareTo(((Value)valueList.get(0)).getDate()) == 0) continue;
                        node.setProperty(name, valueList.toArray(new Value[0]));
                        continue;
                    }
                    uiInput = uiForm.getUIInput(inputName);
                    if (uiInput instanceof UIFormSelectBox) {
                        String[] valuesReal = ((UIFormSelectBox)uiInput).getSelectedValues();
                        if ((node.hasProperty(name) || valuesReal.length <= 0) && (!node.hasProperty(name) || uiForm.isEqualsValueStringArrays(node.getProperty(name).getValues(), valuesReal))) continue;
                        node.setProperty(name, valuesReal);
                        continue;
                    }
                    List values = ((UIFormMultiValueInputSet)uiInput).getValue();
                    if ((node.hasProperty(name) || values.size() <= 0) && (!node.hasProperty(name) || uiForm.isEqualsValueStringArrays(node.getProperty(name).getValues(), values.toArray(new String[values.size()])))) continue;
                    for (int i = 0; i < values.size(); ++i) {
                        values.set(i, HTMLSanitizer.sanitize((String)((String)values.get(i))));
                    }
                    node.setProperty(name, values.toArray(new String[values.size()]));
                    continue;
                }
                if (requiredType == 6) {
                    uiInput = uiForm.getUIInput(inputName);
                    if (uiInput == null) continue;
                    boolean value = false;
                    if (uiInput instanceof UIFormSelectBox) {
                        value = Boolean.parseBoolean((String)((UIFormSelectBox)uiInput).getValue());
                    } else if (uiInput instanceof UICheckBoxInput) {
                        value = ((UICheckBoxInput)uiInput).isChecked();
                    }
                    if (node.hasProperty(name) && (!node.hasProperty(name) || node.getProperty(name).getBoolean() == value)) continue;
                    node.setProperty(name, value);
                    continue;
                }
                if (requiredType == 5) {
                    UIFormDateTimeInput cal = (UIFormDateTimeInput)uiForm.getUIInput(inputName);
                    if (cal == null || node.hasProperty(name) && cal.getCalendar().compareTo(node.getProperty(name).getDate()) == 0) continue;
                    node.setProperty(name, cal.getCalendar());
                    continue;
                }
                if (requiredType == 1) {
                    String value = "";
                    if (uiForm.getUIInput(inputName) != null && (value = (String)((UIFormStringInput)uiForm.getUIInput(inputName)).getValue()) == null) {
                        value = "";
                    }
                    value = HTMLSanitizer.sanitize((String)value);
                    if (node.hasProperty(name) && (!node.hasProperty(name) || node.getProperty(name).getString().equals(value))) continue;
                    node.setProperty(name, value);
                    continue;
                }
                if (requiredType != 4) continue;
                uiInput = uiForm.getUIInput(inputName);
                double value = 0.0;
                if ((uiInput == null || StringUtils.isBlank((String)((String)uiInput.getValue()))) && node.hasProperty(name)) {
                    node.setProperty(name, (Value)null);
                    continue;
                }
                try {
                    value = Double.parseDouble((String)uiInput.getValue());
                    if (node.getProperty(name).getDouble() == value) continue;
                    node.setProperty(name, value);
                }
                catch (NumberFormatException e) {
                    UIApplication uiapp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                    uiapp.addMessage(new ApplicationMessage("UIViewMetadataForm.msg.Invalid-number", null, 1));
                    LOG.error((Object)("Cannot save field '" + name + "'. The value '" + value + "' is not a number"), (Throwable)e);
                }
            }
            if (activityNode.isNodeType(ActivityCommonService.MIX_COMMENT)) {
                activityNode.removeMixin(ActivityCommonService.MIX_COMMENT);
            }
            node.getSession().save();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewManager);
            UIPopupWindow uiPopup = (UIPopupWindow)uiViewManager.getChildById("metadataForm");
            uiPopup.setShow(false);
            uiPopup.setShowMask(true);
        }
    }
}

