/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManagerTrees;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.core.UIPagingGridDecorator;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/admin/taxonomy/UITaxonomyTreeList.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UITaxonomyTreeList.msg.confirm-delete"), @EventConfig(listeners={EditTaxonomyTreeActionListener.class}), @EventConfig(listeners={AddTaxonomyTreeActionListener.class})})
public class UITaxonomyTreeList
extends UIPagingGridDecorator {
    public static final String[] ACTIONS = new String[]{"AddTaxonomyTree"};
    public static final String ST_ADD = "AddTaxonomyTreePopup";
    public static final String ST_EDIT = "EditTaxonomyTreePopup";
    public static final String ACCESS_PERMISSION = "exo:accessPermissions";
    private boolean isTargetInTrash_ = false;
    private static final Log LOG = ExoLogger.getLogger((String)UITaxonomyTreeList.class.getName());

    public UITaxonomyTreeList() throws Exception {
        this.getUIPageIterator().setId("UITaxonomyTreeListIterator");
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public List getTaxonomyTreeList() throws Exception {
        return this.getUIPageIterator().getCurrentPageData();
    }

    public void refresh(int currentPage) throws Exception {
        this.isTargetInTrash_ = false;
        ListAccessImpl taxonomyTreeList = new ListAccessImpl(TaxonomyTreeData.class, this.getAllTaxonomyTreeList());
        LazyPageList dataPageList = new LazyPageList((ListAccess)taxonomyTreeList, this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setPageList((PageList)dataPageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public boolean isTargetInTrash() {
        return this.isTargetInTrash_;
    }

    private List<TaxonomyTreeData> getAllTaxonomyTreeList() throws RepositoryException {
        ArrayList<TaxonomyTreeData> lstTaxonomyTreeData = new ArrayList<TaxonomyTreeData>();
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        List lstTaxonomyTreeNode = taxonomyService.getAllTaxonomyTrees();
        if (lstTaxonomyTreeNode != null && lstTaxonomyTreeNode.size() > 0) {
            for (Node node : lstTaxonomyTreeNode) {
                lstTaxonomyTreeData.add(this.setData(node));
            }
        }
        return lstTaxonomyTreeData;
    }

    private TaxonomyTreeData setData(Node node) {
        TaxonomyTreeData taxonomyTreeData;
        block9: {
            taxonomyTreeData = null;
            TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
            try {
                StringBuffer buffer;
                block10: {
                    if (node == null) break block9;
                    taxonomyTreeData = new TaxonomyTreeData();
                    taxonomyTreeData.setTaxoTreeName(node.getName());
                    if (org.exoplatform.ecm.webui.utils.Utils.isInTrash((Node)node)) {
                        taxonomyTreeData.setEdit(false);
                        this.isTargetInTrash_ = true;
                    } else {
                        taxonomyTreeData.setEdit(true);
                    }
                    taxonomyTreeData.setTaxoTreeHomePath(node.getPath());
                    taxonomyTreeData.setTaxoTreeWorkspace(node.getSession().getWorkspace().getName());
                    Node realTreeNode = taxonomyService.getTaxonomyTree(node.getName(), true);
                    Value[] values = realTreeNode.getProperty("exo:permissions").getValues();
                    buffer = new StringBuffer(1024);
                    try {
                        for (Value permission : values) {
                            buffer.append(permission.getString()).append(';');
                        }
                    }
                    catch (ValueFormatException e) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)e.getMessage());
                        }
                    }
                    catch (RepositoryException e) {
                        if (!LOG.isWarnEnabled()) break block10;
                        LOG.warn((Object)e.getMessage());
                    }
                }
                String permission = buffer.toString();
                taxonomyTreeData.setTaxoTreePermissions(permission.substring(0, permission.length() - 1));
            }
            catch (RepositoryException e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return taxonomyTreeData;
    }

    public static class EditTaxonomyTreeActionListener
    extends EventListener<UITaxonomyTreeList> {
        public void execute(Event<UITaxonomyTreeList> event) throws Exception {
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)((UITaxonomyTreeList)((Object)event.getSource())).getParent();
            uiTaxonomyManagerTrees.removeChildById(UITaxonomyTreeList.ST_ADD);
            uiTaxonomyManagerTrees.initPopupTreeContainer(UITaxonomyTreeList.ST_EDIT);
            UITaxonomyTreeContainer uiTaxoTreeContainer = (UITaxonomyTreeContainer)uiTaxonomyManagerTrees.findFirstComponentOfType(UITaxonomyTreeContainer.class);
            String taxoTreeName = event.getRequestContext().getRequestParameter("objectId");
            String repository = ((UIECMAdminPortlet)uiTaxonomyManagerTrees.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            TaxonomyTreeData taxoTreeData = new TaxonomyTreeData();
            taxoTreeData.setTaxoTreeName(taxoTreeName);
            taxoTreeData.setEdit(true);
            taxoTreeData.setRepository(repository);
            uiTaxoTreeContainer.setTaxonomyTreeData(taxoTreeData);
            uiTaxoTreeContainer.refresh();
            uiTaxoTreeContainer.viewStep(4);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    public static class AddTaxonomyTreeActionListener
    extends EventListener<UITaxonomyTreeList> {
        public void execute(Event<UITaxonomyTreeList> event) throws Exception {
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)((UITaxonomyTreeList)((Object)event.getSource())).getParent();
            uiTaxonomyManagerTrees.removeChildById(UITaxonomyTreeList.ST_EDIT);
            uiTaxonomyManagerTrees.initPopupTreeContainer(UITaxonomyTreeList.ST_ADD);
            UITaxonomyTreeContainer uiForm = (UITaxonomyTreeContainer)uiTaxonomyManagerTrees.findFirstComponentOfType(UITaxonomyTreeContainer.class);
            uiForm.refresh();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    public static class DeleteActionListener
    extends EventListener<UITaxonomyTreeList> {
        public void execute(Event<UITaxonomyTreeList> event) throws Exception {
            UITaxonomyTreeList uiTaxonomyTreeList = (UITaxonomyTreeList)((Object)event.getSource());
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeList.getParent();
            String taxoTreeName = event.getRequestContext().getRequestParameter("objectId");
            String repository = ((UIECMAdminPortlet)uiTaxonomyTreeList.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            TaxonomyService taxonomyService = (TaxonomyService)uiTaxonomyTreeList.getApplicationComponent(TaxonomyService.class);
            ActionServiceContainer actionService = (ActionServiceContainer)uiTaxonomyTreeList.getApplicationComponent(ActionServiceContainer.class);
            UIApplication uiApp = (UIApplication)uiTaxonomyTreeList.getAncestorOfType(UIApplication.class);
            try {
                Node taxonomyTreeNode = taxonomyService.getTaxonomyTree(taxoTreeName, true);
                actionService.removeAction(taxonomyTreeNode, repository);
                taxonomyService.removeTaxonomyTree(taxoTreeName);
                Utils.addEditedConfiguredData((String)taxoTreeName, (String)"TaxonomyTree", (String)"EditedConfiguredTaxonomyTree", (boolean)true);
            }
            catch (RepositoryException e) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeList.msg.remove-exception", null, 1));
                return;
            }
            uiTaxonomyManagerTrees.update();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }
}

