/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UIAnyPermission;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.organization.UIGroupMembershipSelector;

@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/ecm/webui/UIMemberSelector.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={SelectMembershipActionListener.class}), @EventConfig(listeners={SelectPathActionListener.class}), @EventConfig(listeners={AddAnyPermissionActionListener.class})}), @ComponentConfig(type=UITree.class, id="UITreeGroupSelector", template="system:/groovy/webui/core/UITree.gtmpl", events={@EventConfig(listeners={UITree.ChangeNodeActionListener.class})}), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbGroupSelector", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={UIBreadcumbs.SelectPathActionListener.class})})})
public class UIPermissionSelector
extends UIGroupMembershipSelector
implements ComponentSelector {
    public static final String defaultValue = "/admin";
    private UIComponent uiComponent;
    private String returnFieldName = null;
    private boolean isSelectedMembership = true;
    private boolean isSelectedUser;
    private boolean isUsePopup = true;
    private boolean isShowAnyPermission = true;

    public UIPermissionSelector() throws Exception {
        this.changeGroup(defaultValue);
        this.addChild(UIAnyPermission.class, null, null);
    }

    public void setCurrentPermission(String per) throws Exception {
        this.changeGroup(per);
    }

    @Override
    public UIComponent getSourceComponent() {
        return this.uiComponent;
    }

    public String getReturnField() {
        return this.returnFieldName;
    }

    public void setIsUsePopup(boolean isUsePopup) {
        this.isUsePopup = isUsePopup;
    }

    public boolean isUsePopup() {
        return this.isUsePopup;
    }

    @Override
    public void setSourceComponent(UIComponent uicomponent, String[] initParams) {
        this.uiComponent = uicomponent;
        if (initParams == null || initParams.length == 0) {
            return;
        }
        for (int i = 0; i < initParams.length; ++i) {
            if (initParams[i].indexOf("returnField") > -1) {
                String[] array = initParams[i].split("=");
                this.returnFieldName = array[1];
                break;
            }
            this.returnFieldName = initParams[0];
        }
    }

    public void setSelectedUser(boolean bool) {
        this.isSelectedUser = bool;
    }

    public boolean isSelectedUser() {
        return this.isSelectedUser;
    }

    public void setSelectedMembership(boolean bool) {
        this.isSelectedMembership = bool;
    }

    public boolean isSelectedMembership() {
        return this.isSelectedMembership;
    }

    public List getUsers() throws Exception {
        ArrayList<User> children = new ArrayList<User>();
        OrganizationService service = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
        ListAccess userPageList = service.getUserHandler().findUsersByGroupId(this.getCurrentGroup().getId());
        for (User child : (User[])userPageList.load(0, userPageList.getSize())) {
            children.add(child);
        }
        return children;
    }

    public boolean isShowAnyPermission() {
        return this.isShowAnyPermission;
    }

    public void setShowAnyPermission(boolean isShowAnyPermission) {
        this.isShowAnyPermission = isShowAnyPermission;
    }

    public List<String> getListGroup() throws Exception {
        OrganizationService service = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
        ArrayList<String> listGroup = new ArrayList<String>();
        if (this.getCurrentGroup() == null) {
            return null;
        }
        Collection groups = service.getGroupHandler().findGroups(this.getCurrentGroup());
        if (groups.size() > 0) {
            for (Object child : groups) {
                Group childGroup = (Group)child;
                listGroup.add(childGroup.getId());
            }
        }
        return listGroup;
    }

    public static class AddAnyPermissionActionListener
    extends EventListener<UIAnyPermission> {
        public void execute(Event<UIAnyPermission> event) throws Exception {
            UIAnyPermission uiAnyPermission = (UIAnyPermission)((Object)event.getSource());
            UIPermissionSelector uiPermissionSelector = (UIPermissionSelector)uiAnyPermission.getParent();
            String returnField = uiPermissionSelector.getReturnField();
            String value = "*";
            ((UISelectable)uiPermissionSelector.getSourceComponent()).doSelect(returnField, value);
            if (uiPermissionSelector.isUsePopup()) {
                UIPopupWindow uiPopup = (UIPopupWindow)uiPermissionSelector.getParent();
                uiPopup.setShow(false);
                UIComponent uicomp = uiPermissionSelector.getSourceComponent().getParent();
                event.getRequestContext().addUIComponentToUpdateByAjax(uicomp);
                if (!uiPopup.getId().equals("PopupComponent")) {
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
                }
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiPermissionSelector.getSourceComponent());
            }
        }
    }

    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            UIPermissionSelector uiPermissionSelector = (UIPermissionSelector)uiBreadcumbs.getParent();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiBreadcumbs.setSelectPath(objectId);
            String selectGroupId = uiBreadcumbs.getSelectLocalPath().getId();
            uiPermissionSelector.changeGroup(selectGroupId);
            if (uiPermissionSelector.isUsePopup) {
                UIPopupWindow uiPopup = (UIPopupWindow)uiBreadcumbs.getAncestorOfType(UIPopupWindow.class);
                uiPopup.setShow(true);
                uiPopup.setShowMask(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPermissionSelector);
        }
    }

    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            UIPermissionSelector uiPermissionSelector = (UIPermissionSelector)((UITree)event.getSource()).getParent();
            String groupId = event.getRequestContext().getRequestParameter("objectId");
            uiPermissionSelector.changeGroup(groupId);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPermissionSelector);
        }
    }

    public static class SelectMembershipActionListener
    extends EventListener<UIPermissionSelector> {
        public void execute(Event<UIPermissionSelector> event) throws Exception {
            UIPermissionSelector uiPermissionSelector = (UIPermissionSelector)event.getSource();
            if (uiPermissionSelector.getCurrentGroup() == null) {
                return;
            }
            String groupId = uiPermissionSelector.getCurrentGroup().getId();
            String permission = event.getRequestContext().getRequestParameter("objectId");
            String value = "";
            value = uiPermissionSelector.isSelectedUser() ? permission : permission + ":" + groupId;
            String returnField = uiPermissionSelector.getReturnField();
            ((UISelectable)uiPermissionSelector.getSourceComponent()).doSelect(returnField, value);
            if (uiPermissionSelector.isUsePopup) {
                UIPopupWindow uiPopup = (UIPopupWindow)uiPermissionSelector.getParent();
                uiPopup.setShow(false);
                uiPopup.setRendered(false);
                UIComponent uicomp = uiPermissionSelector.getSourceComponent().getParent();
                event.getRequestContext().addUIComponentToUpdateByAjax(uicomp);
                if (!uiPopup.getId().equals("PopupComponent")) {
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
                }
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiPermissionSelector.getSourceComponent());
            }
        }
    }
}

