/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.clipboard.ClipboardService;
import org.exoplatform.services.cms.clipboard.jcr.model.ClipboardCommand;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(events={@EventConfig(listeners={CopyActionListener.class})})
public class CopyManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsNotTrashHomeNodeFilter()});
    private static final Log LOG = ExoLogger.getLogger((String)CopyManageComponent.class.getName());

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static void multipleCopy(String[] srcPaths, Event<UIComponent> event) throws Exception {
        for (int i = 0; i < srcPaths.length; ++i) {
            CopyManageComponent.processCopy(srcPaths[i], event, true);
        }
    }

    public static void processCopy(String srcPath, Event<?> event, boolean isMultiSelect) throws Exception {
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((UIComponent)event.getSource()).getParent();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)uiWorkingArea.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiWorkingArea.getAncestorOfType(UIApplication.class);
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(srcPath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + srcPath + "'");
        }
        wsName = matcher.group(1);
        srcPath = matcher.group(2);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        try {
            Node node = uiExplorer.getNodeByPath(srcPath, session, false);
            srcPath = node.getPath();
            session = node.getSession();
            wsName = session.getWorkspace().getName();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            return;
        }
        ClipboardCommand clipboard = new ClipboardCommand("copy", srcPath, wsName);
        ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        clipboardService.addClipboardCommand(userId, clipboard, false);
        if (isMultiSelect) {
            clipboardService.addClipboardCommand(userId, clipboard, true);
        }
    }

    public static void copyManage(Event<UIComponent> event) throws Exception {
        String srcPath = event.getRequestContext().getRequestParameter("objectId");
        ClipboardService clipboardService = (ClipboardService)WCMCoreUtils.getService(ClipboardService.class);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        clipboardService.clearClipboardList(userId, true);
        if (srcPath.indexOf(";") > -1) {
            CopyManageComponent.multipleCopy(Utils.removeChildNodes((String)srcPath), event);
        } else {
            CopyManageComponent.processCopy(srcPath, event, false);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class CopyActionListener
    extends UIWorkingAreaActionListener<CopyManageComponent> {
        public void processEvent(Event<CopyManageComponent> event) throws Exception {
            Event event_ = new Event(event.getSource(), event.getName(), event.getRequestContext());
            CopyManageComponent.copyManage((Event<UIComponent>)event_);
        }
    }
}

