/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.HttpMethod;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.DriveItem;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IDriveItemRequest;

public class DriveItemRequest
extends BaseRequest
implements IDriveItemRequest {
    public DriveItemRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveItem.class);
    }

    @Override
    public void get(ICallback<DriveItem> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public DriveItem get() throws ClientException {
        return (DriveItem)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<DriveItem> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(DriveItem sourceDriveItem, ICallback<DriveItem> callback) {
        this.send(HttpMethod.PATCH, callback, sourceDriveItem);
    }

    @Override
    public DriveItem patch(DriveItem sourceDriveItem) throws ClientException {
        return (DriveItem)this.send(HttpMethod.PATCH, sourceDriveItem);
    }

    @Override
    public void post(DriveItem newDriveItem, ICallback<DriveItem> callback) {
        this.send(HttpMethod.POST, callback, newDriveItem);
    }

    @Override
    public DriveItem post(DriveItem newDriveItem) throws ClientException {
        return (DriveItem)this.send(HttpMethod.POST, newDriveItem);
    }

    @Override
    public IDriveItemRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveItemRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

