/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions;

import java.util.List;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.ICallback;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.concurrency.IExecutors;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.ClientException;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.core.IBaseClient;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.http.BaseCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.models.extensions.MailFolder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.Option;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.options.QueryOption;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IMailFolderCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.IMailFolderCollectionRequest;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MailFolderCollectionPage;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MailFolderCollectionRequestBuilder;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MailFolderCollectionResponse;
import org.exoplatform.services.cms.clouddrives.onedrive.shaded.microsoft.graph.requests.extensions.MailFolderRequestBuilder;

public class MailFolderCollectionRequest
extends BaseCollectionRequest<MailFolderCollectionResponse, IMailFolderCollectionPage>
implements IMailFolderCollectionRequest {
    public MailFolderCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MailFolderCollectionResponse.class, IMailFolderCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMailFolderCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MailFolderCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMailFolderCollectionPage get() throws ClientException {
        MailFolderCollectionResponse response = (MailFolderCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MailFolder newMailFolder, ICallback<MailFolder> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MailFolderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMailFolder, callback);
    }

    @Override
    public MailFolder post(MailFolder newMailFolder) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MailFolderRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newMailFolder);
    }

    @Override
    public IMailFolderCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IMailFolderCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMailFolderCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IMailFolderCollectionPage buildFromResponse(MailFolderCollectionResponse response) {
        MailFolderCollectionRequestBuilder builder = response.nextLink != null ? new MailFolderCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MailFolderCollectionPage page = new MailFolderCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

