/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.indexing.listener;

import java.util.HashMap;
import javax.jcr.Node;
import org.exoplatform.commons.api.indexing.IndexingService;
import org.exoplatform.commons.api.indexing.data.SearchEntry;
import org.exoplatform.commons.api.indexing.data.SearchEntryId;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UnifiedSearchContentListener
extends Listener {
    private static Log log = ExoLogger.getLogger(UnifiedSearchContentListener.class);
    private final IndexingService indexingService;

    public UnifiedSearchContentListener(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    public void onEvent(Event event) throws Exception {
        if (this.indexingService != null) {
            if ("CmsService.event.postCreate".equals(event.getEventName())) {
                HashMap<String, Node> content = new HashMap<String, Node>();
                Node contentNode = (Node)event.getData();
                content.put("content", contentNode);
                SearchEntry searchEntry = new SearchEntry("content", contentNode.getPrimaryNodeType().getName().equals("nt:file") ? "file" : "document", contentNode.getUUID(), content);
                this.indexingService.add(searchEntry);
            } else if ("CmsService.event.postEdit".equals(event.getEventName())) {
                HashMap<String, Node> content = new HashMap<String, Node>();
                Node contentNode = (Node)event.getData();
                content.put("content", contentNode);
                SearchEntryId searchEntryId = new SearchEntryId("content", contentNode.getPrimaryNodeType().getName().equals("nt:file") ? "file" : "document", contentNode.getUUID());
                this.indexingService.update(searchEntryId, content);
            }
        }
    }
}

