/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.queries;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.queries.UIQueriesForm;
import org.exoplatform.ecm.webui.component.admin.queries.UIQueriesManager;
import org.exoplatform.ecm.webui.core.UIPagingGridDecorator;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/admin/queries/UIQueriesList.gtmpl", events={@EventConfig(listeners={AddQueryActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIQueriesList.msg.confirm-delete")})
public class UIQueriesList
extends UIPagingGridDecorator {
    private static final Log LOG = ExoLogger.getLogger((String)UIQueriesList.class.getName());
    public static final String[] ACTIONS = new String[]{"AddQuery"};
    public static final String ST_ADD = "AddQueryForm";
    public static final String ST_EDIT = "EditQueryForm";

    public UIQueriesList() throws Exception {
        this.getUIPageIterator().setId("QueriesListIterator");
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void refresh(int currentPage) throws Exception {
        ListAccessImpl sharedQueryList = new ListAccessImpl(Object.class, NodeLocation.getLocationsByNodeList(this.getAllSharedQueries()));
        LazyPageList pageList = new LazyPageList((ListAccess)sharedQueryList, this.getUIPageIterator().getItemsPerPage());
        this.getUIPageIterator().setPageList((PageList)pageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public boolean canEditNode(Node node) {
        SessionProvider sProvider = WCMCoreUtils.getSystemSessionProvider();
        try {
            ManageableRepository manageableRepository = (ManageableRepository)node.getSession().getRepository();
            Session session = sProvider.getSession(node.getSession().getWorkspace().getName(), manageableRepository);
            session.checkPermission(node.getPath(), "set_property");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean canRemoveNode(Node node) {
        SessionProvider sProvider = WCMCoreUtils.getSystemSessionProvider();
        try {
            ManageableRepository manageableRepository = (ManageableRepository)node.getSession().getRepository();
            Session session = sProvider.getSession(node.getSession().getWorkspace().getName(), manageableRepository);
            session.checkPermission(node.getPath(), "remove");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public List getQueryList() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.getUIPageIterator().getCurrentPageData());
    }

    public List<Node> getAllSharedQueries() throws Exception {
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        List queries = queryService.getSharedQueries(WCMCoreUtils.getSystemSessionProvider());
        Collections.sort(queries, new QueryComparator());
        return queries;
    }

    public static class DeleteActionListener
    extends EventListener<UIQueriesList> {
        public void execute(Event<UIQueriesList> event) throws Exception {
            UIQueriesList uiQueriesList = (UIQueriesList)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiQueriesList.getAncestorOfType(UIApplication.class);
            UIQueriesManager uiQueriesMan = (UIQueriesManager)((UIQueriesList)((Object)event.getSource())).getParent();
            String userName = Util.getPortalRequestContext().getRemoteUser();
            String queryName = event.getRequestContext().getRequestParameter("objectId");
            QueryService queryService = (QueryService)((UIQueriesList)((Object)event.getSource())).getApplicationComponent(QueryService.class);
            try {
                queryService.removeQuery(queryName, userName);
            }
            catch (PathNotFoundException pe) {
                uiApp.addMessage(new ApplicationMessage("UIQueriesList.msg.query-not-existed", null, 1));
                return;
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"cannot remove the query", (Throwable)ex);
                }
                uiApp.addMessage(new ApplicationMessage("UIQueriesList.msg.can-not-remove", null, 0));
                return;
            }
            ((UIQueriesList)((Object)event.getSource())).refresh(uiQueriesList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiQueriesMan);
        }
    }

    public static class EditActionListener
    extends EventListener<UIQueriesList> {
        public void execute(Event<UIQueriesList> event) throws Exception {
            UIQueriesManager uiQueriesMan = (UIQueriesManager)((UIQueriesList)((Object)event.getSource())).getParent();
            uiQueriesMan.removeChildById(UIQueriesList.ST_ADD);
            uiQueriesMan.initFormPopup(UIQueriesList.ST_EDIT);
            String queryPath = event.getRequestContext().getRequestParameter("objectId");
            UIQueriesForm uiForm = (UIQueriesForm)uiQueriesMan.findFirstComponentOfType(UIQueriesForm.class);
            String queryName = queryPath.substring(queryPath.lastIndexOf("/") + 1);
            uiForm.update(queryName);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiQueriesMan);
        }
    }

    public static class AddQueryActionListener
    extends EventListener<UIQueriesList> {
        public void execute(Event<UIQueriesList> event) throws Exception {
            UIQueriesManager uiQueriesMan = (UIQueriesManager)((UIQueriesList)((Object)event.getSource())).getParent();
            uiQueriesMan.removeChildById(UIQueriesList.ST_EDIT);
            uiQueriesMan.initFormPopup(UIQueriesList.ST_ADD);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiQueriesMan);
        }
    }

    public static class QueryComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            try {
                String name1 = ((Node)o1).getName();
                String name2 = ((Node)o2).getName();
                return name1.compareToIgnoreCase(name2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

