/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIShareDocuments;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIWhoHasAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="war:/groovy/ecm/social-integration/share-document/UIWhoHasAccessEntry.gtmpl", events={@EventConfig(listeners={RemoveEntryActionListener.class}), @EventConfig(listeners={ChangeEntryActionListener.class})})
public class UIWhoHasAccessEntry
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIWhoHasAccessEntry.class);
    private static final String SHARE_PERMISSION_VIEW = "read";
    private static final String SHARE_PERMISSION_MODIFY = "modify";
    private static final String SPACE_PREFIX1 = "space::";
    private static final String SPACE_PREFIX2 = "*:/spaces/";
    private boolean permissionDropDown = false;
    private String name;
    private String permission;

    public boolean hasPermissionDropDown() {
        return this.permissionDropDown;
    }

    public void setPermissionDropDown(boolean permissionDropDown) {
        this.permissionDropDown = permissionDropDown;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getPermission() {
        return this.permission;
    }

    public void init(String id, String permission) {
        block2: {
            try {
                this.setName(id);
                this.setPermission(permission);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class ChangeEntryActionListener
    extends EventListener<UIWhoHasAccessEntry> {
        public void execute(Event<UIWhoHasAccessEntry> event) throws Exception {
            UIWhoHasAccessEntry uiform = (UIWhoHasAccessEntry)((Object)event.getSource());
            if (!uiform.getPermission().equals(UIWhoHasAccessEntry.SHARE_PERMISSION_MODIFY)) {
                uiform.setPermission(UIWhoHasAccessEntry.SHARE_PERMISSION_MODIFY);
            } else {
                uiform.setPermission(UIWhoHasAccessEntry.SHARE_PERMISSION_VIEW);
            }
            UIWhoHasAccess uiWhoHasAccess = (UIWhoHasAccess)uiform.getParent();
            uiWhoHasAccess.updateEntry(uiform.getId(), uiform.getPermission());
            event.getRequestContext().getJavascriptManager().require("SHARED/share-content", "shareContent").addScripts("eXo.ecm.ShareContent.checkUpdatedEntry();");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiform.getParent().getParent());
        }
    }

    public static class RemoveEntryActionListener
    extends EventListener<UIWhoHasAccessEntry> {
        public void execute(Event<UIWhoHasAccessEntry> event) throws Exception {
            String user;
            UIWhoHasAccessEntry uiform = (UIWhoHasAccessEntry)((Object)event.getSource());
            UIWhoHasAccess uiWhoHasAccess = (UIWhoHasAccess)uiform.getParent();
            UIShareDocuments uiShareDocuments = (UIShareDocuments)uiWhoHasAccess.getParent();
            if (uiShareDocuments.isOwner(user = ConversationState.getCurrent().getIdentity().getUserId()) || uiShareDocuments.getNode().getACL().getPermissions(user).contains("remove")) {
                if (!user.equals(uiform.getId())) {
                    uiWhoHasAccess.removeEntry(uiform.getId());
                } else {
                    UIApplication uiApp = (UIApplication)uiShareDocuments.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.InvalidDeletion", null, 1));
                }
            } else {
                UIApplication uiApp = (UIApplication)uiShareDocuments.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIShareDocuments.label.NoPermissionDelete", null, 1));
            }
            event.getRequestContext().getJavascriptManager().require("SHARED/share-content", "shareContent").addScripts("eXo.ecm.ShareContent.checkUpdatedEntry();");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiShareDocuments);
        }
    }
}

