/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.services.cms.documents.DocumentMetadataPlugin;
import org.exoplatform.services.cms.documents.exception.DocumentExtensionNotSupportedException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;

public class ApachePOIMetadataPlugin
extends BaseComponentPlugin
implements DocumentMetadataPlugin {
    private static final String PPTX_EXTENSION = ".pptx";
    private static final String XLSX_EXTENSION = ".xlsx";
    private static final String DOCX_EXTENSION = ".docx";
    private static final List<String> SUPPORTED_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".docx", ".xlsx", ".pptx"));
    private final SimpleDateFormat metadataFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final Log LOG = ExoLogger.getLogger(ApachePOIMetadataPlugin.class);

    public ApachePOIMetadataPlugin() {
        this.metadataFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public InputStream updateMetadata(WebuiRequestContext context, String extension, InputStream source, Date created, String creator, String language) throws IOException, DocumentExtensionNotSupportedException {
        File tempFile = File.createTempFile("editor-document", ".tmp");
        try (POIXMLDocument document = this.getDocument(source, extension);
             FileOutputStream fos = new FileOutputStream(tempFile);){
            this.updateDocLanguage(context, document, extension, language);
            POIXMLProperties props = document.getProperties();
            POIXMLProperties.CoreProperties coreProps = props.getCoreProperties();
            coreProps.setCreator(creator);
            coreProps.getUnderlyingProperties().setLanguageProperty(language);
            coreProps.setCreated(this.metadataFormat.format(created));
            document.write((OutputStream)fos);
        }
        return new DeleteOnCloseFileInputStream(tempFile);
    }

    private void updateDocLanguage(WebuiRequestContext context, POIXMLDocument document, String extension, String language) {
        if (StringUtils.equals((String)extension, (String)DOCX_EXTENSION)) {
            ((XWPFDocument)document).getStyles().getStyle("Normal").getCTStyle().getRPr().getLang().setVal((Object)language);
        } else if (StringUtils.equals((String)extension, (String)XLSX_EXTENSION)) {
            ResourceBundle resourceBundle = context.getApplicationResourceBundle();
            String newSheetLabel = resourceBundle.getString("UINewDocumentForm.label.option.MicrosoftOfficeNewSheet");
            ((XSSFWorkbook)document).getCTWorkbook().getSheets().getSheetList().stream().forEach(sheet -> sheet.setName(newSheetLabel + sheet.getSheetId()));
        } else if (StringUtils.equals((String)extension, (String)PPTX_EXTENSION)) {
            ((XMLSlideShow)document).getCTPresentation().getDefaultTextStyle().getDefPPr().getDefRPr().setLang(language);
            ((XSLFSlide)((XMLSlideShow)document).getSlides().get(0)).getXmlObject().getCSld().getSpTree().getSpList().forEach(splist -> {
                if (splist.getTxBody() != null) {
                    splist.getTxBody().getPArray(0).getEndParaRPr().setLang(language);
                }
            });
        }
    }

    @Override
    public List<String> getSupportedExtensions() {
        return SUPPORTED_EXTENSIONS;
    }

    @Override
    public boolean isExtensionSupported(String extension) {
        return SUPPORTED_EXTENSIONS.contains(extension);
    }

    protected POIXMLDocument getDocument(InputStream source, String extension) throws DocumentExtensionNotSupportedException, IOException {
        if (extension == null) {
            throw new DocumentExtensionNotSupportedException("Cannot provide POIXMLDocument - extension is null");
        }
        switch (extension.toLowerCase()) {
            case ".docx": {
                return new XWPFDocument(source);
            }
            case ".xlsx": {
                return new XSSFWorkbook(source);
            }
            case ".pptx": {
                return new XMLSlideShow(source);
            }
        }
        throw new DocumentExtensionNotSupportedException("The document format " + extension + " is not supported");
    }

    public static class DeleteOnCloseFileInputStream
    extends FileInputStream {
        private File file;

        public DeleteOnCloseFileInputStream(String fileName) throws FileNotFoundException {
            this(new File(fileName));
        }

        public DeleteOnCloseFileInputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                if (this.file != null) {
                    this.file.delete();
                    this.file = null;
                }
            }
        }
    }
}

