/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.jcrext.activity.ActivityCommonService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemDefinitionImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class CmsServiceImpl
implements CmsService {
    private RepositoryService jcrService;
    private IDGeneratorService idGeneratorService;
    private static final String MIX_REFERENCEABLE = "mix:referenceable";
    private static final Log LOG = ExoLogger.getLogger((String)CmsServiceImpl.class.getName());
    private ListenerService listenerService;
    private ActivityCommonService activityService = null;
    public static Map<String, Object> properties = new HashMap<String, Object>();

    @Override
    public Map<String, Object> getPreProperties() {
        return properties;
    }

    public CmsServiceImpl(RepositoryService jcrService, IDGeneratorService idGeneratorService, ListenerService listenerService) {
        this.idGeneratorService = idGeneratorService;
        this.jcrService = jcrService;
        this.listenerService = listenerService;
    }

    @Override
    public String storeNode(String workspace, String nodeTypeName, String storePath, Map mappings) throws Exception {
        Session session = this.jcrService.getCurrentRepository().login(workspace);
        Node storeHomeNode = (Node)session.getItem(storePath);
        String path = this.storeNode(nodeTypeName, storeHomeNode, mappings, true);
        storeHomeNode.save();
        session.logout();
        return path;
    }

    @Override
    public String storeNode(String nodeTypeName, Node storeHomeNode, Map mappings, boolean isAddNew) throws Exception {
        Set keys = mappings.keySet();
        String nodePath = this.extractNodeName(keys);
        JcrInputProperty relRootProp = (JcrInputProperty)mappings.get(nodePath);
        String nodeName = (String)relRootProp.getValue();
        if (nodeName == null || nodeName.length() == 0) {
            nodeName = this.idGeneratorService.generateStringID((Object)nodeTypeName);
        }
        nodeName = Text.escapeIllegalJcrChars(nodeName);
        String primaryType = relRootProp.getNodetype();
        if (primaryType == null || primaryType.length() == 0) {
            primaryType = nodeTypeName;
        }
        Session session = storeHomeNode.getSession();
        NodeTypeManager nodetypeManager = session.getWorkspace().getNodeTypeManager();
        NodeType nodeType = nodetypeManager.getNodeType(primaryType);
        Node currentNode = null;
        String[] mixinTypes = null;
        String mixintypeName = relRootProp.getMixintype();
        if (mixintypeName != null && mixintypeName.trim().length() > 0) {
            mixinTypes = mixintypeName.indexOf(",") > -1 ? mixintypeName.split(",") : new String[]{mixintypeName};
        }
        if (this.activityService == null) {
            this.activityService = WCMCoreUtils.getService(ActivityCommonService.class);
        }
        if (isAddNew) {
            this.listenerService.broadcast("CmsService.event.preCreate", (Object)storeHomeNode, (Object)mappings);
            currentNode = storeHomeNode.addNode(nodeName, primaryType);
            this.activityService.setCreating(currentNode, true);
            this.createNodeRecursively("/node", currentNode, nodeType, mappings);
            this.createNodeRecursively("/node", currentNode, nodetypeManager.getNodeType("exo:sortable"), mappings);
            if (mixinTypes != null) {
                for (String type : mixinTypes) {
                    if (!currentNode.isNodeType(type)) {
                        currentNode.addMixin(type);
                    }
                    NodeType mixinType = nodetypeManager.getNodeType(type);
                    for (String keyJCRPath : keys) {
                        JcrInputProperty jcrInputProperty = (JcrInputProperty)mappings.get(keyJCRPath);
                        if (jcrInputProperty.getJcrPath().equals("/node")) continue;
                        String inputMixinTypeName = jcrInputProperty.getMixintype();
                        String[] inputMixinTypes = null;
                        if (inputMixinTypeName != null && inputMixinTypeName.trim().length() > 0) {
                            inputMixinTypes = inputMixinTypeName.indexOf(",") > -1 ? inputMixinTypeName.split(",") : new String[]{inputMixinTypeName};
                        }
                        if (inputMixinTypes == null) continue;
                        for (String inputType : inputMixinTypes) {
                            String childPath;
                            if (!inputType.equals(type) || !currentNode.hasNode(childPath = jcrInputProperty.getJcrPath().replaceAll("/node/", ""))) continue;
                            this.createNodeRecursively(jcrInputProperty.getJcrPath(), currentNode.getNode(childPath), mixinType, mappings);
                        }
                    }
                    this.createNodeRecursively("/node", currentNode, mixinType, mappings);
                }
            }
            if (!currentNode.isNodeType(MIX_REFERENCEABLE)) {
                currentNode.addMixin(MIX_REFERENCEABLE);
            }
            this.listenerService.broadcast("CmsService.event.postCreate", (Object)this, (Object)currentNode);
        } else {
            currentNode = storeHomeNode.getNode(nodeName);
            this.activityService.setEditing(currentNode, true);
            this.listenerService.broadcast("CmsService.event.preEdit", (Object)currentNode, (Object)mappings);
            this.updateNodeRecursively("/node", currentNode, nodeType, mappings);
            if (currentNode.isNodeType("exo:datetime")) {
                currentNode.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
            }
            this.listenerService.broadcast("CmsService.event.postEdit", (Object)this, (Object)currentNode);
        }
        this.activityService.setCreating(currentNode, false);
        if (currentNode.isNodeType(ActivityCommonService.MIX_COMMENT)) {
            currentNode.setProperty(ActivityCommonService.MIX_COMMENT_ACTIVITY_ID, "");
        }
        storeHomeNode.save();
        return currentNode.getPath();
    }

    @Override
    public String storeEditedNode(String nodeTypeName, Node storeNode, Map mappings, boolean isAddNew) throws Exception {
        Set keys = mappings.keySet();
        String nodePath = this.extractNodeName(keys);
        JcrInputProperty relRootProp = (JcrInputProperty)mappings.get(nodePath);
        String primaryType = relRootProp.getNodetype();
        if (primaryType == null || primaryType.length() == 0) {
            primaryType = nodeTypeName;
        }
        Session session = storeNode.getSession();
        NodeTypeManager nodetypeManager = session.getWorkspace().getNodeTypeManager();
        NodeType nodeType = nodetypeManager.getNodeType(primaryType);
        this.listenerService.broadcast("CmsService.event.preEdit", (Object)storeNode, (Object)mappings);
        this.updateNodeRecursively("/node", storeNode, nodeType, mappings);
        if (storeNode.isNodeType("exo:datetime")) {
            storeNode.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
        }
        this.listenerService.broadcast("CmsService.event.postEdit", (Object)this, (Object)storeNode);
        storeNode.save();
        return storeNode.getPath();
    }

    @Override
    public String storeNodeByUUID(String nodeTypeName, Node storeHomeNode, Map mappings, boolean isAddNew) throws Exception {
        String currentNodePath;
        String primaryType;
        Set keys = mappings.keySet();
        String nodePath = this.extractNodeName(keys);
        JcrInputProperty relRootProp = (JcrInputProperty)mappings.get(nodePath);
        String nodeName = (String)relRootProp.getValue();
        if (nodeName == null || nodeName.length() == 0) {
            nodeName = this.idGeneratorService.generateStringID((Object)nodeTypeName);
        }
        if ((primaryType = relRootProp.getNodetype()) == null || primaryType.length() == 0) {
            primaryType = nodeTypeName;
        }
        Session session = storeHomeNode.getSession();
        NodeTypeManager nodetypeManager = session.getWorkspace().getNodeTypeManager();
        NodeType nodeType = nodetypeManager.getNodeType(primaryType);
        Node currentNode = null;
        String[] mixinTypes = null;
        String mixintypeName = relRootProp.getMixintype();
        if (mixintypeName != null && mixintypeName.trim().length() > 0) {
            mixinTypes = mixintypeName.indexOf(",") > -1 ? mixintypeName.split(",") : new String[]{mixintypeName};
        }
        if (isAddNew) {
            this.listenerService.broadcast("CmsService.event.preCreate", (Object)storeHomeNode, (Object)mappings);
            currentNode = storeHomeNode.addNode(nodeName, primaryType);
            currentNodePath = currentNode.getPath();
            if (mixinTypes != null) {
                for (String type : mixinTypes) {
                    if (!currentNode.isNodeType(type)) {
                        currentNode.addMixin(type);
                    }
                    NodeType mixinType = nodetypeManager.getNodeType(type);
                    this.createNodeRecursively("/node", currentNode, mixinType, mappings);
                }
            }
            this.createNodeRecursively("/node", currentNode, nodeType, mappings);
            if (!currentNode.isNodeType(MIX_REFERENCEABLE)) {
                currentNode.addMixin(MIX_REFERENCEABLE);
            }
            this.listenerService.broadcast("CmsService.event.postCreate", (Object)this, (Object)currentNode);
        } else {
            currentNode = storeHomeNode.getNode(nodeName);
            currentNodePath = currentNode.getPath();
            this.updateNodeRecursively("/node", currentNode, nodeType, mappings);
            if (currentNode.isNodeType("exo:datetime")) {
                currentNode.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
            }
            this.listenerService.broadcast("CmsService.event.postEdit", (Object)this, (Object)currentNode);
        }
        if (currentNode instanceof NodeImpl && !((NodeImpl)currentNode).isValid()) {
            currentNode = (Node)session.getItem(currentNodePath);
            LinkManager linkManager = WCMCoreUtils.getService(LinkManager.class);
            if (linkManager.isLink((Item)currentNode)) {
                try {
                    currentNode = linkManager.getTarget(currentNode, false);
                }
                catch (Exception ex) {
                    currentNode = linkManager.getTarget(currentNode, true);
                }
            }
        }
        String uuid = currentNode.getUUID();
        storeHomeNode.save();
        return uuid;
    }

    private void updateNodeRecursively(String path, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        this.processNodeRecursively(false, path, currentNode, currentNodeType, jcrVariables);
    }

    private void createNodeRecursively(String path, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        this.processNodeRecursively(true, path, currentNode, currentNodeType, jcrVariables);
    }

    private boolean isAcceptSetValueForAutoCreated(PropertyDefinition propertyDef, String path, Map jcrVariables) {
        if (propertyDef.isAutoCreated()) {
            String propertyName = propertyDef.getName();
            String currentPath = path + "/" + propertyName;
            JcrInputProperty inputVariable = (JcrInputProperty)jcrVariables.get(currentPath);
            return inputVariable != null && inputVariable.getValue() != null;
        }
        return true;
    }

    private void processAddEditProperty(boolean create, Node currentNode, String path, NodeType currentNodeType, Map jcrVariables) throws Exception {
        if (create) {
            PropertyDefinition[] propertyDefs = currentNodeType.getPropertyDefinitions();
            for (int i = 0; i < propertyDefs.length; ++i) {
                PropertyDefinition propertyDef = propertyDefs[i];
                if (!this.isAcceptSetValueForAutoCreated(propertyDef, path, jcrVariables) || propertyDef.isProtected()) continue;
                String propertyName = propertyDef.getName();
                int requiredtype = propertyDef.getRequiredType();
                String currentPath = path + "/" + propertyName;
                JcrInputProperty inputVariable = (JcrInputProperty)jcrVariables.get(currentPath);
                Object value = null;
                if (inputVariable != null) {
                    value = inputVariable.getValue();
                }
                if (value == null && !propertyDef.isMandatory()) continue;
                this.processProperty(propertyName, currentNode, requiredtype, value, propertyDef.isMultiple());
            }
            for (Object key : jcrVariables.keySet()) {
                Object value = jcrVariables.get(key);
                if (!(((JcrInputProperty)value).getValue() instanceof Map)) continue;
                this.processProperty(key.toString().substring(path.length() + 1), currentNode, 2, ((JcrInputProperty)value).getValue(), true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processNodeRecursively(boolean create, String itemPath, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        NodeDefinition[] relRootProp;
        if (create) {
            this.processAddEditProperty(true, currentNode, itemPath, currentNodeType, jcrVariables);
        } else {
            ArrayList<String> keyList = new ArrayList<String>();
            for (Object key : jcrVariables.keySet()) {
                keyList.add(key.toString().substring(key.toString().lastIndexOf("/") + 1));
            }
            ArrayList<String> currentListPropertyName = new ArrayList<String>();
            PropertyIterator pi = currentNode.getProperties();
            while (pi.hasNext()) {
                Property property = pi.nextProperty();
                currentListPropertyName.add(property.getName());
            }
            Set keys = jcrVariables.keySet();
            String nodePath = this.extractNodeName(keys);
            relRootProp = (NodeDefinition[])jcrVariables.get(nodePath);
            String[] mixinTypes = new String[]{};
            String string = relRootProp.getMixintype();
            if (string != null && string.trim().length() > 0) {
                mixinTypes = string.indexOf(",") > -1 ? string.split(",") : new String[]{string};
            }
            for (String mixinType : mixinTypes) {
                if (currentNode.isNodeType(mixinType) || !currentNode.canAddMixin(mixinType)) continue;
                currentNode.addMixin(mixinType);
            }
            PropertyDefinition[] propertyDefs = currentNodeType.getPropertyDefinitions();
            List<PropertyDefinition> list = Arrays.asList(propertyDefs);
            ArrayList<PropertyDefinition> lstPropertyDefinitionAll = new ArrayList<PropertyDefinition>();
            NodeType[] mixinNodeTypes = currentNode.getMixinNodeTypes();
            lstPropertyDefinitionAll.addAll(list);
            for (NodeType mixinNodeType : mixinNodeTypes) {
                Collections.addAll(lstPropertyDefinitionAll, mixinNodeType.getPropertyDefinitions());
            }
            for (PropertyDefinition propertyDef : lstPropertyDefinitionAll) {
                String propertyName = propertyDef.getName();
                Object value = null;
                String currentPath = itemPath + "/" + propertyName;
                JcrInputProperty inputVariable = (JcrInputProperty)jcrVariables.get(currentPath);
                if (inputVariable != null) {
                    value = inputVariable.getValue();
                }
                if (currentListPropertyName.contains(propertyName) && currentNode.hasProperty(propertyName)) {
                    Property property = currentNode.getProperty(propertyName);
                    int requiredtype = property.getType();
                    if (!keyList.contains(propertyName) || propertyDef.isProtected()) continue;
                    this.processProperty(property, currentNode, requiredtype, value, propertyDef.isMultiple());
                    continue;
                }
                if (propertyDef.isProtected()) continue;
                int requiredtype = propertyDef.getRequiredType();
                if (value == null && !propertyDef.isMandatory()) continue;
                this.processProperty(propertyName, currentNode, requiredtype, value, propertyDef.isMultiple());
            }
            for (Object key : jcrVariables.keySet()) {
                Object value = jcrVariables.get(key);
                if (!(((JcrInputProperty)value).getValue() instanceof Map)) continue;
                this.processProperty(key.toString().substring(itemPath.length() + 1), currentNode, 2, ((JcrInputProperty)value).getValue(), true);
            }
        }
        int itemLevel = StringUtils.countMatches((String)itemPath, (String)"/");
        List<JcrInputProperty> childNodeInputs = this.extractNodeInputs(jcrVariables, itemLevel + 1);
        NodeTypeManager nodeTypeManger = currentNode.getSession().getWorkspace().getNodeTypeManager();
        ArrayList<Object> childs = new ArrayList<Object>();
        if (currentNodeType.isMixin()) {
            if (create) {
                void var12_17;
                relRootProp = currentNodeType.getChildNodeDefinitions();
                int mixinTypes = relRootProp.length;
                boolean bl = false;
                while (var12_17 < mixinTypes) {
                    NodeDefinition childNodeDef = relRootProp[var12_17];
                    childs.add(childNodeDef);
                    ++var12_17;
                }
            } else {
                NodeIterator iterator = currentNode.getNodes();
                while (iterator.hasNext()) {
                    childs.add(iterator.nextNode());
                }
            }
        } else {
            HashSet<CallSite> childNames = new HashSet<CallSite>();
            for (String string : currentNodeType.getChildNodeDefinitions()) {
                childs.add(string);
                NodeType declaringNodeType = string.getDeclaringNodeType();
                NodeType defaultPrimaryType = string.getDefaultPrimaryType();
                childNames.add((CallSite)((Object)(string.getName() + (declaringNodeType == null ? null : declaringNodeType.getName()) + (defaultPrimaryType == null ? null : defaultPrimaryType.getName()))));
            }
            if (currentNode != null) {
                NodeIterator iterator = currentNode.getNodes();
                while (iterator.hasNext()) {
                    NodeDefinition nodeDefinition = iterator.nextNode().getDefinition();
                    NodeType declaringNodeType = nodeDefinition.getDeclaringNodeType();
                    NodeType nodeType = nodeDefinition.getDefaultPrimaryType();
                    if (childNames.contains(nodeDefinition.getName() + (declaringNodeType == null ? null : declaringNodeType.getName()) + (nodeType == null ? null : nodeType.getName()))) continue;
                    childs.add(nodeDefinition);
                }
            }
        }
        HashSet<CallSite> childItemPaths = new HashSet<CallSite>();
        for (Object e : childs) {
            void var14_36;
            Node childNode;
            NodeDefinition nodeDef = e instanceof Node ? ((Node)e).getDefinition() : (NodeDefinition)e;
            if (nodeDef.isAutoCreated() || nodeDef.isProtected()) continue;
            if (((ItemDefinitionImpl)nodeDef).isResidualSet()) {
                for (JcrInputProperty input : childNodeInputs) {
                    String primaryNodeType;
                    NodeType nodeType;
                    String childItemPath = itemPath + "/" + input.getValue();
                    if (!childItemPath.equals(input.getJcrPath()) || !this.canAddNode(nodeDef, nodeType = nodeTypeManger.getNodeType(primaryNodeType = input.getNodetype()))) continue;
                    String[] mixinTypes = null;
                    if (input.getMixintype() != null) {
                        mixinTypes = input.getMixintype().split(",");
                    }
                    if ((childNode = this.doAddNode(currentNode, (String)input.getValue(), nodeType.getName(), mixinTypes)) != null && !childItemPaths.contains(childItemPath)) {
                        this.processNodeRecursively(create, childItemPath, childNode, childNode.getPrimaryNodeType(), jcrVariables);
                    }
                    childItemPaths.add((CallSite)((Object)childItemPath));
                }
                continue;
            }
            Object var14_33 = null;
            if (e instanceof Node) {
                String string = ((Node)e).getName();
            } else {
                String string = ((NodeDefinition)e).getName();
            }
            String newItemPath = itemPath + "/" + (String)var14_36;
            JcrInputProperty jcrInputVariable = (JcrInputProperty)jcrVariables.get(newItemPath);
            if (jcrInputVariable == null) continue;
            String nodeTypeName = jcrInputVariable.getNodetype();
            String[] mixinTypes = null;
            if (jcrInputVariable.getMixintype() != null) {
                mixinTypes = jcrInputVariable.getMixintype().split(",");
            }
            NodeType nodeType = null;
            nodeType = e instanceof Node ? ((Node)e).getPrimaryNodeType() : (nodeTypeName == null || nodeTypeName.length() == 0 ? nodeDef.getRequiredPrimaryTypes()[0] : nodeTypeManger.getNodeType(nodeTypeName));
            childNode = this.doAddNode(currentNode, (String)var14_36, nodeType.getName(), mixinTypes);
            if (!childItemPaths.contains(newItemPath)) {
                this.processNodeRecursively(create, newItemPath, childNode, childNode.getPrimaryNodeType(), jcrVariables);
            }
            childItemPaths.add((CallSite)((Object)newItemPath));
        }
    }

    private void processProperty(String propertyName, Node node, int requiredtype, Object value, boolean isMultiple) throws Exception {
        switch (requiredtype) {
            case 1: {
                if (value == null) {
                    if (isMultiple) {
                        node.setProperty(propertyName, new String[]{""});
                        break;
                    }
                    node.setProperty(propertyName, "");
                    break;
                }
                if (isMultiple) {
                    if (value instanceof String) {
                        node.setProperty(propertyName, new String[]{(String)value});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                if (node.hasProperty(propertyName) && (!node.hasProperty(propertyName) || node.getProperty(propertyName).getString().equals((String)value))) break;
                node.setProperty(propertyName, (String)value);
                break;
            }
            case 2: {
                if (isMultiple) {
                    Node storedNode;
                    Node node2 = storedNode = node.hasNode(propertyName) ? node.getNode(propertyName) : node.addNode(propertyName, "nt:unstructured");
                    if (!(value instanceof Map)) break;
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        String fileName = (String)entry.getKey();
                        List list = (List)entry.getValue();
                        Node fileNode = null;
                        Node jcrContentNode = null;
                        if (!storedNode.hasNode(fileName)) {
                            fileNode = storedNode.addNode(fileName, "nt:file");
                            jcrContentNode = fileNode.addNode("jcr:content", "nt:resource");
                            jcrContentNode.setProperty("jcr:mimeType", (String)list.get(0));
                            jcrContentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream((byte[])list.get(1)));
                        } else {
                            jcrContentNode = storedNode.getNode(fileName).getNode("jcr:content");
                        }
                        jcrContentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                    }
                    break;
                }
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (value instanceof InputStream) {
                    node.setProperty(propertyName, (InputStream)value);
                    break;
                }
                if (value instanceof byte[]) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream((byte[])value));
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, value.toString(), 2);
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value, 2);
                break;
            }
            case 6: {
                if (value == null) {
                    node.setProperty(propertyName, false);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Boolean((String)value).booleanValue());
                    break;
                }
                if (value instanceof String[]) {
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                if (!(value instanceof Boolean)) break;
                node.setProperty(propertyName, ((Boolean)value).booleanValue());
                break;
            }
            case 3: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Long((String)value).longValue());
                    break;
                }
                if (value instanceof String[]) {
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                if (!(value instanceof Long)) break;
                node.setProperty(propertyName, ((Long)value).longValue());
                break;
            }
            case 4: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Double((String)value).doubleValue());
                    break;
                }
                if (value instanceof String[]) {
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                if (!(value instanceof Double)) break;
                node.setProperty(propertyName, ((Double)value).doubleValue());
                break;
            }
            case 5: {
                if (value == null) {
                    boolean mandatory = false;
                    for (PropertyDefinition propertyDefinition : node.getPrimaryNodeType().getPropertyDefinitions()) {
                        if (!propertyName.equals(propertyDefinition.getName()) || !propertyDefinition.isMandatory()) continue;
                        mandatory = true;
                        break;
                    }
                    block13: for (PropertyDefinition propertyDefinition : node.getMixinNodeTypes()) {
                        for (PropertyDefinition propertyDef : propertyDefinition.getPropertyDefinitions()) {
                            if (!propertyName.equals(propertyDef.getName()) || !propertyDef.isMandatory()) continue;
                            mandatory = true;
                            continue block13;
                        }
                    }
                    if (mandatory) {
                        node.setProperty(propertyName, (Calendar)new GregorianCalendar());
                        break;
                    }
                    node.setProperty(propertyName, (Value)null);
                    break;
                }
                if (isMultiple) {
                    Session session = node.getSession();
                    if (value instanceof String) {
                        Value value2add = session.getValueFactory().createValue(ISO8601.parse((String)((String)value)));
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    if (value instanceof String[]) {
                        String[] values = (String[])value;
                        Value[] convertedCalendarValues = new Value[values.length];
                        int i = 0;
                        for (String stringValue : values) {
                            Value value2add;
                            convertedCalendarValues[i] = value2add = session.getValueFactory().createValue(ISO8601.parse((String)stringValue));
                            ++i;
                        }
                        node.setProperty(propertyName, convertedCalendarValues);
                        break;
                    }
                    if (value instanceof GregorianCalendar) {
                        Value value2add = session.getValueFactory().createValue((Calendar)((GregorianCalendar)value));
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    if (!(value instanceof GregorianCalendar[])) break;
                    GregorianCalendar[] values = (GregorianCalendar[])value;
                    Value[] convertedCalendarValues = new Value[values.length];
                    int i = 0;
                    for (GregorianCalendar cvalue : values) {
                        Value value2add;
                        convertedCalendarValues[i] = value2add = session.getValueFactory().createValue((Calendar)cvalue);
                        ++i;
                    }
                    node.setProperty(propertyName, convertedCalendarValues);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, ISO8601.parse((String)((String)value)));
                    break;
                }
                if (!(value instanceof GregorianCalendar)) break;
                node.setProperty(propertyName, (Calendar)((GregorianCalendar)value));
                break;
            }
            case 9: {
                if (value == null) {
                    if (isMultiple) {
                        if (value instanceof String) {
                            node.setProperty(propertyName, "");
                        } else if (value instanceof String[]) {
                            node.setProperty(propertyName, new String[0]);
                        }
                    } else {
                        node.setProperty(propertyName, "");
                    }
                }
                if (value instanceof Value[]) {
                    node.setProperty(propertyName, (Value[])value);
                    break;
                }
                if (value instanceof String) {
                    String referenceWorksapce = null;
                    String referenceNodeName = null;
                    Session session = node.getSession();
                    if (((String)value).indexOf(":/") > -1) {
                        referenceWorksapce = ((String)value).split(":/")[0];
                        referenceNodeName = ((String)value).split(":/")[1];
                        Session session2 = this.jcrService.getCurrentRepository().getSystemSession(referenceWorksapce);
                        Node node3 = session2.getRootNode();
                        if (node3.hasNode(referenceNodeName)) {
                            Node referenceNode = node3.getNode(referenceNodeName);
                            if (referenceNode != null) {
                                if (!referenceNode.isNodeType(MIX_REFERENCEABLE)) {
                                    referenceNode.addMixin(MIX_REFERENCEABLE);
                                    referenceNode.save();
                                }
                                Value value2add = session2.getValueFactory().createValue(referenceNode);
                                node.setProperty(propertyName, value2add);
                            }
                        } else {
                            node.setProperty(propertyName, session2.getValueFactory().createValue((String)value));
                        }
                        session2.logout();
                    } else {
                        Node referenceNode = null;
                        try {
                            referenceNode = (Node)session.getItem((String)value);
                        }
                        catch (PathNotFoundException pathNotFoundException) {
                            referenceNode = session.getRootNode().getNode(value.toString());
                        }
                        if (referenceNode != null) {
                            if (!referenceNode.isNodeType(MIX_REFERENCEABLE)) {
                                referenceNode.addMixin(MIX_REFERENCEABLE);
                                referenceNode.save();
                            }
                            Value value2 = session.getValueFactory().createValue(referenceNode);
                            node.setProperty(propertyName, value2);
                        } else {
                            node.setProperty(propertyName, session.getValueFactory().createValue(value.toString()));
                        }
                    }
                    node.save();
                    break;
                }
                if (!(value instanceof String[])) break;
                String[] values = (String[])value;
                String referenceWorksapce = null;
                String referenceNodeName = null;
                Session session = node.getSession();
                ArrayList<Value> arrayList = new ArrayList<Value>();
                for (String v : values) {
                    Value valueObj = null;
                    if (v.indexOf(":/") > 0) {
                        referenceWorksapce = v.split(":/")[0];
                        referenceNodeName = v.split(":/")[1];
                        Session session2 = this.jcrService.getCurrentRepository().getSystemSession(referenceWorksapce);
                        Node rootNode = session2.getRootNode();
                        if (rootNode.hasNode(referenceNodeName)) {
                            Node referenceNode = rootNode.getNode(referenceNodeName);
                            valueObj = session2.getValueFactory().createValue(referenceNode);
                        } else {
                            valueObj = session2.getValueFactory().createValue(v);
                        }
                        session2.logout();
                    } else {
                        Node rootNode = session.getRootNode();
                        if (rootNode.hasNode(v)) {
                            Node referenceNode = rootNode.getNode(v);
                            valueObj = session.getValueFactory().createValue(referenceNode);
                        } else {
                            valueObj = session.getValueFactory().createValue(v);
                        }
                    }
                    arrayList.add(valueObj);
                }
                node.setProperty(propertyName, arrayList.toArray(new Value[arrayList.size()]));
                break;
            }
            default: {
                throw new RepositoryException("unknown type " + requiredtype);
            }
        }
    }

    private void processProperty(Property property, Node node, int requiredtype, Object value, boolean isMultiple) throws Exception {
        String nodeUUID = "";
        nodeUUID = node.isNodeType(MIX_REFERENCEABLE) ? node.getUUID() : node.getName();
        String propertyName = property.getName();
        String updatedProperty = nodeUUID + "_" + propertyName;
        if (isMultiple) {
            properties.put(updatedProperty, property.getValues());
        } else {
            properties.put(updatedProperty, property.getValue());
        }
        switch (requiredtype) {
            case 1: {
                if (value == null) {
                    if (isMultiple) {
                        node.setProperty(propertyName, new String[]{""});
                        break;
                    }
                    if (property.getValue() == null || property.getValue().getString().equals("")) break;
                    node.setProperty(propertyName, "");
                    break;
                }
                if (isMultiple) {
                    if (value instanceof String) {
                        if (property.getValues().equals(value)) break;
                        node.setProperty(propertyName, new String[]{(String)value});
                        break;
                    }
                    if (!(value instanceof String[]) || this.isEqualsValueStringArrays(property.getValues(), (String[])value)) break;
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                if (property.getValue().getString().equals(value)) break;
                node.setProperty(propertyName, (String)value);
                break;
            }
            case 2: {
                if (isMultiple) {
                    Node storedNode;
                    Node node2 = storedNode = node.hasNode(propertyName) ? node.getNode(propertyName) : node.addNode(propertyName);
                    if (!(value instanceof Map)) break;
                    for (Map.Entry entry : ((Map)value).entrySet()) {
                        String fileName = (String)entry.getKey();
                        List list = (List)entry.getValue();
                        Node fileNode = null;
                        Node jcrContentNode = null;
                        if (!storedNode.hasNode(fileName)) {
                            fileNode = storedNode.addNode(fileName, "nt:file");
                            jcrContentNode = fileNode.addNode("jcr:content");
                            jcrContentNode.setProperty("jcr:mimeType", (String)list.get(0));
                            jcrContentNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream((byte[])list.get(1)));
                        } else {
                            jcrContentNode = storedNode.getNode(fileName).getNode("jcr:content");
                        }
                        jcrContentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
                    }
                    break;
                }
                if (value == null) {
                    if (node.getProperty(propertyName) == null || node.getProperty(propertyName).getString().equals("")) break;
                    node.setProperty(propertyName, "");
                    break;
                }
                if (value instanceof InputStream) {
                    if (property.getValue().getStream().equals(value)) break;
                    node.setProperty(propertyName, (InputStream)value);
                    break;
                }
                if (value instanceof byte[]) {
                    if (property.getValue().getStream().equals(new ByteArrayInputStream((byte[])value))) break;
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream((byte[])value));
                    break;
                }
                if (!(value instanceof String) || property.getValue().getString().equals(value)) break;
                node.setProperty(propertyName, value.toString(), 2);
                break;
            }
            case 6: {
                if (value == null) {
                    node.setProperty(propertyName, false);
                    break;
                }
                if (value instanceof Boolean) {
                    node.setProperty(propertyName, ((Boolean)value).booleanValue());
                    break;
                }
                if (value instanceof String) {
                    if (property.getValue().getBoolean() == new Boolean((String)value).booleanValue()) break;
                    node.setProperty(propertyName, new Boolean((String)value).booleanValue());
                    break;
                }
                if (!(value instanceof String[]) || this.checkEqual(property.getValues(), (String[])value)) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 3: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    if (property.getValue().getLong() == new Long((String)value).longValue()) break;
                    node.setProperty(propertyName, new Long((String)value).longValue());
                    break;
                }
                if (value instanceof String[]) {
                    if (this.checkEqual(property.getValues(), (String[])value)) break;
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                if (!(value instanceof Long)) break;
                node.setProperty(propertyName, ((Long)value).longValue());
                break;
            }
            case 4: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    if (property.getValue().getDouble() == new Double((String)value).doubleValue()) break;
                    node.setProperty(propertyName, new Double((String)value).doubleValue());
                    break;
                }
                if (value instanceof String[]) {
                    if (this.checkEqual(property.getValues(), (String[])value)) break;
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                if (!(value instanceof Double)) break;
                node.setProperty(propertyName, ((Double)value).doubleValue());
                break;
            }
            case 5: {
                if (value == null) {
                    boolean mandatory = false;
                    for (PropertyDefinition propertyDefinition : node.getPrimaryNodeType().getPropertyDefinitions()) {
                        if (!propertyName.equals(propertyDefinition.getName()) || !propertyDefinition.isMandatory()) continue;
                        mandatory = true;
                        break;
                    }
                    block13: for (PropertyDefinition propertyDefinition : node.getMixinNodeTypes()) {
                        for (PropertyDefinition propertyDef : propertyDefinition.getPropertyDefinitions()) {
                            if (!propertyName.equals(propertyDef.getName()) || !propertyDef.isMandatory()) continue;
                            mandatory = true;
                            continue block13;
                        }
                    }
                    if (mandatory) {
                        node.setProperty(propertyName, (Calendar)new GregorianCalendar());
                        break;
                    }
                    if (isMultiple) {
                        node.setProperty(propertyName, (Value[])null);
                        break;
                    }
                    node.setProperty(propertyName, (Value)null);
                    break;
                }
                if (isMultiple) {
                    Session session = node.getSession();
                    if (value instanceof String) {
                        Value value2add = session.getValueFactory().createValue(ISO8601.parse((String)((String)value)));
                        if (property.getValues().equals(new Value[]{value2add})) break;
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    if (value instanceof String[]) {
                        String[] values = (String[])value;
                        Value[] convertedCalendarValues = new Value[values.length];
                        int i = 0;
                        for (String stringValue : values) {
                            Value value2add;
                            convertedCalendarValues[i] = value2add = session.getValueFactory().createValue(ISO8601.parse((String)stringValue));
                            ++i;
                        }
                        if (property.getValues().equals(convertedCalendarValues)) break;
                        node.setProperty(propertyName, convertedCalendarValues);
                        break;
                    }
                    if (value instanceof GregorianCalendar) {
                        Value value2add = session.getValueFactory().createValue((Calendar)((GregorianCalendar)value));
                        if (property.getValues().equals(new Value[]{value2add})) break;
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    if (!(value instanceof GregorianCalendar[])) break;
                    GregorianCalendar[] values = (GregorianCalendar[])value;
                    Value[] convertedCalendarValues = new Value[values.length];
                    int i = 0;
                    for (GregorianCalendar cvalue : values) {
                        Value value2add;
                        convertedCalendarValues[i] = value2add = session.getValueFactory().createValue((Calendar)cvalue);
                        ++i;
                    }
                    if (property.getValues().equals(convertedCalendarValues)) break;
                    node.setProperty(propertyName, convertedCalendarValues);
                    break;
                }
                if (value instanceof String) {
                    if (property.getValue().getString().equals(ISO8601.parse((String)((String)value)))) break;
                    node.setProperty(propertyName, ISO8601.parse((String)((String)value)));
                    break;
                }
                if (!(value instanceof GregorianCalendar) || property.getValue().getDate().equals(value)) break;
                node.setProperty(propertyName, (Calendar)((GregorianCalendar)value));
                break;
            }
            case 9: {
                if (value == null) {
                    if (isMultiple) {
                        if (value instanceof String) {
                            node.setProperty(propertyName, "");
                        } else if (value instanceof String[]) {
                            node.setProperty(propertyName, new String[0]);
                        }
                    } else {
                        node.setProperty(propertyName, "");
                    }
                }
                if (value instanceof Value[]) {
                    if (property.getValues().equals(value)) break;
                    node.setProperty(propertyName, (Value[])value);
                    break;
                }
                if (value instanceof String) {
                    String referenceWorksapce = null;
                    String referenceNodeName = null;
                    Session session = node.getSession();
                    if (((String)value).indexOf(":/") > -1) {
                        referenceWorksapce = ((String)value).split(":/")[0];
                        referenceNodeName = ((String)value).split(":/")[1];
                        Session session2 = this.jcrService.getCurrentRepository().getSystemSession(referenceWorksapce);
                        Node node3 = session2.getRootNode();
                        if (node3.hasNode(referenceNodeName)) {
                            Node referenceNode = node3.getNode(referenceNodeName);
                            Value value2add = session2.getValueFactory().createValue(referenceNode);
                            if (!property.getValue().getString().equals(value2add)) {
                                node.setProperty(propertyName, value2add);
                            }
                        } else if (!property.getValue().getString().equals(session2.getValueFactory().createValue((String)value))) {
                            node.setProperty(propertyName, session2.getValueFactory().createValue((String)value));
                        }
                        session2.logout();
                    } else {
                        Node referenceNode = null;
                        try {
                            referenceNode = (Node)session.getItem((String)value);
                        }
                        catch (PathNotFoundException pathNotFoundException) {
                            referenceNode = session.getRootNode().getNode(value.toString());
                        }
                        if (referenceNode != null) {
                            if (!referenceNode.isNodeType(MIX_REFERENCEABLE)) {
                                referenceNode.addMixin(MIX_REFERENCEABLE);
                                referenceNode.save();
                            }
                            Value value2 = session.getValueFactory().createValue(referenceNode);
                            if (!property.getValue().getString().equals(value2)) {
                                node.setProperty(propertyName, value2);
                            }
                        } else if (!property.getValue().getString().equals(session.getValueFactory().createValue(value.toString()))) {
                            node.setProperty(propertyName, session.getValueFactory().createValue(value.toString()));
                        }
                    }
                    node.save();
                    break;
                }
                if (!(value instanceof String[])) break;
                String[] values = (String[])value;
                String referenceWorksapce = null;
                String referenceNodeName = null;
                Session session = node.getSession();
                ArrayList<Value> arrayList = new ArrayList<Value>();
                for (String v : values) {
                    Value valueObj = null;
                    if (v.indexOf(":/") > 0) {
                        referenceWorksapce = v.split(":/")[0];
                        referenceNodeName = v.split(":/")[1];
                        Session session2 = this.jcrService.getCurrentRepository().getSystemSession(referenceWorksapce);
                        Node rootNode = session2.getRootNode();
                        if (rootNode.hasNode(referenceNodeName)) {
                            Node referenceNode = rootNode.getNode(referenceNodeName);
                            valueObj = session2.getValueFactory().createValue(referenceNode);
                        } else {
                            valueObj = session2.getValueFactory().createValue(v);
                        }
                        session2.logout();
                    } else {
                        Node rootNode = session.getRootNode();
                        if (rootNode.hasNode(v)) {
                            Node referenceNode = rootNode.getNode(v);
                            valueObj = session.getValueFactory().createValue(referenceNode);
                        } else {
                            valueObj = session.getValueFactory().createValue(v);
                        }
                    }
                    arrayList.add(valueObj);
                }
                if (!property.getValues().equals(arrayList.toArray(new Value[arrayList.size()]))) {
                    node.setProperty(propertyName, arrayList.toArray(new Value[arrayList.size()]));
                }
                node.save();
                break;
            }
            default: {
                throw new RepositoryException("unknown type " + requiredtype);
            }
        }
    }

    private String extractNodeName(Set keys) {
        for (String key : keys) {
            if (!key.endsWith("/node")) continue;
            return key;
        }
        return null;
    }

    public boolean isEqualsValueStringArrays(Value[] arrayValue1, String[] arrayValue2) throws ValueFormatException, IllegalStateException, RepositoryException {
        if (arrayValue1 != null) {
            Object[] stringArray = new String[arrayValue1.length];
            int i = 0;
            for (Value valueItem : arrayValue1) {
                if (valueItem != null && valueItem.getString() != null) {
                    stringArray[i] = valueItem.getString();
                }
                ++i;
            }
            if (stringArray != null && stringArray.length > 0) {
                Arrays.sort(stringArray);
            }
            if (arrayValue2 != null && arrayValue2.length > 0) {
                Arrays.sort(arrayValue2);
            }
            return ArrayUtils.isEquals((Object)stringArray, (Object)arrayValue2);
        }
        return arrayValue2 == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void moveNode(String nodePath, String srcWorkspace, String destWorkspace, String destPath) {
        Session srcSession = null;
        Session destSession = null;
        if (!srcWorkspace.equals(destWorkspace)) {
            try {
                Node srcNode;
                block26: {
                    srcSession = this.jcrService.getCurrentRepository().getSystemSession(srcWorkspace);
                    destSession = this.jcrService.getCurrentRepository().getSystemSession(destWorkspace);
                    Workspace workspace = destSession.getWorkspace();
                    srcNode = (Node)srcSession.getItem(nodePath);
                    try {
                        destSession.getItem(destPath);
                    }
                    catch (PathNotFoundException e) {
                        this.createNode(destSession, destPath);
                    }
                    workspace.clone(srcWorkspace, nodePath, destPath, true);
                    try {
                        if (this.activityService == null) {
                            this.activityService = WCMCoreUtils.getService(ActivityCommonService.class);
                        }
                        if (this.listenerService != null && this.activityService.isAcceptedNode(srcNode)) {
                            this.listenerService.broadcast(ActivityCommonService.NODE_MOVED_ACTIVITY, (Object)srcNode, (Object)destPath);
                        }
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) break block26;
                        LOG.error((Object)("Can not notify NodeMovedActivity: " + e.getMessage()));
                    }
                }
                srcNode.remove();
                srcSession.save();
                destSession.save();
                srcSession.logout();
                destSession.logout();
                return;
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) return;
                LOG.warn((Object)e.getMessage());
                return;
            }
            finally {
                if (srcSession != null) {
                    srcSession.logout();
                }
                if (destSession != null) {
                    destSession.logout();
                }
            }
        }
        Session session = null;
        try {
            block27: {
                session = this.jcrService.getCurrentRepository().getSystemSession(srcWorkspace);
                Workspace workspace = session.getWorkspace();
                try {
                    session.getItem(destPath);
                }
                catch (PathNotFoundException e) {
                    this.createNode(session, destPath);
                    session.refresh(false);
                }
                workspace.move(nodePath, destPath);
                try {
                    Node movedNode = (Node)session.getItem(destPath);
                    if (this.activityService == null) {
                        this.activityService = WCMCoreUtils.getService(ActivityCommonService.class);
                    }
                    if (this.listenerService != null && this.activityService.isAcceptedNode(movedNode)) {
                        this.listenerService.broadcast(ActivityCommonService.NODE_MOVED_ACTIVITY, (Object)movedNode, (Object)destPath);
                    }
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block27;
                    LOG.error((Object)("Can not notify NodeMovedActivity: " + e.getMessage()));
                }
            }
            session.logout();
            return;
        }
        catch (Exception e) {
            if (!LOG.isWarnEnabled()) return;
            LOG.warn((Object)e.getMessage());
            return;
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }
    }

    private void createNode(Session session, String uri) throws RepositoryException {
        String[] splittedName = StringUtils.split((String)uri, (String)"/");
        Node rootNode = session.getRootNode();
        for (int i = 0; i < splittedName.length - 1; ++i) {
            try {
                rootNode.getNode(splittedName[i]);
            }
            catch (PathNotFoundException exc) {
                rootNode.addNode(splittedName[i], "nt:unstructured");
                rootNode.save();
            }
            rootNode = rootNode.getNode(splittedName[i]);
        }
    }

    private List<JcrInputProperty> extractNodeInputs(Map<String, JcrInputProperty> map, int itemLevel) {
        ArrayList<JcrInputProperty> list = new ArrayList<JcrInputProperty>();
        for (String jcrPath : map.keySet()) {
            JcrInputProperty input;
            if (itemLevel != StringUtils.countMatches((String)jcrPath, (String)"/") || (input = map.get(jcrPath)).getType() != 1) continue;
            list.add(input);
        }
        return list;
    }

    private boolean canAddNode(NodeDefinition nodeDef, NodeType nodeType) {
        for (NodeType type : nodeDef.getRequiredPrimaryTypes()) {
            if (!nodeType.isNodeType(type.getName())) continue;
            return true;
        }
        return false;
    }

    private Node doAddNode(Node currentNode, String nodeName, String nodeType, String[] mixinTypes) throws Exception {
        if (StringUtils.isEmpty((String)nodeName)) {
            return null;
        }
        Node childNode = null;
        try {
            childNode = currentNode.getNode(nodeName);
        }
        catch (PathNotFoundException pe) {
            childNode = currentNode.addNode(nodeName, nodeType);
        }
        if (mixinTypes != null && mixinTypes.length > 0) {
            for (String mixinName : mixinTypes) {
                if (childNode.isNodeType(mixinName)) continue;
                childNode.addMixin(mixinName);
            }
        }
        return childNode;
    }

    private boolean checkEqual(Value[] arrValues, String[] arrStrings) throws ValueFormatException, IllegalStateException, RepositoryException {
        Validate.isTrue((arrValues != null ? 1 : 0) != 0, (String)"arrValues must not null");
        Validate.isTrue((arrStrings != null ? 1 : 0) != 0, (String)"arrStrings must not null");
        int arrValuesLenth = arrValues.length;
        boolean isEqual = true;
        if (arrValuesLenth != arrStrings.length) {
            isEqual = false;
        } else {
            for (int i = 0; i < arrValuesLenth; ++i) {
                if (arrValues[i].getString().equals(arrStrings[i])) continue;
                isEqual = false;
                break;
            }
        }
        return isEqual;
    }
}

