/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIEditingTagsForm;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/webui/component/explorer/sidebar/UITagExplorer.gtmpl", events={@EventConfig(listeners={ViewTagActionListener.class}), @EventConfig(listeners={EditTagsActionListener.class})}), @ComponentConfig(type=UIPageIterator.class, id="PublicTagPageIterator", template="app:/groovy/webui/component/explorer/sidebar/UITagPageIterator.gtmpl", events={@EventConfig(listeners={UIPageIterator.ShowPageActionListener.class})})})
public class UITagExplorer
extends UIContainer {
    public static final String PUBLIC_TAG_NODE_PATH = "exoPublicTagNode";
    private static final String PRIVATE_TAG_PAGE_ITERATOR_ID = "PrivateTagPageIterator";
    private static final String PUBLIC_TAG_PAGE_ITERATOR_ID = "PublicTagPageIterator";
    private static final int TAG_PAGE_SIZE = 50;
    private int tagScope;
    private UIPageIterator privateTagPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "PrivateTagPageIterator");
    private UIPageIterator publicTagPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "PublicTagPageIterator");
    private NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);

    public int getTagScope() {
        return this.tagScope;
    }

    public void setTagScope(int scope) {
        this.tagScope = scope;
    }

    public List<Node> getPrivateTagLink() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.privateTagPageIterator_.getCurrentPageData());
    }

    public List<Node> getPublicTagLink() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.publicTagPageIterator_.getCurrentPageData());
    }

    public Map<String, String> getTagStyle() throws Exception {
        NewFolksonomyService folksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        String workspace = ((DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class)).getConfig().getSystemWorkspace();
        HashMap<String, String> tagStyle = new HashMap<String, String>();
        for (Node tag : folksonomyService.getAllTagStyle(workspace)) {
            tagStyle.put(tag.getProperty("exo:styleRange").getValue().getString(), tag.getProperty("exo:htmlStyle").getValue().getString());
        }
        return tagStyle;
    }

    public String inverseBGColorByFontColor(String tagStyle) {
        StringBuilder result = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(tagStyle, ":|;", true);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken().trim();
            if (token.equals("color")) {
                token = "background-color";
            } else if (token.equals("background-color")) {
                token = "color";
            }
            result.append(token);
        }
        return result.toString();
    }

    public String getTagHtmlStyle(Node tag) throws Exception {
        int tagCount = (int)tag.getProperty("exo:total").getValue().getLong();
        for (Map.Entry<String, String> entry : this.getTagStyle().entrySet()) {
            if (!this.checkTagRate(tagCount, entry.getKey())) continue;
            String tagStyle = entry.getValue();
            if (this.isTagSelected(tag.getPath())) {
                tagStyle = this.inverseBGColorByFontColor(tagStyle);
            }
            return tagStyle;
        }
        return "";
    }

    public void updateTagList() throws Exception {
        ListAccessImpl privateTagList = new ListAccessImpl(NodeLocation.class, NodeLocation.getLocationsByNodeList((List)this.folksonomyService.getAllPrivateTags(this.getUserName())));
        LazyPageList privatePageList = new LazyPageList((ListAccess)privateTagList, 50);
        this.privateTagPageIterator_.setPageList((PageList)privatePageList);
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        String publicTagNodePath = nodeHierarchyCreator.getJcrPath(PUBLIC_TAG_NODE_PATH);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepo = repositoryService.getCurrentRepository();
        String workspace = manageableRepo.getConfiguration().getDefaultWorkspaceName();
        ListAccessImpl publicTagList = new ListAccessImpl(NodeLocation.class, NodeLocation.getLocationsByNodeList((List)this.folksonomyService.getAllPublicTags(publicTagNodePath, workspace)));
        LazyPageList publicPageList = new LazyPageList((ListAccess)publicTagList, 50);
        this.publicTagPageIterator_.setPageList((PageList)publicPageList);
    }

    public boolean isTagSelected(String tagPath) {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getTagPaths().contains(tagPath);
    }

    public UIPageIterator getPublicPageIterator() {
        return this.publicTagPageIterator_;
    }

    public UIPageIterator getPrivatePageIterator() {
        return this.privateTagPageIterator_;
    }

    private boolean checkTagRate(int numOfDocument, String range) throws Exception {
        String[] vals = StringUtils.split((String)range, (String)"..");
        int minValue = Integer.parseInt(vals[0]);
        int maxValue = vals[1].equals("*") ? Integer.MAX_VALUE : Integer.parseInt(vals[1]);
        return minValue <= numOfDocument && numOfDocument < maxValue;
    }

    public String getRepository() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    public String getWorkspace() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentWorkspace();
    }

    public String getUserName() {
        try {
            return WCMCoreUtils.getRemoteUser();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static class EditTagsActionListener
    extends EventListener<UITagExplorer> {
        public void execute(Event<UITagExplorer> event) throws Exception {
            UITagExplorer uiTagExplorer = (UITagExplorer)((Object)event.getSource());
            NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiTagExplorer.getApplicationComponent(NewFolksonomyService.class);
            String scope = event.getRequestContext().getRequestParameter("objectId");
            int intScope = "Public".equals(scope) ? 0 : 1;
            ((UIJCRExplorer)uiTagExplorer.getAncestorOfType(UIJCRExplorer.class)).setTagScope(intScope);
            List memberships = Utils.getMemberships();
            if (newFolksonomyService.canEditTag(intScope, memberships)) {
                UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTagExplorer.getAncestorOfType(UIJCRExplorer.class);
                UIPopupContainer uiPopupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
                uiPopupContainer.activate(UIEditingTagsForm.class, 600);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
            } else {
                UIApplication uiApp = (UIApplication)uiTagExplorer.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.editTagAccessDenied", null, 1));
                ((UIJCRExplorer)uiTagExplorer.getAncestorOfType(UIJCRExplorer.class)).updateAjax(event);
            }
        }
    }

    public static class ViewTagActionListener
    extends EventListener<UITagExplorer> {
        public void execute(Event<UITagExplorer> event) throws Exception {
            UIDocumentWorkspace uiDocumentWorkspace;
            UISearchResult uiSearchResult;
            UITagExplorer uiTagExplorer = (UITagExplorer)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiTagExplorer.getAncestorOfType(UIApplication.class);
            String tagPath = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiTagExplorer.getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.setTagPath(tagPath);
            UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
            UIDocumentContainer uiDocumentContainer = (UIDocumentContainer)uiExplorer.findFirstComponentOfType(UIDocumentContainer.class);
            if (uiDocumentContainer.isDocumentNode()) {
                Node currentNode = uiExplorer.getCurrentNode();
                uiExplorer.setSelectNode(currentNode.getParent().getPath());
            }
            if ((uiSearchResult = (UISearchResult)(uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).getChildById(UIDocumentWorkspace.SIMPLE_SEARCH_RESULT)) != null && uiSearchResult.isRendered()) {
                uiSearchResult.updateGrid();
            } else {
                uiExplorer.setIsViewTag(uiExplorer.getTagPaths() != null && !uiExplorer.getTagPaths().isEmpty());
                try {
                    uiExplorer.updateAjax(event);
                }
                catch (PathNotFoundException pne) {
                    uiApp.addMessage(new ApplicationMessage("UITaggingForm.msg.path-not-found", null, 1));
                    return;
                }
            }
        }
    }
}

