/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.services.cms.documents.DocumentService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;

@Path(value="/documents")
@Api(tags={"/documents"}, value="/documents", description="Managing documents")
public class DocumentRestService
implements ResourceContainer {
    private DocumentService documentService;
    private static final int DEFAULT_LIMIT = 20;

    public DocumentRestService(DocumentService documentService) {
        this.documentService = documentService;
    }

    @GET
    @Path(value="/favorite")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets favorite documents", httpMethod="GET", response=Response.class, notes="This returns favorite documents")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response getFavoriteDocuments(@ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (limit <= 0) {
            limit = 20;
        }
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        return Response.ok(this.documentService.getFavoriteDocuments(userId, limit)).build();
    }

    @GET
    @Path(value="/folder")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets documents by folder", httpMethod="GET", response=Response.class, notes="This returns documents by folder")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getDocumentsByFolder(@ApiParam(value="Folder from which documents to be retrieved", required=true) @QueryParam(value="folder") String folder, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (folder == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (limit <= 0) {
            limit = 20;
        }
        return Response.ok(this.documentService.getDocumentsByFolder(folder, null, limit)).build();
    }

    @GET
    @Path(value="/query")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets documents by quey", httpMethod="GET", response=Response.class, notes="This returns documents by quey")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getDocumentsByQuery(@ApiParam(value="Query from which documents to be retrieved", required=true) @QueryParam(value="query") String query, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (query == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (limit <= 0) {
            limit = 20;
        }
        return Response.ok(this.documentService.getDocumentsByQuery(query, limit)).build();
    }

    @GET
    @Path(value="/shared")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets shared documents", httpMethod="GET", response=Response.class, notes="This returns shared documents")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled")})
    public Response getSharedDocuments(@ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (limit <= 0) {
            limit = 20;
        }
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        return Response.ok(this.documentService.getSharedDocuments(userId, limit)).build();
    }
}

